/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark;

import ai.chronon.api.DataType;
import ai.chronon.api.DataType$;
import ai.chronon.api.GroupBy;
import ai.chronon.api.Join;
import ai.chronon.api.ThriftJsonCodec$;
import ai.chronon.spark.Analyzer;
import ai.chronon.spark.Analyzer$;
import ai.chronon.spark.SparkSessionBuilder$;
import ai.chronon.spark.TableUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang.exception.ExceptionUtils;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Predef$DummyImplicit$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class MetadataExporter$ {
    public static final MetadataExporter$ MODULE$;
    private final String GROUPBY_PATH_SUFFIX;
    private final String JOIN_PATH_SUFFIX;
    private final ObjectMapper mapper;
    private final TableUtils tableUtils;
    private final String today;
    private final String yesterday;

    static {
        new MetadataExporter$();
    }

    public String GROUPBY_PATH_SUFFIX() {
        return this.GROUPBY_PATH_SUFFIX;
    }

    public String JOIN_PATH_SUFFIX() {
        return this.JOIN_PATH_SUFFIX;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public TableUtils tableUtils() {
        return this.tableUtils;
    }

    private String today() {
        return this.today;
    }

    private String yesterday() {
        return this.yesterday;
    }

    public Seq<String> getFilePaths(String inputPath) {
        File rootDir = new File(inputPath);
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rootDir.listFiles()).filter(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$1) {
                return !x$1.isFile();
            }
        })).flatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<File> apply(File x$2) {
                return Predef$.MODULE$.refArrayOps((Object[])x$2.listFiles());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$3) {
                return x$3.getPath();
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef$DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public String enrichMetadata(String path) {
        Map<String, Object> map2;
        Map<String, Object> configData = this.mapper().readValue(new File(path), Map.class);
        TableUtils x$8 = this.tableUtils();
        String x$9 = path;
        String x$10 = this.yesterday();
        String x$11 = this.today();
        boolean x$12 = true;
        int x$13 = Analyzer$.MODULE$.$lessinit$greater$default$5();
        double x$14 = Analyzer$.MODULE$.$lessinit$greater$default$6();
        boolean x$15 = Analyzer$.MODULE$.$lessinit$greater$default$7();
        Analyzer analyzer = new Analyzer(x$8, x$9, x$10, x$11, x$13, x$14, x$15, x$12);
        try {
            if (path.contains(this.GROUPBY_PATH_SUFFIX())) {
                GroupBy groupBy2 = (GroupBy)ThriftJsonCodec$.MODULE$.fromJsonFile(path, false, ManifestFactory$.MODULE$.classType(GroupBy.class), ClassTag$.MODULE$.apply(GroupBy.class));
                map2 = configData.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("features"), Predef$.MODULE$.refArrayOps((Object[])analyzer.analyzeGroupBy(groupBy2, analyzer.analyzeGroupBy$default$2(), analyzer.analyzeGroupBy$default$3(), analyzer.analyzeGroupBy$default$4())._1()).map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, String> apply(Analyzer.AggregationMetadata x$4) {
                        return x$4.asMap();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class)))));
            } else {
                Join join = (Join)ThriftJsonCodec$.MODULE$.fromJsonFile(path, false, ManifestFactory$.MODULE$.classType(Join.class), ClassTag$.MODULE$.apply(Join.class));
                Tuple3<Map<String, DataType>, ListBuffer<Analyzer.AggregationMetadata>, Map<String, DataType>> joinAnalysis = analyzer.analyzeJoin(join, analyzer.analyzeJoin$default$2(), analyzer.analyzeJoin$default$3());
                Seq featureMetadata = ((TraversableForwarder)joinAnalysis._2()).toSeq().map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, String> apply(Analyzer.AggregationMetadata x$5) {
                        return x$5.asMap();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Map statsSchema = ((TraversableLike)joinAnalysis._3()).map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(Tuple2<String, DataType> st) {
                        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(st._1()), DataType$.MODULE$.toString(st._2()));
                    }
                }, Map$.MODULE$.canBuildFrom());
                map2 = configData.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("features"), featureMetadata)).$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("stats"), statsSchema));
            }
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while processing entity ", ": ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{path, ExceptionUtils.getStackTrace((Throwable)throwable)})));
            map2 = configData;
        }
        Map<String, Object> enrichedData = map2;
        return this.mapper().writeValueAsString(enrichedData);
    }

    public void writeOutput(String data, String path, String outputDirectory) {
        Files.createDirectories(Paths.get(outputDirectory, new String[0]), new FileAttribute[0]);
        File file = new File(new StringBuilder().append((Object)outputDirectory).append((Object)"/").append(Predef$.MODULE$.refArrayOps((Object[])path.split("/")).last()).toString());
        file.createNewFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(data);
        writer.close();
        Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " : Wrote to output directory successfully"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{path})));
    }

    public void processEntities(String inputPath, String outputPath, String suffix) {
        Seq<Tuple3<String, Object, Object>> processSuccess = this.getFilePaths(new StringBuilder().append((Object)inputPath).append((Object)suffix).toString()).map(new Serializable(outputPath, suffix){
            public static final long serialVersionUID = 0L;
            private final String outputPath$1;
            private final String suffix$1;

            public final Tuple3<String, Object, Object> apply(String path) {
                Tuple3<String, Boolean, None$> tuple3;
                try {
                    String data = MetadataExporter$.MODULE$.enrichMetadata(path);
                    MetadataExporter$.MODULE$.writeOutput(data, path, new StringBuilder().append((Object)this.outputPath$1).append((Object)this.suffix$1).toString());
                    tuple3 = new Tuple3<String, Boolean, None$>(path, BoxesRunTime.boxToBoolean(true), None$.MODULE$);
                }
                catch (Throwable throwable) {
                    tuple3 = new Tuple3<String, Boolean, None$>(path, BoxesRunTime.boxToBoolean(false), (None$)((Object)ExceptionUtils.getStackTrace((Throwable)throwable)));
                }
                return tuple3;
            }
            {
                this.outputPath$1 = outputPath$1;
                this.suffix$1 = suffix$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq failuresAndTraces = (Seq)processSuccess.filter((Function1<Tuple3<String, Object, Object>, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple3<String, Object, Object> x$6) {
                return !BoxesRunTime.unboxToBoolean(x$6._2());
            }
        }));
        Predef$.MODULE$.println(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully processed ", " from ", " \\n "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(((SeqLike)processSuccess.filter((Function1<Tuple3<String, Object, Object>, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple3<String, Object, Object> x$7) {
                return BoxesRunTime.unboxToBoolean(x$7._2());
            }
        }))).length()), suffix}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to process ", ": \\n ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(failuresAndTraces.length()), failuresAndTraces.mkString("\n")}))).toString());
    }

    public void run(String inputPath, String outputPath) {
        this.processEntities(inputPath, outputPath, this.GROUPBY_PATH_SUFFIX());
        this.processEntities(inputPath, outputPath, this.JOIN_PATH_SUFFIX());
    }

    private MetadataExporter$() {
        MODULE$ = this;
        this.GROUPBY_PATH_SUFFIX = "/group_bys";
        this.JOIN_PATH_SUFFIX = "/joins";
        this.mapper = new ObjectMapper();
        this.mapper().registerModule(DefaultScalaModule$.MODULE$);
        this.tableUtils = new TableUtils(SparkSessionBuilder$.MODULE$.build("metadata_exporter", SparkSessionBuilder$.MODULE$.build$default$2(), SparkSessionBuilder$.MODULE$.build$default$3(), SparkSessionBuilder$.MODULE$.build$default$4()));
        this.today = this.tableUtils().partitionSpec().at(System.currentTimeMillis());
        this.yesterday = this.tableUtils().partitionSpec().before(this.today());
    }
}

