/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.stats;

import ai.chronon.api.Constants$;
import ai.chronon.api.StructType;
import ai.chronon.online.DataMetrics;
import ai.chronon.online.SparkConversions$;
import ai.chronon.spark.Extensions$;
import ai.chronon.spark.TableUtils;
import ai.chronon.spark.stats.CompareMetrics$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CompareBaseJob$ {
    public static final CompareBaseJob$ MODULE$;

    static {
        new CompareBaseJob$();
    }

    public void checkConsistency(Map<String, DataType> leftFields, Map<String, DataType> rightFields, Seq<String> keys, TableUtils tableUtils, Map<String, String> mapping, boolean migrationCheck) {
        ListBuffer errors = (ListBuffer)ListBuffer$.MODULE$.apply(Nil$.MODULE$);
        boolean sizeCheck = migrationCheck ? leftFields.size() >= rightFields.size() : leftFields.size() == rightFields.size();
        Object object = sizeCheck ? BoxedUnit.UNIT : errors.$plus$eq(new StringOps(Predef$.MODULE$.augmentString(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inconsistent number of fields; left side: ", ", right side: ", "\n                |Left side fields:\n                | - ", "\n                |\n                |Right side fields:\n                | - ", "\n                |"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(leftFields.size()), BoxesRunTime.boxToInteger(rightFields.size()), ((TraversableOnce)leftFields.toSeq().sortBy(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, DataType> x$1) {
                return x$1._1();
            }
        }, Ordering$String$.MODULE$)).mkString("\n - "), ((TraversableOnce)rightFields.toSeq().sortBy(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, DataType> x$2) {
                return x$2._1();
            }
        }, Ordering$String$.MODULE$)).mkString("\n - ")})))).stripMargin());
        Map reverseMapping = mapping.map((Function1<String, String>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, String> x$3) {
                return x$3.swap();
            }
        }), Map$.MODULE$.canBuildFrom());
        rightFields.foreach(new Serializable(leftFields, errors, reverseMapping){
            public static final long serialVersionUID = 0L;
            private final Map leftFields$1;
            private final ListBuffer errors$1;
            private final Map reverseMapping$1;

            public final Object apply(Tuple2<String, DataType> rightField) {
                Object object;
                String leftFieldName;
                String string2 = leftFieldName = this.reverseMapping$1.contains(rightField._1()) ? (String)this.reverseMapping$1.get(rightField._1()).get() : rightField._1();
                if (this.leftFields$1.contains(leftFieldName)) {
                    DataType leftFieldType = (DataType)this.leftFields$1.get(leftFieldName).get();
                    DataType dataType = rightField._2();
                    DataType dataType2 = leftFieldType;
                    object = !(dataType != null ? !dataType.equals(dataType2) : dataType2 != null) ? BoxedUnit.UNIT : this.errors$1.$plus$eq(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Comparison data types do not match for column '", "';"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{leftFieldName}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" left side: ", ", right side: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{leftFieldType, rightField._2()}))).toString());
                } else {
                    object = this.errors$1.$plus$eq(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mapping column on the left table is not present; column name: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{leftFieldName})));
                }
                return object;
            }
            {
                this.leftFields$1 = leftFields$1;
                this.errors$1 = errors$1;
                this.reverseMapping$1 = reverseMapping$1;
            }
        });
        Object object2 = mapping.size() != reverseMapping.size() ? errors.$plus$eq(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mapping values contain duplicate values. Keys: ", ", Values: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{mapping.keys(), mapping.values()}))) : BoxedUnit.UNIT;
        Object object3 = mapping.keySet().subsetOf(leftFields.keySet()) ? BoxedUnit.UNIT : errors.$plus$eq(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid mapping provided missing fields; provided: ", ","})).s(Predef$.MODULE$.genericWrapArray(new Object[]{mapping.keySet()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" expected to be subset of: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{leftFields.keySet()}))).toString());
        Object object4 = mapping.values().toSet().subsetOf(rightFields.keySet()) ? BoxedUnit.UNIT : errors.$plus$eq(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid mapping provided missing fields; provided: ", ","})).s(Predef$.MODULE$.genericWrapArray(new Object[]{mapping.values().toSet()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" expected to be subset of: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{rightFields.keySet()}))).toString());
        ((IterableLike)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Map[]{leftFields, rightFields}))).foreach(new Serializable(keys, errors){
            public static final long serialVersionUID = 0L;
            private final Seq keys$2;
            private final ListBuffer errors$1;

            public final Object apply(Map<String, DataType> kset) {
                return this.keys$2.toSet().subsetOf(kset.keySet()) ? BoxedUnit.UNIT : this.errors$1.$plus$eq(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Some of the primary keys are missing in the source dataframe; provided: ", ","})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.keys$2}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" expected to be subset of: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{kset.keySet()}))).toString());
            }
            {
                this.keys$2 = keys$2;
                this.errors$1 = errors$1;
            }
        });
        Object object5 = ((SeqLike)keys.intersect(Constants$.MODULE$.ReservedColumns(tableUtils.partitionColumn()))).length() == 0 ? errors.$plus$eq("Ensure that one of the key columns is a time column") : BoxedUnit.UNIT;
        Predef$.MODULE$.assert(errors.size() == 0, (Function0<Object>)((Object)new Serializable(errors){
            public static final long serialVersionUID = 0L;
            private final ListBuffer errors$1;

            public final String apply() {
                return this.errors$1.mkString("\n-----------------------------------------------------------------\n");
            }
            {
                this.errors$1 = errors$1;
            }
        }));
    }

    public Map<String, String> checkConsistency$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean checkConsistency$default$6() {
        return false;
    }

    public Tuple3<Dataset<Row>, Dataset<Row>, DataMetrics> compare(Dataset<Row> leftDf, Dataset<Row> rightDf, Seq<String> keys, TableUtils tableUtils, Map<String, String> mapping, boolean migrationCheck) {
        Map<String, DataType> leftFields = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])leftDf.schema().fields()).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, DataType> apply(StructField sb) {
                return new Tuple2<String, DataType>(sb.name(), sb.dataType());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        Map<String, DataType> rightFields = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rightDf.schema().fields()).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, DataType> apply(StructField sb) {
                return new Tuple2<String, DataType>(sb.name(), sb.dataType());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        this.checkConsistency(leftFields, rightFields, keys, tableUtils, mapping, migrationCheck);
        ListBuffer prunedColumns = (ListBuffer)ListBuffer$.MODULE$.apply(Nil$.MODULE$);
        Dataset<Row> prunedLeftDf = migrationCheck ? Predef$.MODULE$.refArrayOps((Object[])leftDf.schema().fieldNames()).foldLeft(leftDf, new Serializable(mapping, rightFields, prunedColumns){
            public static final long serialVersionUID = 0L;
            private final Map mapping$1;
            private final Map rightFields$1;
            private final ListBuffer prunedColumns$1;

            public final Dataset<Row> apply(Dataset<Row> df, String field2) {
                Dataset dataset;
                String rightFieldName;
                String string2 = rightFieldName = this.mapping$1.contains(field2) ? (String)this.mapping$1.get(field2).get() : field2;
                if (this.rightFields$1.contains(rightFieldName)) {
                    dataset = df;
                } else {
                    this.prunedColumns$1.$plus$eq(field2);
                    dataset = df.drop(field2);
                }
                return dataset;
            }
            {
                this.mapping$1 = mapping$1;
                this.rightFields$1 = rightFields$1;
                this.prunedColumns$1 = prunedColumns$1;
            }
        }) : leftDf;
        Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pruning fields from the left source for equivalent comparison - ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{prunedColumns.mkString(",")})));
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Join keys: ", "\n        |Left Schema:\n        |", "\n        |\n        |Right Schema:\n        |", "\n        |\n        |"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{keys.mkString(", "), Extensions$.MODULE$.StructTypeOps(prunedLeftDf.schema()).pretty(), Extensions$.MODULE$.StructTypeOps(rightDf.schema()).pretty()})))).stripMargin());
        Dataset<Row> renamedLeftDf = Predef$.MODULE$.refArrayOps((Object[])prunedLeftDf.schema().fieldNames()).foldLeft(prunedLeftDf, new Serializable(keys){
            public static final long serialVersionUID = 0L;
            private final Seq keys$1;

            public final Dataset<Row> apply(Dataset<Row> df, String field2) {
                return this.keys$1.contains(field2) ? df : df.withColumnRenamed(field2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{field2, CompareMetrics$.MODULE$.leftSuffix()})));
            }
            {
                this.keys$1 = keys$1;
            }
        });
        Extensions$.MODULE$.DataframeOps(renamedLeftDf).validateJoinKeys(rightDf, keys);
        Dataset joinedDf = renamedLeftDf.join(rightDf, keys, "full");
        Dataset<Row> compareDf = Predef$.MODULE$.refArrayOps((Object[])rightDf.schema().fieldNames()).foldLeft(joinedDf, new Serializable(keys){
            public static final long serialVersionUID = 0L;
            private final Seq keys$1;

            public final Dataset<Row> apply(Dataset<Row> df, String field2) {
                return this.keys$1.contains(field2) ? df : df.withColumnRenamed(field2, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{field2, CompareMetrics$.MODULE$.rightSuffix()})));
            }
            {
                this.keys$1 = keys$1;
            }
        });
        StructType leftChrononSchema = new StructType("input", (ai.chronon.api.StructField[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])SparkConversions$.MODULE$.toChrononSchema(prunedLeftDf.schema())).filterNot(new Serializable(keys){
            public static final long serialVersionUID = 0L;
            private final Seq keys$1;

            public final boolean apply(Tuple2<String, ai.chronon.api.DataType> tup) {
                return this.keys$1.contains(tup._1());
            }
            {
                this.keys$1 = keys$1;
            }
        })).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ai.chronon.api.StructField apply(Tuple2<String, ai.chronon.api.DataType> tup) {
                return new ai.chronon.api.StructField(tup._1(), tup._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ai.chronon.api.StructField.class))));
        Tuple2<Dataset<Row>, DataMetrics> tuple2 = CompareMetrics$.MODULE$.compute(leftChrononSchema.fields(), compareDf, keys, mapping, CompareMetrics$.MODULE$.compute$default$5());
        if (tuple2 != null) {
            Tuple2<Dataset<Row>, DataMetrics> tuple22;
            Dataset<Row> metricsDf = tuple2._1();
            DataMetrics metrics = tuple2._2();
            Tuple2<Dataset<Row>, DataMetrics> tuple23 = tuple22 = new Tuple2<Dataset<Row>, DataMetrics>(metricsDf, metrics);
            Dataset<Row> metricsDf2 = tuple23._1();
            DataMetrics metrics2 = tuple23._2();
            return new Tuple3<Dataset<Row>, Dataset<Row>, DataMetrics>(compareDf, metricsDf2, metrics2);
        }
        throw new MatchError(tuple2);
    }

    public Map<String, String> compare$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean compare$default$6() {
        return false;
    }

    private CompareBaseJob$() {
        MODULE$ = this;
    }
}

