/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.spark.streaming;

import ai.chronon.aggregator.base.BottomK;
import ai.chronon.api.DataType;
import ai.chronon.api.Extensions$;
import ai.chronon.api.GroupBy;
import ai.chronon.api.Source;
import ai.chronon.api.UnknownType;
import ai.chronon.spark.Driver$;
import ai.chronon.spark.stats.EditDistance$;
import ai.chronon.spark.streaming.TopicChecker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaFuture;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering$;
import scala.math.Ordering$Double$;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class TopicChecker$ {
    public static final TopicChecker$ MODULE$;

    static {
        new TopicChecker$();
    }

    public int getPartitions(String topic, String bootstrap) {
        Properties props2 = new Properties();
        props2.put("bootstrap.servers", bootstrap);
        AdminClient adminClient = AdminClient.create((Properties)props2);
        KafkaFuture topicDescription = (KafkaFuture)adminClient.describeTopics(Arrays.asList((Object[])new String[]{topic})).values().get(topic);
        return ((TopicDescription)topicDescription.get()).partitions().size();
    }

    public void topicShouldExist(String topic, String bootstrap) {
        Properties props2 = new Properties();
        props2.put("bootstrap.servers", bootstrap);
        try {
            AdminClient adminClient = AdminClient.create((Properties)props2);
            ListTopicsOptions options = new ListTopicsOptions();
            options.listInternal(true);
            ListTopicsResult topicsList = adminClient.listTopics(options);
            Map topicsResult = (Map)topicsList.namesToListings().get();
            if (topicsResult.containsKey(topic)) {
                Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found topic ", " in bootstrap ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic, bootstrap})));
                return;
            }
            BottomK<Tuple2<Object, String>> closestK = new BottomK<Tuple2<Object, String>>((DataType)new UnknownType(BoxedUnit.UNIT), 5, Ordering$.MODULE$.Tuple2(Ordering$Double$.MODULE$, Ordering$String$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class));
            ArrayList result2 = new ArrayList();
            JavaConverters$.MODULE$.asScalaIteratorConverter(topicsResult.entrySet().iterator()).asScala().map(new Serializable(topic){
                public static final long serialVersionUID = 0L;
                private final String topic$1;

                public final Tuple2<Object, String> apply(Map.Entry<String, TopicListing> topicListing) {
                    String existing = topicListing.getValue().name();
                    return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToDouble((double)EditDistance$.MODULE$.betweenStrings(existing, this.topic$1).total() / (double)existing.length())), existing);
                }
                {
                    this.topic$1 = topic$1;
                }
            }).foldLeft(result2, new Serializable(closestK){
                public static final long serialVersionUID = 0L;
                private final BottomK closestK$1;

                public final ArrayList<Tuple2<Object, String>> apply(ArrayList<Tuple2<Object, String>> cnt, Tuple2<Object, String> elem) {
                    return this.closestK$1.update(cnt, elem);
                }
                {
                    this.closestK$1 = closestK$1;
                }
            });
            closestK.finalize(result2);
            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                                      |Requested topic: ", " is not found in broker: ", ".\n                                      |Either the bootstrap is incorrect or the topic is. \n                                      |\n                                      | ------ Most similar topics are ------\n                                      |\n                                      |  ", "\n                                      |\n                                      | ------ End ------\n                                      |"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic, bootstrap, ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result2).asScala()).map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<Object, String> x$1) {
                    return x$1._2();
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString("\n  ")})))).stripMargin());
        }
        catch (Exception exception) {
            throw new RuntimeException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to check for topic ", " in ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic, bootstrap})), exception);
        }
    }

    public void main(String[] argSeq) {
        Tuple2<String, String> tuple2;
        Tuple2<String, String> tuple22;
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        TopicChecker.Args args = new TopicChecker.Args(Predef$.MODULE$.wrapRefArray((Object[])argSeq));
        if (args.conf().isDefined()) {
            ObjectRef<Object> host$lzy = ObjectRef.zero();
            ObjectRef<Object> port$lzy = ObjectRef.zero();
            ObjectRef<Object> hostPort$lzy = ObjectRef.zero();
            String confPath = args.conf().apply();
            GroupBy groupBy2 = (GroupBy)Driver$.MODULE$.parseConf(confPath, ManifestFactory$.MODULE$.classType(GroupBy.class), ClassTag$.MODULE$.apply(GroupBy.class));
            Source source = Extensions$.MODULE$.GroupByOps(groupBy2).streamingSource().get();
            String topic = Extensions$.MODULE$.SourceOps(source).cleanTopic();
            scala.collection.immutable.Map<String, String> tokens = Extensions$.MODULE$.SourceOps(source).topicTokens();
            tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), args.bootstrap().getOrElse((Function0<String>)((Object)new Serializable(tokens, host$lzy, port$lzy, hostPort$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map tokens$1;
                private final ObjectRef host$lzy$1;
                private final ObjectRef port$lzy$1;
                private final ObjectRef hostPort$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final String apply() {
                    return TopicChecker$.MODULE$.ai$chronon$spark$streaming$TopicChecker$$hostPort$1(this.tokens$1, this.host$lzy$1, this.port$lzy$1, this.hostPort$lzy$1, this.bitmap$0$1);
                }
                {
                    this.tokens$1 = tokens$1;
                    this.host$lzy$1 = host$lzy$1;
                    this.port$lzy$1 = port$lzy$1;
                    this.hostPort$lzy$1 = hostPort$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            })));
        } else {
            tuple22 = tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(args.topic().apply()), args.bootstrap().apply());
        }
        if (tuple2 != null) {
            Tuple2<String, String> tuple23;
            String topic = tuple2._1();
            String bootstrap = tuple2._2();
            Tuple2<String, String> tuple24 = tuple23 = new Tuple2<String, String>(topic, bootstrap);
            String topic2 = tuple24._1();
            String bootstrap2 = tuple24._2();
            Predef$.MODULE$.println(BoxesRunTime.boxToInteger(this.getPartitions(topic2, bootstrap2)));
            System.exit(0);
            return;
        }
        throw new MatchError(tuple2);
    }

    private final Option host$lzycompute$1(scala.collection.immutable.Map tokens$1, ObjectRef host$lzy$1, VolatileByteRef bitmap$0$1) {
        TopicChecker$ topicChecker$ = this;
        synchronized (topicChecker$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                host$lzy$1.elem = tokens$1.get("host");
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Option)host$lzy$1.elem;
        }
    }

    private final Option host$1(scala.collection.immutable.Map tokens$1, ObjectRef host$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.host$lzycompute$1(tokens$1, host$lzy$1, bitmap$0$1) : (Option)host$lzy$1.elem;
    }

    private final Option port$lzycompute$1(scala.collection.immutable.Map tokens$1, ObjectRef port$lzy$1, VolatileByteRef bitmap$0$1) {
        TopicChecker$ topicChecker$ = this;
        synchronized (topicChecker$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                port$lzy$1.elem = tokens$1.get("port");
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (Option)port$lzy$1.elem;
        }
    }

    private final Option port$1(scala.collection.immutable.Map tokens$1, ObjectRef port$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.port$lzycompute$1(tokens$1, port$lzy$1, bitmap$0$1) : (Option)port$lzy$1.elem;
    }

    private final String hostPort$lzycompute$1(scala.collection.immutable.Map tokens$1, ObjectRef host$lzy$1, ObjectRef port$lzy$1, ObjectRef hostPort$lzy$1, VolatileByteRef bitmap$0$1) {
        TopicChecker$ topicChecker$ = this;
        synchronized (topicChecker$) {
            if ((byte)(bitmap$0$1.elem & 4) == 0) {
                hostPort$lzy$1.elem = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.host$1(tokens$1, host$lzy$1, bitmap$0$1).get(), this.port$1(tokens$1, port$lzy$1, bitmap$0$1).get()}));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 4);
            }
            return (String)hostPort$lzy$1.elem;
        }
    }

    public final String ai$chronon$spark$streaming$TopicChecker$$hostPort$1(scala.collection.immutable.Map tokens$1, ObjectRef host$lzy$1, ObjectRef port$lzy$1, ObjectRef hostPort$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 4) == 0 ? this.hostPort$lzycompute$1(tokens$1, host$lzy$1, port$lzy$1, hostPort$lzy$1, bitmap$0$1) : (String)hostPort$lzy$1.elem;
    }

    private TopicChecker$() {
        MODULE$ = this;
    }
}

