/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import sun.misc.Unsafe;

public final class UnsafeUtil {
    public static final Unsafe unsafe;
    public static final String JDK;
    static final boolean JDK8_OR_ABOVE;
    public static final int ADDRESS_SIZE;
    public static final long ARRAY_BOOLEAN_BASE_OFFSET;
    public static final long ARRAY_BYTE_BASE_OFFSET;
    public static final long ARRAY_SHORT_BASE_OFFSET;
    public static final long ARRAY_CHAR_BASE_OFFSET;
    public static final long ARRAY_INT_BASE_OFFSET;
    public static final long ARRAY_LONG_BASE_OFFSET;
    public static final long ARRAY_FLOAT_BASE_OFFSET;
    public static final long ARRAY_DOUBLE_BASE_OFFSET;
    public static final long ARRAY_OBJECT_BASE_OFFSET;
    public static final int ARRAY_BOOLEAN_INDEX_SCALE = 1;
    public static final int ARRAY_BYTE_INDEX_SCALE = 1;
    public static final long ARRAY_SHORT_INDEX_SCALE = 2L;
    public static final long ARRAY_CHAR_INDEX_SCALE = 2L;
    public static final long ARRAY_INT_INDEX_SCALE = 4L;
    public static final long ARRAY_LONG_INDEX_SCALE = 8L;
    public static final long ARRAY_FLOAT_INDEX_SCALE = 4L;
    public static final long ARRAY_DOUBLE_INDEX_SCALE = 8L;
    public static final long ARRAY_OBJECT_INDEX_SCALE;
    public static final int BOOLEAN_SHIFT = 0;
    public static final int BYTE_SHIFT = 0;
    public static final long SHORT_SHIFT = 1L;
    public static final long CHAR_SHIFT = 1L;
    public static final long INT_SHIFT = 2L;
    public static final long LONG_SHIFT = 3L;
    public static final long FLOAT_SHIFT = 2L;
    public static final long DOUBLE_SHIFT = 3L;
    public static final long OBJECT_SHIFT;
    public static final String LS;
    static String tryIllegalAccessPermit;

    private UnsafeUtil() {
    }

    static int[] parseJavaVersion(String jdkVer) {
        try {
            String[] parts = jdkVer.trim().split("[^0-9\\.]");
            if (parts.length == 0) {
                throw new ExceptionInInitializerError("Improper Java -version string: " + jdkVer);
            }
            parts = parts[0].split("\\.");
            int p0 = Integer.parseInt(parts[0]);
            int p1 = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
            return new int[]{p0, p1};
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("Improper Java -version string: " + jdkVer + "\n" + e);
        }
    }

    static boolean checkJavaVersion(String jdk, int p0, int p1) {
        if (p0 < 1 || p0 == 1 && p1 < 7) {
            throw new ExceptionInInitializerError("JDK Major Version must be >= 1.7: " + jdk);
        }
        return p0 != 1 || p1 != 7;
    }

    static long getFieldOffset(Class<?> c, String fieldName2) {
        try {
            return unsafe.objectFieldOffset(c.getDeclaredField(fieldName2));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void assertBounds(long reqOff, long reqLen, long allocSize) {
        assert ((reqOff | reqLen | reqOff + reqLen | allocSize - (reqOff + reqLen)) >= 0L) : "reqOffset: " + reqOff + ", reqLength: " + reqLen + ", (reqOff + reqLen): " + (reqOff + reqLen) + ", allocSize: " + allocSize;
    }

    public static void checkBounds(long reqOff, long reqLen, long allocSize) {
        if ((reqOff | reqLen | reqOff + reqLen | allocSize - (reqOff + reqLen)) < 0L) {
            throw new IllegalArgumentException("reqOffset: " + reqOff + ", reqLength: " + reqLen + ", (reqOff + reqLen): " + (reqOff + reqLen) + ", allocSize: " + allocSize);
        }
    }

    static {
        LS = System.getProperty("line.separator");
        tryIllegalAccessPermit = " If using JDK 9+ try setting JVM arg -permit-illegal-access, \u2013illegal-access=permit or equivalent.";
        try {
            Constructor unsafeConstructor = Unsafe.class.getDeclaredConstructor(new Class[0]);
            unsafeConstructor.setAccessible(true);
            unsafe = (Unsafe)unsafeConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to acquire Unsafe. " + tryIllegalAccessPermit, e);
        }
        ADDRESS_SIZE = unsafe.addressSize();
        ARRAY_BOOLEAN_BASE_OFFSET = unsafe.arrayBaseOffset(boolean[].class);
        ARRAY_BYTE_BASE_OFFSET = unsafe.arrayBaseOffset(byte[].class);
        ARRAY_SHORT_BASE_OFFSET = unsafe.arrayBaseOffset(short[].class);
        ARRAY_CHAR_BASE_OFFSET = unsafe.arrayBaseOffset(char[].class);
        ARRAY_INT_BASE_OFFSET = unsafe.arrayBaseOffset(int[].class);
        ARRAY_LONG_BASE_OFFSET = unsafe.arrayBaseOffset(long[].class);
        ARRAY_FLOAT_BASE_OFFSET = unsafe.arrayBaseOffset(float[].class);
        ARRAY_DOUBLE_BASE_OFFSET = unsafe.arrayBaseOffset(double[].class);
        ARRAY_OBJECT_BASE_OFFSET = unsafe.arrayBaseOffset(Object[].class);
        ARRAY_OBJECT_INDEX_SCALE = unsafe.arrayIndexScale(Object[].class);
        OBJECT_SHIFT = ARRAY_OBJECT_INDEX_SCALE == 4L ? 2L : 3L;
        String jdkVer = System.getProperty("java.version");
        int[] p = UnsafeUtil.parseJavaVersion(jdkVer);
        JDK = p[0] + "." + p[1];
        JDK8_OR_ABOVE = UnsafeUtil.checkJavaVersion(JDK, p[0], p[1]);
    }
}

