/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches;

import com.yahoo.memory.Memory;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.ArrayOfItemsSerDe;

public class ArrayOfBooleansSerDe
extends ArrayOfItemsSerDe<Boolean> {
    public static int computeBytesNeeded(int arrayLength) {
        return (arrayLength >>> 3) + ((arrayLength & 7) > 0 ? 1 : 0);
    }

    public byte[] serializeToByteArray(Boolean[] items) {
        int bytesNeeded = ArrayOfBooleansSerDe.computeBytesNeeded(items.length);
        byte[] bytes2 = new byte[bytesNeeded];
        WritableMemory mem = WritableMemory.wrap(bytes2);
        byte val = 0;
        for (int i = 0; i < items.length; ++i) {
            if (items[i].booleanValue()) {
                val = (byte)(val | 1 << (i & 7));
            }
            if ((i & 7) != 7) continue;
            mem.putByte(i >>> 3, val);
            val = 0;
        }
        if ((items.length & 7) > 0) {
            mem.putByte(bytesNeeded - 1, val);
        }
        return bytes2;
    }

    public Boolean[] deserializeFromMemory(Memory mem, int length) {
        int numBytes = ArrayOfBooleansSerDe.computeBytesNeeded(length);
        UnsafeUtil.checkBounds(0L, numBytes, mem.getCapacity());
        Boolean[] array = new Boolean[length];
        byte srcVal = 0;
        int b = 0;
        for (int i = 0; i < length; ++i) {
            if ((i & 7) == 0) {
                srcVal = mem.getByte(b++);
            }
            array[i] = (srcVal >>> (i & 7) & 1) == 1;
        }
        return array;
    }
}

