/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches;

import com.yahoo.memory.Memory;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.ArrayOfItemsSerDe;
import com.yahoo.sketches.SketchesArgumentException;

public class ArrayOfNumbersSerDe
extends ArrayOfItemsSerDe<Number> {
    private static final byte LONG_INDICATOR = 12;
    private static final byte INTEGER_INDICATOR = 9;
    private static final byte SHORT_INDICATOR = 3;
    private static final byte BYTE_INDICATOR = 2;
    private static final byte DOUBLE_INDICATOR = 4;
    private static final byte FLOAT_INDICATOR = 6;

    public byte[] serializeToByteArray(Number[] items) {
        int length = 0;
        for (Number item : items) {
            if (item instanceof Long) {
                length += 9;
                continue;
            }
            if (item instanceof Integer) {
                length += 5;
                continue;
            }
            if (item instanceof Short) {
                length += 3;
                continue;
            }
            if (item instanceof Byte) {
                length += 2;
                continue;
            }
            if (item instanceof Double) {
                length += 9;
                continue;
            }
            if (item instanceof Float) {
                length += 5;
                continue;
            }
            throw new SketchesArgumentException("Item must be one of: Long, Integer, Short, Byte, Double, Float");
        }
        byte[] bytes2 = new byte[length];
        WritableMemory mem = WritableMemory.wrap(bytes2);
        long offsetBytes = 0L;
        for (Number item : items) {
            if (item instanceof Long) {
                mem.putByte(offsetBytes, (byte)12);
                mem.putLong(offsetBytes + 1L, item.longValue());
                offsetBytes += 9L;
                continue;
            }
            if (item instanceof Integer) {
                mem.putByte(offsetBytes, (byte)9);
                mem.putInt(offsetBytes + 1L, item.intValue());
                offsetBytes += 5L;
                continue;
            }
            if (item instanceof Short) {
                mem.putByte(offsetBytes, (byte)3);
                mem.putShort(offsetBytes + 1L, item.shortValue());
                offsetBytes += 3L;
                continue;
            }
            if (item instanceof Byte) {
                mem.putByte(offsetBytes, (byte)2);
                mem.putByte(offsetBytes + 1L, item.byteValue());
                offsetBytes += 2L;
                continue;
            }
            if (item instanceof Double) {
                mem.putByte(offsetBytes, (byte)4);
                mem.putDouble(offsetBytes + 1L, item.doubleValue());
                offsetBytes += 9L;
                continue;
            }
            mem.putByte(offsetBytes, (byte)6);
            mem.putFloat(offsetBytes + 1L, item.floatValue());
            offsetBytes += 5L;
        }
        return bytes2;
    }

    public Number[] deserializeFromMemory(Memory mem, int length) {
        Number[] array = new Number[length];
        long offsetBytes = 0L;
        block8: for (int i = 0; i < length; ++i) {
            UnsafeUtil.checkBounds(offsetBytes, 1L, mem.getCapacity());
            byte numType = mem.getByte(offsetBytes);
            ++offsetBytes;
            switch (numType) {
                case 12: {
                    UnsafeUtil.checkBounds(offsetBytes, 8L, mem.getCapacity());
                    array[i] = mem.getLong(offsetBytes);
                    offsetBytes += 8L;
                    continue block8;
                }
                case 9: {
                    UnsafeUtil.checkBounds(offsetBytes, 4L, mem.getCapacity());
                    array[i] = mem.getInt(offsetBytes);
                    offsetBytes += 4L;
                    continue block8;
                }
                case 3: {
                    UnsafeUtil.checkBounds(offsetBytes, 2L, mem.getCapacity());
                    array[i] = mem.getShort(offsetBytes);
                    offsetBytes += 2L;
                    continue block8;
                }
                case 2: {
                    UnsafeUtil.checkBounds(offsetBytes, 1L, mem.getCapacity());
                    array[i] = mem.getByte(offsetBytes);
                    ++offsetBytes;
                    continue block8;
                }
                case 4: {
                    UnsafeUtil.checkBounds(offsetBytes, 8L, mem.getCapacity());
                    array[i] = mem.getDouble(offsetBytes);
                    offsetBytes += 8L;
                    continue block8;
                }
                case 6: {
                    UnsafeUtil.checkBounds(offsetBytes, 4L, mem.getCapacity());
                    array[i] = Float.valueOf(mem.getFloat(offsetBytes));
                    offsetBytes += 4L;
                    continue block8;
                }
                default: {
                    throw new SketchesArgumentException("Unrecognized entry type reading Number array entry " + i + ": " + numType);
                }
            }
        }
        return array;
    }
}

