/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches;

import com.yahoo.memory.Memory;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.ArrayOfItemsSerDe;
import java.nio.charset.StandardCharsets;

public class ArrayOfStringsSerDe
extends ArrayOfItemsSerDe<String> {
    public byte[] serializeToByteArray(String[] items) {
        int length = 0;
        byte[][] itemsBytes = new byte[items.length][];
        for (int i = 0; i < items.length; ++i) {
            itemsBytes[i] = items[i].getBytes(StandardCharsets.UTF_8);
            length += itemsBytes[i].length + 4;
        }
        byte[] bytes2 = new byte[length];
        WritableMemory mem = WritableMemory.wrap(bytes2);
        long offsetBytes = 0L;
        for (int i = 0; i < items.length; ++i) {
            mem.putInt(offsetBytes, itemsBytes[i].length);
            mem.putByteArray(offsetBytes += 4L, itemsBytes[i], 0, itemsBytes[i].length);
            offsetBytes += (long)itemsBytes[i].length;
        }
        return bytes2;
    }

    public String[] deserializeFromMemory(Memory mem, int numItems) {
        String[] array = new String[numItems];
        long offsetBytes = 0L;
        for (int i = 0; i < numItems; ++i) {
            UnsafeUtil.checkBounds(offsetBytes, 4L, mem.getCapacity());
            int strLength = mem.getInt(offsetBytes);
            byte[] bytes2 = new byte[strLength];
            UnsafeUtil.checkBounds(offsetBytes += 4L, strLength, mem.getCapacity());
            mem.getByteArray(offsetBytes, bytes2, 0, strLength);
            offsetBytes += (long)strLength;
            array[i] = new String(bytes2, StandardCharsets.UTF_8);
        }
        return array;
    }
}

