/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.SketchesStateException;

public final class HashOperations {
    private static final int STRIDE_HASH_BITS = 7;
    private static final int EMPTY = 0;
    public static final int STRIDE_MASK = 127;

    private HashOperations() {
    }

    public static int countPart(long[] srcArr, int lgArrLongs, long thetaLong) {
        int len;
        int cnt = 0;
        int i = len = 1 << lgArrLongs;
        while (i-- > 0) {
            long hash2 = srcArr[i];
            if (HashOperations.continueCondition(thetaLong, hash2)) continue;
            ++cnt;
        }
        return cnt;
    }

    public static int count(long[] srcArr, long thetaLong) {
        int len;
        int cnt = 0;
        int i = len = srcArr.length;
        while (i-- > 0) {
            long hash2 = srcArr[i];
            if (HashOperations.continueCondition(thetaLong, hash2)) continue;
            ++cnt;
        }
        return cnt;
    }

    private static int getStride(long hash2, int lgArrLongs) {
        return 2 * (int)(hash2 >>> lgArrLongs & 0x7FL) + 1;
    }

    public static int hashSearch(long[] hashTable, int lgArrLongs, long hash2) {
        int curProbe;
        if (hash2 == 0L) {
            throw new SketchesArgumentException("Given hash cannot be zero: " + hash2);
        }
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash2, lgArrLongs);
        int loopIndex = curProbe = (int)(hash2 & (long)arrayMask);
        do {
            long arrVal;
            if ((arrVal = hashTable[curProbe]) == 0L) {
                return -1;
            }
            if (arrVal != hash2) continue;
            return curProbe;
        } while ((curProbe = curProbe + stride & arrayMask) != loopIndex);
        return -1;
    }

    public static int hashInsertOnly(long[] hashTable, int lgArrLongs, long hash2) {
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash2, lgArrLongs);
        int curProbe = (int)(hash2 & (long)arrayMask);
        long loopIndex = curProbe;
        do {
            long arrVal;
            if ((arrVal = hashTable[curProbe]) != 0L) continue;
            hashTable[curProbe] = hash2;
            return curProbe;
        } while ((long)(curProbe = curProbe + stride & arrayMask) != loopIndex);
        throw new SketchesArgumentException("No empty slot in table!");
    }

    public static int hashSearchOrInsert(long[] hashTable, int lgArrLongs, long hash2) {
        int curProbe;
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash2, lgArrLongs);
        int loopIndex = curProbe = (int)(hash2 & (long)arrayMask);
        do {
            long arrVal;
            if ((arrVal = hashTable[curProbe]) == 0L) {
                hashTable[curProbe] = hash2;
                return ~curProbe;
            }
            if (arrVal != hash2) continue;
            return curProbe;
        } while ((curProbe = curProbe + stride & arrayMask) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slots!");
    }

    public static int hashArrayInsert(long[] srcArr, long[] hashTable, int lgArrLongs, long thetaLong) {
        int count2 = 0;
        int arrLen = srcArr.length;
        HashOperations.checkThetaCorruption(thetaLong);
        for (int i = 0; i < arrLen; ++i) {
            long hash2 = srcArr[i];
            HashOperations.checkHashCorruption(hash2);
            if (HashOperations.continueCondition(thetaLong, hash2) || HashOperations.hashSearchOrInsert(hashTable, lgArrLongs, hash2) >= 0) continue;
            ++count2;
        }
        return count2;
    }

    public static int hashSearch(Memory mem, int lgArrLongs, long hash2, int memOffsetBytes) {
        int curProbe;
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash2, lgArrLongs);
        int loopIndex = curProbe = (int)(hash2 & (long)arrayMask);
        do {
            int curProbeOffsetBytes;
            long curArrayHash;
            if ((curArrayHash = mem.getLong(curProbeOffsetBytes = (curProbe << 3) + memOffsetBytes)) == 0L) {
                return -1;
            }
            if (curArrayHash != hash2) continue;
            return curProbe;
        } while ((curProbe = curProbe + stride & arrayMask) != loopIndex);
        return -1;
    }

    public static int fastHashInsertOnly(WritableMemory wmem, int lgArrLongs, long hash2, int memOffsetBytes) {
        int curProbe;
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash2, lgArrLongs);
        int loopIndex = curProbe = (int)(hash2 & (long)arrayMask);
        do {
            int curProbeOffsetBytes;
            long curArrayHash;
            if ((curArrayHash = wmem.getLong(curProbeOffsetBytes = (curProbe << 3) + memOffsetBytes)) != 0L) continue;
            wmem.putLong(curProbeOffsetBytes, hash2);
            return curProbe;
        } while ((curProbe = curProbe + stride & arrayMask) != loopIndex);
        throw new SketchesArgumentException("No empty slot in table!");
    }

    public static int fastHashSearchOrInsert(WritableMemory wmem, int lgArrLongs, long hash2, int memOffsetBytes) {
        int curProbe;
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash2, lgArrLongs);
        int loopIndex = curProbe = (int)(hash2 & (long)arrayMask);
        do {
            int curProbeOffsetBytes;
            long curArrayHash;
            if ((curArrayHash = wmem.getLong(curProbeOffsetBytes = (curProbe << 3) + memOffsetBytes)) == 0L) {
                wmem.putLong(curProbeOffsetBytes, hash2);
                return ~curProbe;
            }
            if (curArrayHash != hash2) continue;
            return curProbe;
        } while ((curProbe = curProbe + stride & arrayMask) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slot in table!");
    }

    public static void checkThetaCorruption(long thetaLong) {
        if ((thetaLong | thetaLong - 1L) < 0L) {
            throw new SketchesStateException("Data Corruption: thetaLong was negative or zero: ThetaLong: " + thetaLong);
        }
    }

    public static void checkHashCorruption(long hash2) {
        if (hash2 < 0L) {
            throw new SketchesArgumentException("Data Corruption: hash was negative: Hash: " + hash2);
        }
    }

    public static boolean continueCondition(long thetaLong, long hash2) {
        return (hash2 - 1L | thetaLong - hash2 - 1L) < 0L;
    }
}

