/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.cpc;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.SketchesStateException;
import com.yahoo.sketches.cpc.CpcSketch;
import com.yahoo.sketches.cpc.CpcUtil;
import com.yahoo.sketches.cpc.Flavor;
import com.yahoo.sketches.cpc.PairTable;

public class CpcUnion {
    private final long seed;
    private int lgK;
    private long[] bitMatrix;
    private CpcSketch accumulator;

    public CpcUnion() {
        this(11, 9001L);
    }

    public CpcUnion(int lgK) {
        this(lgK, 9001L);
    }

    public CpcUnion(int lgK, long seed) {
        this.seed = seed;
        this.lgK = lgK;
        this.bitMatrix = null;
        this.accumulator = new CpcSketch(lgK);
    }

    public void update(CpcSketch sketch) {
        CpcUnion.mergeInto(this, sketch);
    }

    public CpcSketch getResult() {
        return CpcUnion.getResult(this);
    }

    public int getLgK() {
        return this.lgK;
    }

    public static Family getFamily() {
        return Family.CPC;
    }

    long getNumCoupons() {
        if (this.bitMatrix != null) {
            return CpcUtil.countBitsSetInMatrix(this.bitMatrix);
        }
        return this.accumulator.numCoupons;
    }

    static long[] getBitMatrix(CpcUnion union2) {
        CpcUnion.checkUnionState(union2);
        return union2.bitMatrix != null ? union2.bitMatrix : CpcUtil.bitMatrixOfSketch(union2.accumulator);
    }

    private static void walkTableUpdatingSketch(CpcSketch dest, PairTable table) {
        int[] slots = table.getSlotsArr();
        int numSlots = 1 << table.getLgSizeInts();
        assert (dest.lgK <= 26);
        int destMask = (1 << dest.lgK) - 1 << 6 | 0x3F;
        int stride = (int)(0.6180339887498949 * (double)numSlots);
        assert (stride >= 2);
        if (stride == stride >>> 1 << 1) {
            ++stride;
        }
        assert (stride >= 3 && stride < numSlots);
        int i = 0;
        int j = 0;
        while (i < numSlots) {
            int rowCol = slots[j &= numSlots - 1];
            if (rowCol != -1) {
                dest.rowColUpdate(rowCol & destMask);
            }
            ++i;
            j += stride;
        }
    }

    private static void orTableIntoMatrix(long[] bitMatrix, int destLgK, PairTable table) {
        int[] slots = table.getSlotsArr();
        int numSlots = 1 << table.getLgSizeInts();
        int destMask = (1 << destLgK) - 1;
        for (int i = 0; i < numSlots; ++i) {
            int rowCol = slots[i];
            if (rowCol == -1) continue;
            int col = rowCol & 0x3F;
            int row = rowCol >>> 6;
            int n = row & destMask;
            bitMatrix[n] = bitMatrix[n] | 1L << col;
        }
    }

    private static void orWindowIntoMatrix(long[] destMatrix, int destLgK, byte[] srcWindow, int srcOffset, int srcLgK) {
        assert (destLgK <= srcLgK);
        int destMask = (1 << destLgK) - 1;
        int srcK = 1 << srcLgK;
        for (int srcRow = 0; srcRow < srcK; ++srcRow) {
            int n = srcRow & destMask;
            destMatrix[n] = destMatrix[n] | ((long)srcWindow[srcRow] & 0xFFL) << srcOffset;
        }
    }

    private static void orMatrixIntoMatrix(long[] destMatrix, int destLgK, long[] srcMatrix, int srcLgK) {
        assert (destLgK <= srcLgK);
        int destMask = (1 << destLgK) - 1;
        int srcK = 1 << srcLgK;
        for (int srcRow = 0; srcRow < srcK; ++srcRow) {
            int n = srcRow & destMask;
            destMatrix[n] = destMatrix[n] | srcMatrix[srcRow];
        }
    }

    private static void reduceUnionK(CpcUnion union2, int newLgK) {
        assert (newLgK < union2.lgK);
        if (union2.bitMatrix != null) {
            int newK = 1 << newLgK;
            long[] newMatrix = new long[newK];
            CpcUnion.orMatrixIntoMatrix(newMatrix, newLgK, union2.bitMatrix, union2.lgK);
            union2.bitMatrix = newMatrix;
            union2.lgK = newLgK;
        } else {
            CpcSketch oldSketch = union2.accumulator;
            if (oldSketch.numCoupons == 0L) {
                union2.accumulator = new CpcSketch(newLgK, oldSketch.seed);
                union2.lgK = newLgK;
                return;
            }
            CpcSketch newSketch = new CpcSketch(newLgK, oldSketch.seed);
            CpcUnion.walkTableUpdatingSketch(newSketch, oldSketch.pairTable);
            Flavor finalNewFlavor = newSketch.getFlavor();
            assert (finalNewFlavor != Flavor.EMPTY);
            if (finalNewFlavor == Flavor.SPARSE) {
                union2.accumulator = newSketch;
                union2.lgK = newLgK;
                return;
            }
            union2.accumulator = null;
            union2.bitMatrix = CpcUtil.bitMatrixOfSketch(newSketch);
            union2.lgK = newLgK;
        }
    }

    private static void mergeInto(CpcUnion union2, CpcSketch source) {
        if (source == null) {
            return;
        }
        CpcUnion.checkSeeds(union2.seed, source.seed);
        int sourceFlavorOrd = source.getFlavor().ordinal();
        if (sourceFlavorOrd == 0) {
            return;
        }
        CpcUnion.checkUnionState(union2);
        if (source.lgK < union2.lgK) {
            CpcUnion.reduceUnionK(union2, source.lgK);
        }
        if (sourceFlavorOrd > 1 && union2.accumulator != null) {
            union2.bitMatrix = CpcUtil.bitMatrixOfSketch(union2.accumulator);
            union2.accumulator = null;
        }
        int state = sourceFlavorOrd - 1 << 1 | (union2.bitMatrix != null ? 1 : 0);
        switch (state) {
            case 0: {
                if (union2.accumulator.getFlavor() == Flavor.EMPTY && union2.lgK == source.lgK) {
                    union2.accumulator = source.copy();
                }
                CpcUnion.walkTableUpdatingSketch(union2.accumulator, source.pairTable);
                if (union2.accumulator.getFlavor().ordinal() <= 1) break;
                union2.bitMatrix = CpcUtil.bitMatrixOfSketch(union2.accumulator);
                union2.accumulator = null;
                break;
            }
            case 1: {
                CpcUnion.orTableIntoMatrix(union2.bitMatrix, union2.lgK, source.pairTable);
                break;
            }
            case 3: 
            case 5: {
                CpcUnion.orWindowIntoMatrix(union2.bitMatrix, union2.lgK, source.slidingWindow, source.windowOffset, source.lgK);
                CpcUnion.orTableIntoMatrix(union2.bitMatrix, union2.lgK, source.pairTable);
                break;
            }
            case 7: {
                long[] sourceMatrix = CpcUtil.bitMatrixOfSketch(source);
                CpcUnion.orMatrixIntoMatrix(union2.bitMatrix, union2.lgK, sourceMatrix, source.lgK);
                break;
            }
            default: {
                throw new SketchesStateException("Illegal Union state: " + state);
            }
        }
    }

    private static CpcSketch getResult(CpcUnion union2) {
        PairTable table;
        int offset;
        long numCoupons;
        CpcUnion.checkUnionState(union2);
        if (union2.accumulator != null) {
            if (union2.accumulator.numCoupons == 0L) {
                CpcSketch result2 = new CpcSketch(union2.lgK, union2.accumulator.seed);
                result2.mergeFlag = true;
                return result2;
            }
            assert (Flavor.SPARSE == union2.accumulator.getFlavor());
            CpcSketch result3 = union2.accumulator.copy();
            result3.mergeFlag = true;
            return result3;
        }
        long[] matrix = union2.bitMatrix;
        int lgK = union2.lgK;
        CpcSketch result4 = new CpcSketch(union2.lgK, union2.seed);
        result4.numCoupons = numCoupons = CpcUtil.countBitsSetInMatrix(matrix);
        Flavor flavor = CpcUtil.determineFlavor(lgK, numCoupons);
        assert (flavor.ordinal() > Flavor.SPARSE.ordinal());
        result4.windowOffset = offset = CpcUtil.determineCorrectOffset(lgK, numCoupons);
        int k = 1 << lgK;
        byte[] window = new byte[k];
        result4.slidingWindow = window;
        int newTableLgSize = Math.max(lgK - 4, 2);
        result4.pairTable = table = new PairTable(newTableLgSize, 6 + lgK);
        long maskForClearingWindow = 255L << offset ^ 0xFFFFFFFFFFFFFFFFL;
        long maskForFlippingEarlyZone = (1L << offset) - 1L;
        long allSurprisesORed = 0L;
        for (int i = 0; i < k; ++i) {
            long pattern = matrix[i];
            window[i] = (byte)(pattern >>> offset & 0xFFL);
            pattern &= maskForClearingWindow;
            allSurprisesORed |= (pattern ^= maskForFlippingEarlyZone);
            while (pattern != 0L) {
                int col = Long.numberOfTrailingZeros(pattern);
                pattern ^= 1L << col;
                int rowCol = i << 6 | col;
                boolean isNovel = PairTable.maybeInsert(table, rowCol);
                assert (isNovel);
            }
        }
        result4.fiCol = Long.numberOfTrailingZeros(allSurprisesORed);
        if (result4.fiCol > offset) {
            result4.fiCol = offset;
        }
        result4.mergeFlag = true;
        return result4;
    }

    private static void checkSeeds(long seedA, long seedB) {
        if (seedA != seedB) {
            throw new SketchesArgumentException("Hash Seeds do not match.");
        }
    }

    private static void checkUnionState(CpcUnion union2) {
        if (union2 == null) {
            throw new SketchesStateException("union cannot be null");
        }
        CpcSketch accumulator = union2.accumulator;
        if (!(accumulator != null ^ union2.bitMatrix != null)) {
            throw new SketchesStateException("accumulator and bitMatrix cannot be both valid or both null: accumValid = " + (accumulator != null) + ", bitMatrixValid = " + (union2.bitMatrix != null));
        }
        if (accumulator != null) {
            if (accumulator.numCoupons > 0L && (accumulator.slidingWindow != null || accumulator.pairTable == null)) {
                throw new SketchesStateException("Non-empty union accumulator must be SPARSE: " + (Object)((Object)accumulator.getFlavor()));
            }
            if (union2.lgK != accumulator.lgK) {
                throw new SketchesStateException("union LgK must equal accumulator LgK");
            }
        }
    }
}

