/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.cpc;

import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.cpc.CpcSketch;
import com.yahoo.sketches.cpc.Flavor;
import com.yahoo.sketches.cpc.PairTable;
import java.util.Arrays;

final class CpcUtil {
    static final int minLgK = 4;
    static final int maxLgK = 26;

    CpcUtil() {
    }

    static void checkLgK(int lgK) {
        if (lgK < 4 || lgK > 26) {
            throw new SketchesArgumentException("LgK must be >= 4 and <= 26: " + lgK);
        }
    }

    static Flavor determineFlavor(int lgK, long numCoupons) {
        long c = numCoupons;
        long k = 1L << lgK;
        long c2 = c << 1;
        long c8 = c << 3;
        long c32 = c << 5;
        if (c == 0L) {
            return Flavor.EMPTY;
        }
        if (c32 < 3L * k) {
            return Flavor.SPARSE;
        }
        if (c2 < k) {
            return Flavor.HYBRID;
        }
        if (c8 < 27L * k) {
            return Flavor.PINNED;
        }
        return Flavor.SLIDING;
    }

    static long[] bitMatrixOfSketch(CpcSketch sketch) {
        int k = 1 << sketch.lgK;
        int offset = sketch.windowOffset;
        assert (offset >= 0 && offset <= 56);
        long[] matrix = new long[k];
        if (sketch.numCoupons == 0L) {
            return matrix;
        }
        long defaultRow = (1L << offset) - 1L;
        Arrays.fill(matrix, defaultRow);
        byte[] window = sketch.slidingWindow;
        if (window != null) {
            for (int i = 0; i < k; ++i) {
                int n = i;
                matrix[n] = matrix[n] | ((long)window[i] & 0xFFL) << offset;
            }
        }
        PairTable table = sketch.pairTable;
        assert (table != null);
        int[] slots = table.getSlotsArr();
        int numSlots = 1 << table.getLgSizeInts();
        for (int i = 0; i < numSlots; ++i) {
            int row;
            int rowCol = slots[i];
            if (rowCol == -1) continue;
            int col = rowCol & 0x3F;
            int n = row = rowCol >>> 6;
            matrix[n] = matrix[n] ^ 1L << col;
        }
        return matrix;
    }

    static long countBitsSetInMatrix(long[] matrix) {
        long count2 = 0L;
        int len = matrix.length;
        for (int i = 0; i < len; ++i) {
            count2 += (long)Long.bitCount(matrix[i]);
        }
        return count2;
    }

    static int determineCorrectOffset(int lgK, long numCoupons) {
        long c = numCoupons;
        long k = 1L << lgK;
        long tmp = (c << 3) - 19L * k;
        if (tmp < 0L) {
            return 0;
        }
        return (int)(tmp >>> lgK + 3);
    }
}

