/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.fdt;

import com.yahoo.sketches.HashOperations;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.fdt.FdtSketch;
import com.yahoo.sketches.fdt.Group;
import com.yahoo.sketches.tuple.SketchIterator;
import com.yahoo.sketches.tuple.strings.ArrayOfStringsSummary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PostProcessor {
    private final FdtSketch sketch;
    private final char sep;
    private int groupCount;
    private Group group;
    private boolean mapValid;
    private final int mapArrSize;
    private final long[] hashArr;
    private final String[] priKeyArr;
    private final int[] counterArr;

    public PostProcessor(FdtSketch sketch, Group group, char sep) {
        this.sketch = sketch;
        this.sep = sep;
        int numEntries = sketch.getRetainedEntries();
        this.mapArrSize = Util.ceilingPowerOf2((int)((double)numEntries / 0.75));
        this.hashArr = new long[this.mapArrSize];
        this.priKeyArr = new String[this.mapArrSize];
        this.counterArr = new int[this.mapArrSize];
        this.mapValid = false;
        this.group = group;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public List<Group> getGroupList(int[] priKeyIndices, int numStdDev, int limit) {
        if (!this.mapValid) {
            this.populateMap(priKeyIndices);
        }
        return this.populateList(numStdDev, limit);
    }

    private void populateMap(int[] priKeyIndices) {
        SketchIterator it = this.sketch.iterator();
        Arrays.fill(this.hashArr, 0L);
        Arrays.fill(this.priKeyArr, null);
        Arrays.fill(this.counterArr, 0);
        this.groupCount = 0;
        int lgMapArrSize = Integer.numberOfTrailingZeros(this.mapArrSize);
        while (it.next()) {
            String[] arr = ((ArrayOfStringsSummary)it.getSummary()).getValue();
            String priKey = PostProcessor.getPrimaryKey(arr, priKeyIndices, this.sep);
            long hash2 = ArrayOfStringsSummary.stringHash(priKey);
            int index = HashOperations.hashSearchOrInsert(this.hashArr, lgMapArrSize, hash2);
            if (index < 0) {
                int idx = -(index + 1);
                this.counterArr[idx] = 1;
                ++this.groupCount;
                this.priKeyArr[idx] = priKey;
                continue;
            }
            int n = index;
            this.counterArr[n] = this.counterArr[n] + 1;
        }
        this.mapValid = true;
    }

    private List<Group> populateList(int numStdDev, int limit) {
        ArrayList<Group> list2 = new ArrayList<Group>();
        for (int i = 0; i < this.mapArrSize; ++i) {
            if (this.hashArr[i] == 0L) continue;
            String priKey = this.priKeyArr[i];
            int count2 = this.counterArr[i];
            double est = this.sketch.getEstimate(count2);
            double ub = this.sketch.getUpperBound(numStdDev, count2);
            double lb = this.sketch.getLowerBound(numStdDev, count2);
            double thresh = (double)count2 / (double)this.sketch.getRetainedEntries();
            double rse = this.sketch.getUpperBound(1, count2) / est - 1.0;
            Group gp = this.group.copy();
            gp.init(priKey, count2, est, ub, lb, thresh, rse);
            list2.add(gp);
        }
        list2.sort(null);
        int totLen = list2.size();
        List<Group> returnList = limit > 0 && limit < totLen ? list2.subList(0, limit) : list2;
        return returnList;
    }

    private static String getPrimaryKey(String[] tuple, int[] priKeyIndices, char sep) {
        assert (priKeyIndices.length < tuple.length);
        StringBuilder sb = new StringBuilder();
        int keys = priKeyIndices.length;
        for (int i = 0; i < keys; ++i) {
            int idx = priKeyIndices[i];
            sb.append(tuple[idx]);
            if (i + 1 >= keys) continue;
            sb.append(sep);
        }
        return sb.toString();
    }
}

