/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hll;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.SketchesStateException;
import com.yahoo.sketches.hll.CouponList;
import com.yahoo.sketches.hll.CurMode;
import com.yahoo.sketches.hll.HllSketchImpl;
import com.yahoo.sketches.hll.PreambleUtil;
import com.yahoo.sketches.hll.TgtHllType;

class CouponHashSet
extends CouponList {
    CouponHashSet(int lgConfigK, TgtHllType tgtHllType) {
        super(lgConfigK, tgtHllType, CurMode.SET);
        assert (lgConfigK > 7);
    }

    CouponHashSet(CouponHashSet that) {
        super(that);
    }

    CouponHashSet(CouponHashSet that, TgtHllType tgtHllType) {
        super(that, tgtHllType);
    }

    static final CouponHashSet heapifySet(Memory mem) {
        int lgConfigK = PreambleUtil.extractLgK(mem);
        TgtHllType tgtHllType = PreambleUtil.extractTgtHllType(mem);
        CurMode curMode = PreambleUtil.extractCurMode(mem);
        int memArrStart = curMode == CurMode.LIST ? PreambleUtil.LIST_INT_ARR_START : PreambleUtil.HASH_SET_INT_ARR_START;
        CouponHashSet set = new CouponHashSet(lgConfigK, tgtHllType);
        set.putOutOfOrderFlag(true);
        boolean memIsCompact = PreambleUtil.extractCompactFlag(mem);
        int couponCount = PreambleUtil.extractHashSetCount(mem);
        int lgCouponArrInts = PreambleUtil.extractLgArr(mem);
        if (lgCouponArrInts < 5) {
            lgCouponArrInts = PreambleUtil.computeLgArr(mem, couponCount, lgConfigK);
        }
        if (memIsCompact) {
            for (int i = 0; i < couponCount; ++i) {
                set.couponUpdate(PreambleUtil.extractInt(mem, memArrStart + (i << 2)));
            }
        } else {
            set.couponCount = couponCount;
            set.lgCouponArrInts = lgCouponArrInts;
            int couponArrInts = 1 << lgCouponArrInts;
            set.couponIntArr = new int[couponArrInts];
            mem.getIntArray(PreambleUtil.HASH_SET_INT_ARR_START, set.couponIntArr, 0, couponArrInts);
        }
        return set;
    }

    @Override
    CouponHashSet copy() {
        return new CouponHashSet(this);
    }

    @Override
    CouponHashSet copyAs(TgtHllType tgtHllType) {
        return new CouponHashSet(this, tgtHllType);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        int index = CouponHashSet.find(this.couponIntArr, this.lgCouponArrInts, coupon);
        if (index >= 0) {
            return this;
        }
        this.couponIntArr[index ^ 0xFFFFFFFF] = coupon;
        ++this.couponCount;
        if (this.checkGrowOrPromote()) {
            return CouponHashSet.promoteHeapListOrSetToHll(this);
        }
        return this;
    }

    @Override
    int getMemDataStart() {
        return PreambleUtil.HASH_SET_INT_ARR_START;
    }

    @Override
    int getPreInts() {
        return 3;
    }

    private boolean checkGrowOrPromote() {
        if (4 * this.couponCount > 3 * (1 << this.lgCouponArrInts)) {
            if (this.lgCouponArrInts == this.lgConfigK - 3) {
                return true;
            }
            this.couponIntArr = CouponHashSet.growHashSet(this.couponIntArr, ++this.lgCouponArrInts);
        }
        return false;
    }

    private static final int[] growHashSet(int[] coupIntArr, int tgtLgCoupArrSize) {
        int[] tgtCouponIntArr = new int[1 << tgtLgCoupArrSize];
        for (int fetched : coupIntArr) {
            if (fetched == 0) continue;
            int idx = CouponHashSet.find(tgtCouponIntArr, tgtLgCoupArrSize, fetched);
            if (idx < 0) {
                tgtCouponIntArr[idx ^ 0xFFFFFFFF] = fetched;
                continue;
            }
            throw new SketchesStateException("Error: found duplicate.");
        }
        return tgtCouponIntArr;
    }
}

