/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hllmap;

import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.hash.MurmurHash3;
import com.yahoo.sketches.hllmap.CouponsIterator;
import com.yahoo.sketches.hllmap.Map;
import java.util.Arrays;

final class CouponHashMap
extends Map {
    private static final double INNER_LOAD_FACTOR = 0.75;
    private static final byte DELETED_KEY_MARKER = -1;
    private static final int BYTE_MASK = 255;
    private static final int COUPON_K = 1024;
    private static final double RSE = 0.408 / Math.sqrt(1024.0);
    private final int maxCouponsPerKey_;
    private final int capacityCouponsPerKey_;
    private final int entrySizeBytes_;
    private int tableEntries_;
    private int capacityEntries_;
    private int numActiveKeys_;
    private int numDeletedKeys_;
    private byte[] keysArr_;
    private short[] couponsArr_;
    private byte[] curCountsArr_;
    private float[] invPow2SumArr_;
    private float[] hipEstAccumArr_;

    private CouponHashMap(int keySizeBytes, int maxCouponsPerKey) {
        super(keySizeBytes);
        this.maxCouponsPerKey_ = maxCouponsPerKey;
        this.capacityCouponsPerKey_ = (int)((double)maxCouponsPerKey * 0.75);
        this.entrySizeBytes_ = keySizeBytes + maxCouponsPerKey * 2 + 1 + 4 + 4;
    }

    static CouponHashMap getInstance(int keySizeBytes, int maxCouponsPerKey) {
        CouponHashMap.checkMaxCouponsPerKey(maxCouponsPerKey);
        int tableEntries = 157;
        CouponHashMap map2 = new CouponHashMap(keySizeBytes, maxCouponsPerKey);
        map2.tableEntries_ = 157;
        map2.capacityEntries_ = 147;
        map2.numActiveKeys_ = 0;
        map2.numDeletedKeys_ = 0;
        map2.keysArr_ = new byte[157 * keySizeBytes];
        map2.couponsArr_ = new short[157 * maxCouponsPerKey];
        map2.curCountsArr_ = new byte[157];
        map2.invPow2SumArr_ = new float[157];
        map2.hipEstAccumArr_ = new float[157];
        return map2;
    }

    @Override
    double update(byte[] key, short coupon) {
        int entryIndex = this.findOrInsertKey(key);
        return this.update(entryIndex, coupon);
    }

    @Override
    double update(int entryIndex, short coupon) {
        int couponMapArrEntryIndex = entryIndex * this.maxCouponsPerKey_;
        int innerCouponIndex = (coupon & 0xFFFF) % this.maxCouponsPerKey_;
        while (this.couponsArr_[couponMapArrEntryIndex + innerCouponIndex] != 0) {
            if (this.couponsArr_[couponMapArrEntryIndex + innerCouponIndex] == coupon) {
                return this.hipEstAccumArr_[entryIndex];
            }
            innerCouponIndex = (innerCouponIndex + 1) % this.maxCouponsPerKey_;
        }
        if ((this.curCountsArr_[entryIndex] + 1 & 0xFF) > this.capacityCouponsPerKey_) {
            return -this.hipEstAccumArr_[entryIndex];
        }
        this.couponsArr_[couponMapArrEntryIndex + innerCouponIndex] = coupon;
        int n = entryIndex;
        this.curCountsArr_[n] = (byte)(this.curCountsArr_[n] + 1);
        int n2 = entryIndex;
        this.hipEstAccumArr_[n2] = this.hipEstAccumArr_[n2] + 1024.0f / this.invPow2SumArr_[entryIndex];
        int n3 = entryIndex;
        this.invPow2SumArr_[n3] = (float)((double)this.invPow2SumArr_[n3] - Util.invPow2(CouponHashMap.coupon16Value(coupon)));
        return this.hipEstAccumArr_[entryIndex];
    }

    @Override
    double getEstimate(byte[] key) {
        int index = this.findKey(key);
        if (index < 0) {
            return 0.0;
        }
        return this.hipEstAccumArr_[index];
    }

    @Override
    double getUpperBound(byte[] key) {
        return this.getEstimate(key) * (1.0 + RSE);
    }

    @Override
    double getLowerBound(byte[] key) {
        return this.getEstimate(key) * (1.0 - RSE);
    }

    @Override
    void updateEstimate(int entryIndex, double estimate) {
        if (entryIndex < 0) {
            throw new SketchesArgumentException("Key not found.");
        }
        this.hipEstAccumArr_[entryIndex] = (float)estimate;
    }

    @Override
    int findKey(byte[] key) {
        long[] hash2 = MurmurHash3.hash(key, 1234567890L);
        int entryIndex = CouponHashMap.getIndex(hash2[0], this.tableEntries_);
        int firstDeletedIndex = -1;
        int loopIndex = entryIndex;
        do {
            if (this.curCountsArr_[entryIndex] == 0) {
                return firstDeletedIndex == -1 ? ~entryIndex : ~firstDeletedIndex;
            }
            if (this.curCountsArr_[entryIndex] == -1) {
                if (firstDeletedIndex != -1) continue;
                firstDeletedIndex = entryIndex;
                continue;
            }
            if (!Map.arraysEqual(this.keysArr_, entryIndex * this.keySizeBytes_, key, 0, this.keySizeBytes_)) continue;
            return entryIndex;
        } while ((entryIndex = (entryIndex + CouponHashMap.getStride(hash2[1], this.tableEntries_)) % this.tableEntries_) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slots!");
    }

    @Override
    int findOrInsertKey(byte[] key) {
        int entryIndex = this.findKey(key);
        if (entryIndex < 0) {
            if (this.curCountsArr_[entryIndex ^= 0xFFFFFFFF] == -1) {
                Arrays.fill(this.couponsArr_, entryIndex * this.maxCouponsPerKey_, (entryIndex + 1) * this.maxCouponsPerKey_, (short)0);
                this.curCountsArr_[entryIndex] = 0;
                --this.numDeletedKeys_;
            }
            if (this.numActiveKeys_ + this.numDeletedKeys_ >= this.capacityEntries_) {
                this.resize();
                entryIndex = ~this.findKey(key);
                assert (entryIndex >= 0);
            }
            System.arraycopy(key, 0, this.keysArr_, entryIndex * this.keySizeBytes_, this.keySizeBytes_);
            this.invPow2SumArr_[entryIndex] = 1024.0f;
            this.hipEstAccumArr_[entryIndex] = 0.0f;
            ++this.numActiveKeys_;
        }
        return entryIndex;
    }

    @Override
    void deleteKey(int entryIndex) {
        this.curCountsArr_[entryIndex] = -1;
        --this.numActiveKeys_;
        ++this.numDeletedKeys_;
        if (this.numActiveKeys_ > 157 && (double)this.numActiveKeys_ < (double)this.tableEntries_ * 0.5) {
            this.resize();
        }
    }

    @Override
    CouponsIterator getCouponsIterator(int entryIndex) {
        return new CouponsIterator(this.couponsArr_, entryIndex * this.maxCouponsPerKey_, this.maxCouponsPerKey_);
    }

    @Override
    double getEntrySizeBytes() {
        return this.entrySizeBytes_;
    }

    @Override
    int getTableEntries() {
        return this.tableEntries_;
    }

    @Override
    int getCapacityEntries() {
        return this.capacityEntries_;
    }

    @Override
    int getCurrentCountEntries() {
        return this.numActiveKeys_ + this.numDeletedKeys_;
    }

    @Override
    long getMemoryUsageBytes() {
        long arrays = (long)this.keysArr_.length + (long)this.couponsArr_.length * 2L + (long)this.curCountsArr_.length + (long)this.invPow2SumArr_.length * 4L + (long)this.hipEstAccumArr_.length * 4L;
        long other = 20L;
        return arrays + 20L;
    }

    @Override
    int getActiveEntries() {
        return this.numActiveKeys_;
    }

    @Override
    int getDeletedEntries() {
        return this.numDeletedKeys_;
    }

    @Override
    int getMaxCouponsPerEntry() {
        return this.maxCouponsPerKey_;
    }

    @Override
    int getCapacityCouponsPerEntry() {
        return this.capacityCouponsPerKey_;
    }

    private static final void checkMaxCouponsPerKey(int maxCouponsPerKey) {
        Util.checkIfPowerOf2(maxCouponsPerKey, "maxCouponsPerKey");
        int cpk = maxCouponsPerKey;
        if (cpk < 16 || cpk > 256) {
            throw new SketchesArgumentException("Required: 16 <= maxCouponsPerKey <= 256 : " + maxCouponsPerKey);
        }
    }

    private void resize() {
        byte[] oldKeysArr = this.keysArr_;
        short[] oldCouponMapArr = this.couponsArr_;
        byte[] oldCurCountsArr = this.curCountsArr_;
        float[] oldInvPow2SumArr = this.invPow2SumArr_;
        float[] oldHipEstAccumArr = this.hipEstAccumArr_;
        int oldNumEntries = this.tableEntries_;
        this.tableEntries_ = Math.max(CouponHashMap.nextPrime((int)((double)this.numActiveKeys_ / 0.6666666666666666)), 157);
        this.capacityEntries_ = (int)((double)this.tableEntries_ * 0.9375);
        this.keysArr_ = new byte[this.tableEntries_ * this.keySizeBytes_];
        this.couponsArr_ = new short[this.tableEntries_ * this.maxCouponsPerKey_];
        this.curCountsArr_ = new byte[this.tableEntries_];
        this.invPow2SumArr_ = new float[this.tableEntries_];
        this.hipEstAccumArr_ = new float[this.tableEntries_];
        this.numActiveKeys_ = 0;
        this.numDeletedKeys_ = 0;
        for (int i = 0; i < oldNumEntries; ++i) {
            if (oldCurCountsArr[i] == 0 || oldCurCountsArr[i] == -1) continue;
            byte[] key = Arrays.copyOfRange(oldKeysArr, i * this.keySizeBytes_, i * this.keySizeBytes_ + this.keySizeBytes_);
            int index = this.insertKey(key);
            System.arraycopy(oldCouponMapArr, i * this.maxCouponsPerKey_, this.couponsArr_, index * this.maxCouponsPerKey_, this.maxCouponsPerKey_);
            this.curCountsArr_[index] = oldCurCountsArr[i];
            this.invPow2SumArr_[index] = oldInvPow2SumArr[i];
            this.hipEstAccumArr_[index] = oldHipEstAccumArr[i];
        }
    }

    private int insertKey(byte[] key) {
        int entryIndex;
        long[] hash2 = MurmurHash3.hash(key, 1234567890L);
        int loopIndex = entryIndex = CouponHashMap.getIndex(hash2[0], this.tableEntries_);
        do {
            if (this.curCountsArr_[entryIndex] != 0) continue;
            System.arraycopy(key, 0, this.keysArr_, entryIndex * this.keySizeBytes_, this.keySizeBytes_);
            ++this.numActiveKeys_;
            return entryIndex;
        } while ((entryIndex = (entryIndex + CouponHashMap.getStride(hash2[1], this.tableEntries_)) % this.tableEntries_) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slots!");
    }
}

