/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hllmap;

import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.hash.MurmurHash3;
import com.yahoo.sketches.hllmap.CouponsIterator;
import com.yahoo.sketches.hllmap.Map;
import java.util.Arrays;

final class HllMap
extends Map {
    private static final double LOAD_FACTOR = 0.9375;
    private static final int HLL_INIT_NUM_ENTRIES = 157;
    private static final float HLL_RESIZE_FACTOR = 2.0f;
    private static final double RSE = Math.sqrt(Math.log(2.0)) / 32.0;
    private final int k_;
    private final int hllArrLongs_;
    private int tableEntries_;
    private int capacityEntries_;
    private int curCountEntries_;
    private float growthFactor_;
    private double entrySizeBytes_;
    private byte[] keysArr_;
    private long[] arrOfHllArr_;
    private double[] invPow2SumHiArr_;
    private double[] invPow2SumLoArr_;
    private double[] hipEstAccumArr_;
    private byte[] stateArr_;

    private HllMap(int keySizeBytes, int k) {
        super(keySizeBytes);
        this.k_ = k;
        this.hllArrLongs_ = k / 10 + 1;
    }

    static HllMap getInstance(int keySizeBytes, int k) {
        int tableEntries = 157;
        HllMap map2 = new HllMap(keySizeBytes, k);
        map2.tableEntries_ = 157;
        map2.capacityEntries_ = 147;
        map2.curCountEntries_ = 0;
        map2.growthFactor_ = 2.0f;
        map2.entrySizeBytes_ = HllMap.updateEntrySizeBytes(map2.tableEntries_, keySizeBytes, map2.hllArrLongs_);
        map2.keysArr_ = new byte[157 * map2.keySizeBytes_];
        map2.arrOfHllArr_ = new long[157 * map2.hllArrLongs_];
        map2.invPow2SumHiArr_ = new double[157];
        map2.invPow2SumLoArr_ = new double[157];
        map2.hipEstAccumArr_ = new double[157];
        map2.stateArr_ = new byte[(int)Math.ceil(19.625)];
        return map2;
    }

    @Override
    double update(byte[] key, short coupon) {
        int entryIndex = this.findOrInsertKey(key);
        return this.update(entryIndex, coupon);
    }

    @Override
    double update(int entryIndex, short coupon) {
        this.updateHll(entryIndex, coupon);
        return this.hipEstAccumArr_[entryIndex];
    }

    @Override
    double getEstimate(byte[] key) {
        if (key == null) {
            return Double.NaN;
        }
        int entryIndex = this.findKey(key);
        if (entryIndex < 0) {
            return 0.0;
        }
        return this.hipEstAccumArr_[entryIndex];
    }

    @Override
    double getUpperBound(byte[] key) {
        return this.getEstimate(key) * (1.0 + RSE);
    }

    @Override
    double getLowerBound(byte[] key) {
        return this.getEstimate(key) * (1.0 - RSE);
    }

    @Override
    void updateEstimate(int entryIndex, double estimate) {
        this.hipEstAccumArr_[entryIndex] = estimate;
    }

    @Override
    final int findKey(byte[] key) {
        int keyLen = key.length;
        long[] hash2 = MurmurHash3.hash(key, 1234567890L);
        int entryIndex = HllMap.getIndex(hash2[0], this.tableEntries_);
        int stride = HllMap.getStride(hash2[1], this.tableEntries_);
        int loopIndex = entryIndex;
        do {
            if (HllMap.isBitClear(this.stateArr_, entryIndex)) {
                return ~entryIndex;
            }
            if (!HllMap.arraysEqual(key, 0, this.keysArr_, entryIndex * keyLen, keyLen)) continue;
            return entryIndex;
        } while ((entryIndex = (entryIndex + stride) % this.tableEntries_) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slots!");
    }

    @Override
    int findOrInsertKey(byte[] key) {
        int entryIndex = this.findKey(key);
        if (entryIndex < 0) {
            System.arraycopy(key, 0, this.keysArr_, (entryIndex ^= 0xFFFFFFFF) * this.keySizeBytes_, this.keySizeBytes_);
            HllMap.setBit(this.stateArr_, entryIndex);
            this.invPow2SumHiArr_[entryIndex] = this.k_;
            this.invPow2SumLoArr_[entryIndex] = 0.0;
            this.hipEstAccumArr_[entryIndex] = 0.0;
            ++this.curCountEntries_;
            if (this.curCountEntries_ > this.capacityEntries_) {
                this.resize();
                entryIndex = this.findKey(key);
                assert (entryIndex >= 0);
            }
        }
        return entryIndex;
    }

    @Override
    double getEntrySizeBytes() {
        return this.entrySizeBytes_;
    }

    @Override
    int getTableEntries() {
        return this.tableEntries_;
    }

    @Override
    int getCapacityEntries() {
        return this.capacityEntries_;
    }

    @Override
    int getCurrentCountEntries() {
        return this.curCountEntries_;
    }

    @Override
    long getMemoryUsageBytes() {
        long arrays = (long)this.keysArr_.length + (long)this.arrOfHllArr_.length * 8L + (long)this.invPow2SumLoArr_.length * 8L + (long)this.invPow2SumHiArr_.length * 8L + (long)this.hipEstAccumArr_.length * 8L + (long)this.stateArr_.length;
        long other = 32L;
        return arrays + 32L;
    }

    @Override
    CouponsIterator getCouponsIterator(int index) {
        return null;
    }

    @Override
    int getMaxCouponsPerEntry() {
        return 0;
    }

    @Override
    int getCapacityCouponsPerEntry() {
        return 0;
    }

    @Override
    int getActiveEntries() {
        return this.curCountEntries_;
    }

    @Override
    int getDeletedEntries() {
        return 0;
    }

    private static final int findEmpty(byte[] key, int tableEntries, byte[] stateArr) {
        long[] hash2 = MurmurHash3.hash(key, 1234567890L);
        int entryIndex = HllMap.getIndex(hash2[0], tableEntries);
        int stride = HllMap.getStride(hash2[1], tableEntries);
        int loopIndex = entryIndex;
        do {
            if (!HllMap.isBitClear(stateArr, entryIndex)) continue;
            return entryIndex;
        } while ((entryIndex = (entryIndex + stride) % tableEntries) != loopIndex);
        throw new SketchesArgumentException("No empty slots.");
    }

    private final boolean updateHll(int entryIndex, int coupon) {
        int shift;
        int hllIdx;
        int longIdx;
        long hllLong;
        int oldValue;
        int newValue = HllMap.coupon16Value(coupon);
        if (newValue <= (oldValue = (int)((hllLong = this.arrOfHllArr_[entryIndex * this.hllArrLongs_ + (longIdx = (hllIdx = coupon & this.k_ - 1) / 10)]) >>> (shift = hllIdx % 10 * 6 & 0x3F)) & 0x3F)) {
            return false;
        }
        double invPow2Sum = this.invPow2SumHiArr_[entryIndex] + this.invPow2SumLoArr_[entryIndex];
        double oneOverQ = (double)this.k_ / invPow2Sum;
        int n = entryIndex;
        this.hipEstAccumArr_[n] = this.hipEstAccumArr_[n] + oneOverQ;
        if (oldValue < 32) {
            int n2 = entryIndex;
            this.invPow2SumHiArr_[n2] = this.invPow2SumHiArr_[n2] - Util.invPow2(oldValue);
        } else {
            int n3 = entryIndex;
            this.invPow2SumLoArr_[n3] = this.invPow2SumLoArr_[n3] - Util.invPow2(oldValue);
        }
        if (newValue < 32) {
            int n4 = entryIndex;
            this.invPow2SumHiArr_[n4] = this.invPow2SumHiArr_[n4] + Util.invPow2(newValue);
        } else {
            int n5 = entryIndex;
            this.invPow2SumLoArr_[n5] = this.invPow2SumLoArr_[n5] + Util.invPow2(newValue);
        }
        hllLong &= 63L << shift ^ 0xFFFFFFFFFFFFFFFFL;
        this.arrOfHllArr_[entryIndex * this.hllArrLongs_ + longIdx] = hllLong |= (long)newValue << shift;
        return true;
    }

    private final void resize() {
        int newTableEntries = HllMap.nextPrime((int)((float)this.tableEntries_ * this.growthFactor_));
        int newCapacityEntries = (int)((double)newTableEntries * 0.9375);
        byte[] newKeysArr = new byte[newTableEntries * this.keySizeBytes_];
        long[] newArrOfHllArr = new long[newTableEntries * this.hllArrLongs_];
        double[] newInvPow2Sum1 = new double[newTableEntries];
        double[] newInvPow2Sum2 = new double[newTableEntries];
        double[] newHipEstAccum = new double[newTableEntries];
        byte[] newStateArr = new byte[(int)Math.ceil((double)newTableEntries / 8.0)];
        for (int oldIndex = 0; oldIndex < this.tableEntries_; ++oldIndex) {
            if (HllMap.isBitClear(this.stateArr_, oldIndex)) continue;
            byte[] key = Arrays.copyOfRange(this.keysArr_, oldIndex * this.keySizeBytes_, (oldIndex + 1) * this.keySizeBytes_);
            int newIndex = HllMap.findEmpty(key, newTableEntries, newStateArr);
            System.arraycopy(key, 0, newKeysArr, newIndex * this.keySizeBytes_, this.keySizeBytes_);
            System.arraycopy(this.arrOfHllArr_, oldIndex * this.hllArrLongs_, newArrOfHllArr, newIndex * this.hllArrLongs_, this.hllArrLongs_);
            newInvPow2Sum1[newIndex] = this.invPow2SumHiArr_[oldIndex];
            newInvPow2Sum2[newIndex] = this.invPow2SumLoArr_[oldIndex];
            newHipEstAccum[newIndex] = this.hipEstAccumArr_[oldIndex];
            HllMap.setBit(newStateArr, newIndex);
        }
        this.tableEntries_ = newTableEntries;
        this.capacityEntries_ = newCapacityEntries;
        this.entrySizeBytes_ = HllMap.updateEntrySizeBytes(this.tableEntries_, this.keySizeBytes_, this.hllArrLongs_);
        this.keysArr_ = newKeysArr;
        this.arrOfHllArr_ = newArrOfHllArr;
        this.invPow2SumHiArr_ = newInvPow2Sum1;
        this.invPow2SumLoArr_ = newInvPow2Sum2;
        this.hipEstAccumArr_ = newHipEstAccum;
        this.stateArr_ = newStateArr;
    }

    private static final double updateEntrySizeBytes(int tableEntries, int keySizeBytes, int hllArrLongs) {
        double byteFraction = Math.ceil((double)tableEntries / 8.0) / (double)tableEntries;
        return (double)keySizeBytes + (double)hllArrLongs * 8.0 + 24.0 + byteFraction;
    }
}

