/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.sketches.QuantilesHelper;
import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.DoublesSketchAccessor;
import com.yahoo.sketches.quantiles.Util;
import java.util.Arrays;

final class DoublesAuxiliary {
    long auxN_;
    double[] auxSamplesArr_;
    long[] auxCumWtsArr_;

    DoublesAuxiliary(DoublesSketch qs) {
        int k = qs.getK();
        long n = qs.getN();
        long bitPattern = qs.getBitPattern();
        int numSamples = qs.getRetainedItems();
        DoublesSketchAccessor sketchAccessor = DoublesSketchAccessor.wrap(qs);
        double[] itemsArr = new double[numSamples];
        long[] cumWtsArr = new long[numSamples + 1];
        DoublesAuxiliary.populateFromDoublesSketch(k, n, bitPattern, sketchAccessor, itemsArr, cumWtsArr);
        DoublesAuxiliary.blockyTandemMergeSort(itemsArr, cumWtsArr, numSamples, k);
        long total2 = QuantilesHelper.convertToPrecedingCummulative(cumWtsArr);
        assert (total2 == n);
        this.auxN_ = n;
        this.auxSamplesArr_ = itemsArr;
        this.auxCumWtsArr_ = cumWtsArr;
    }

    double getQuantile(double fRank) {
        Util.checkFractionalRankBounds(fRank);
        long pos = QuantilesHelper.posOfPhi(fRank, this.auxN_);
        return this.approximatelyAnswerPositionalQuery(pos);
    }

    private double approximatelyAnswerPositionalQuery(long pos) {
        assert (0L <= pos);
        assert (pos < this.auxN_);
        int index = QuantilesHelper.chunkContainingPos(this.auxCumWtsArr_, pos);
        return this.auxSamplesArr_[index];
    }

    private static final void populateFromDoublesSketch(int k, long n, long bitPattern, DoublesSketchAccessor sketchAccessor, double[] itemsArr, long[] cumWtsArr) {
        int i;
        long bits2;
        long weight = 1L;
        int nxt = 0;
        assert (bits2 == n / (2L * (long)k));
        int lvl = 0;
        for (bits2 = bitPattern; bits2 != 0L; bits2 >>>= 1) {
            weight *= 2L;
            if ((bits2 & 1L) > 0L) {
                sketchAccessor.setLevel(lvl);
                for (i = 0; i < sketchAccessor.numItems(); ++i) {
                    itemsArr[nxt] = sketchAccessor.get(i);
                    cumWtsArr[nxt] = weight;
                    ++nxt;
                }
            }
            ++lvl;
        }
        weight = 1L;
        int startOfBaseBufferBlock = nxt;
        sketchAccessor.setLevel(-1);
        for (i = 0; i < sketchAccessor.numItems(); ++i) {
            itemsArr[nxt] = sketchAccessor.get(i);
            cumWtsArr[nxt] = weight;
            ++nxt;
        }
        assert (nxt == itemsArr.length);
        int numSamples = nxt;
        Arrays.sort(itemsArr, startOfBaseBufferBlock, numSamples);
        cumWtsArr[numSamples] = 0L;
    }

    static void blockyTandemMergeSort(double[] keyArr, long[] valArr, int arrLen, int blkSize) {
        assert (blkSize >= 1);
        if (arrLen <= blkSize) {
            return;
        }
        int numblks = arrLen / blkSize;
        if (numblks * blkSize < arrLen) {
            ++numblks;
        }
        assert (numblks * blkSize >= arrLen);
        double[] keyTmp = Arrays.copyOf(keyArr, arrLen);
        long[] valTmp = Arrays.copyOf(valArr, arrLen);
        DoublesAuxiliary.blockyTandemMergeSortRecursion(keyTmp, valTmp, keyArr, valArr, 0, numblks, blkSize, arrLen);
    }

    private static void blockyTandemMergeSortRecursion(double[] keySrc, long[] valSrc, double[] keyDst, long[] valDst, int grpStart, int grpLen, int blkSize, int arrLim) {
        assert (grpLen > 0);
        if (grpLen == 1) {
            return;
        }
        int grpLen1 = grpLen / 2;
        int grpLen2 = grpLen - grpLen1;
        assert (grpLen1 >= 1);
        assert (grpLen2 >= grpLen1);
        int grpStart1 = grpStart;
        int grpStart2 = grpStart + grpLen1;
        DoublesAuxiliary.blockyTandemMergeSortRecursion(keyDst, valDst, keySrc, valSrc, grpStart1, grpLen1, blkSize, arrLim);
        DoublesAuxiliary.blockyTandemMergeSortRecursion(keyDst, valDst, keySrc, valSrc, grpStart2, grpLen2, blkSize, arrLim);
        int arrStart1 = grpStart1 * blkSize;
        int arrStart2 = grpStart2 * blkSize;
        int arrLen1 = grpLen1 * blkSize;
        int arrLen2 = grpLen2 * blkSize;
        if (arrStart2 + arrLen2 > arrLim) {
            arrLen2 = arrLim - arrStart2;
        }
        DoublesAuxiliary.tandemMerge(keySrc, valSrc, arrStart1, arrLen1, arrStart2, arrLen2, keyDst, valDst, arrStart1);
    }

    private static void tandemMerge(double[] keySrc, long[] valSrc, int arrStart1, int arrLen1, int arrStart2, int arrLen2, double[] keyDst, long[] valDst, int arrStart3) {
        int arrStop1 = arrStart1 + arrLen1;
        int arrStop2 = arrStart2 + arrLen2;
        int i1 = arrStart1;
        int i2 = arrStart2;
        int i3 = arrStart3;
        while (i1 < arrStop1 && i2 < arrStop2) {
            if (keySrc[i2] < keySrc[i1]) {
                keyDst[i3] = keySrc[i2];
                valDst[i3] = valSrc[i2];
                ++i2;
            } else {
                keyDst[i3] = keySrc[i1];
                valDst[i3] = valSrc[i1];
                ++i1;
            }
            ++i3;
        }
        if (i1 < arrStop1) {
            System.arraycopy(keySrc, i1, keyDst, i3, arrStop1 - i1);
            System.arraycopy(valSrc, i1, valDst, i3, arrStop1 - i1);
        } else {
            assert (i2 < arrStop2);
            System.arraycopy(keySrc, i2, keyDst, i3, arrStop2 - i2);
            System.arraycopy(valSrc, i2, valDst, i3, arrStop2 - i2);
        }
    }
}

