/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.DoublesSketchAccessor;
import com.yahoo.sketches.quantiles.PreambleUtil;
import com.yahoo.sketches.quantiles.Util;
import java.util.Arrays;

final class DoublesByteArrayImpl {
    private DoublesByteArrayImpl() {
    }

    static byte[] toByteArray(DoublesSketch sketch, boolean ordered, boolean compact) {
        boolean empty = sketch.isEmpty();
        int flags = (empty ? 4 : 0) | (ordered ? 16 : 0) | (compact ? 10 : 0);
        if (empty && !sketch.isDirect()) {
            byte[] outByteArr = new byte[8];
            WritableMemory memOut = WritableMemory.wrap(outByteArr);
            boolean preLongs = true;
            DoublesByteArrayImpl.insertPre0(memOut, 1, flags, sketch.getK());
            return outByteArr;
        }
        return DoublesByteArrayImpl.convertToByteArray(sketch, flags, ordered, compact);
    }

    private static byte[] convertToByteArray(DoublesSketch sketch, int flags, boolean ordered, boolean compact) {
        int preLongs = 2;
        int extra = 2;
        int prePlusExtraBytes = 32;
        int k = sketch.getK();
        long n = sketch.getN();
        DoublesSketchAccessor dsa = DoublesSketchAccessor.wrap(sketch, !compact);
        int outBytes = compact ? sketch.getCompactStorageBytes() : sketch.getUpdatableStorageBytes();
        byte[] outByteArr = new byte[outBytes];
        WritableMemory memOut = WritableMemory.wrap(outByteArr);
        DoublesByteArrayImpl.insertPre0(memOut, 2, flags, k);
        if (sketch.isEmpty()) {
            return outByteArr;
        }
        PreambleUtil.insertN(memOut, n);
        PreambleUtil.insertMinDouble(memOut, sketch.getMinValue());
        PreambleUtil.insertMaxDouble(memOut, sketch.getMaxValue());
        long memOffsetBytes = 32L;
        int bbCnt = Util.computeBaseBufferItems(k, n);
        if (bbCnt > 0) {
            double[] bbItemsArr = dsa.getArray(0, bbCnt);
            if (ordered) {
                Arrays.sort(bbItemsArr);
            }
            memOut.putDoubleArray(memOffsetBytes, bbItemsArr, 0, bbCnt);
        }
        memOffsetBytes += (long)((compact ? bbCnt : 2 * k) << 3);
        int totalLevels = Util.computeTotalLevels(sketch.getBitPattern());
        for (int lvl = 0; lvl < totalLevels; ++lvl) {
            dsa.setLevel(lvl);
            if (dsa.numItems() <= 0) continue;
            assert (dsa.numItems() == k);
            memOut.putDoubleArray(memOffsetBytes, dsa.getArray(0, k), 0, k);
            memOffsetBytes += (long)(k << 3);
        }
        return outByteArr;
    }

    private static void insertPre0(WritableMemory wmem, int preLongs, int flags, int k) {
        PreambleUtil.insertPreLongs(wmem, preLongs);
        PreambleUtil.insertSerVer(wmem, 3);
        PreambleUtil.insertFamilyID(wmem, Family.QUANTILES.getID());
        PreambleUtil.insertFlags(wmem, flags);
        PreambleUtil.insertK(wmem, k);
    }
}

