/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.quantiles.DirectDoublesSketchAccessor;
import com.yahoo.sketches.quantiles.DoublesBufferAccessor;
import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.HeapDoublesSketchAccessor;

abstract class DoublesSketchAccessor
extends DoublesBufferAccessor {
    static final int BB_LVL_IDX = -1;
    final DoublesSketch ds_;
    final boolean forceSize_;
    long n_;
    int currLvl_;
    int numItems_;
    int offset_;

    DoublesSketchAccessor(DoublesSketch ds, boolean forceSize, int level) {
        this.ds_ = ds;
        this.forceSize_ = forceSize;
        this.setLevel(level);
    }

    static DoublesSketchAccessor wrap(DoublesSketch ds) {
        return DoublesSketchAccessor.wrap(ds, false);
    }

    static DoublesSketchAccessor wrap(DoublesSketch ds, boolean forceSize) {
        if (ds.isDirect()) {
            return new DirectDoublesSketchAccessor(ds, forceSize, -1);
        }
        return new HeapDoublesSketchAccessor(ds, forceSize, -1);
    }

    abstract DoublesSketchAccessor copyAndSetLevel(int var1);

    DoublesSketchAccessor setLevel(int lvl) {
        this.currLvl_ = lvl;
        if (lvl == -1) {
            this.numItems_ = this.forceSize_ ? this.ds_.getK() * 2 : this.ds_.getBaseBufferCount();
            this.offset_ = this.ds_.isDirect() ? 32 : 0;
        } else {
            assert (lvl >= 0);
            this.numItems_ = (this.ds_.getBitPattern() & 1L << lvl) > 0L || this.forceSize_ ? this.ds_.getK() : 0;
            int levelStart = this.ds_.isCompact() ? this.ds_.getBaseBufferCount() + this.countValidLevelsBelow(lvl) * this.ds_.getK() : (2 + this.currLvl_) * this.ds_.getK();
            if (this.ds_.isDirect()) {
                int preLongsAndExtra = Family.QUANTILES.getMaxPreLongs() + 2;
                this.offset_ = preLongsAndExtra + levelStart << 3;
            } else {
                this.offset_ = levelStart;
            }
        }
        this.n_ = this.ds_.getN();
        return this;
    }

    @Override
    int numItems() {
        return this.numItems_;
    }

    @Override
    abstract double get(int var1);

    @Override
    abstract double[] getArray(int var1, int var2);

    @Override
    abstract double set(int var1, double var2);

    @Override
    abstract void putArray(double[] var1, int var2, int var3, int var4);

    abstract void sort();

    private int countValidLevelsBelow(int tgtLvl) {
        int count2 = 0;
        long bitPattern = this.ds_.getBitPattern();
        for (int i = 0; i < tgtLvl && bitPattern > 0L; ++i, bitPattern >>>= 1) {
            if ((bitPattern & 1L) <= 0L) continue;
            ++count2;
        }
        return count2;
    }
}

