/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.HashOperations;
import com.yahoo.sketches.ResizeFactor;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.ConcurrentSharedThetaSketch;
import com.yahoo.sketches.theta.HeapQuickSelectSketch;
import com.yahoo.sketches.theta.UpdateReturnState;
import java.util.concurrent.atomic.AtomicBoolean;

final class ConcurrentHeapThetaBuffer
extends HeapQuickSelectSketch {
    private final ConcurrentSharedThetaSketch shared;
    private boolean isExactMode;
    private final boolean propagateOrderedCompact;
    private final AtomicBoolean localPropagationInProgress;

    ConcurrentHeapThetaBuffer(int lgNomLongs, long seed, ConcurrentSharedThetaSketch shared, boolean propagateOrderedCompact, int maxNumLocalThreads) {
        super(ConcurrentHeapThetaBuffer.computeLogBufferSize(lgNomLongs, shared.getExactLimit(), maxNumLocalThreads), seed, 1.0f, ResizeFactor.X1, false);
        this.shared = shared;
        this.isExactMode = true;
        this.propagateOrderedCompact = propagateOrderedCompact;
        this.localPropagationInProgress = new AtomicBoolean(false);
    }

    private static int computeLogBufferSize(int lgNomLongs, long exactSize, int maxNumLocalBuffers) {
        return Math.min(lgNomLongs, (int)Math.log(Math.sqrt(exactSize) / (double)(2 * maxNumLocalBuffers)));
    }

    @Override
    public int getCurrentBytes(boolean compact) {
        return this.shared.getCurrentBytes(compact);
    }

    @Override
    public double getEstimate() {
        return this.shared.getEstimate();
    }

    @Override
    public double getLowerBound(int numStdDev) {
        return this.shared.getLowerBound(numStdDev);
    }

    @Override
    public double getUpperBound(int numStdDev) {
        return this.shared.getUpperBound(numStdDev);
    }

    @Override
    public boolean hasMemory() {
        return this.shared.hasMemory();
    }

    @Override
    public boolean isDirect() {
        return this.shared.isDirect();
    }

    @Override
    public boolean isEmpty() {
        return this.shared.isEmpty();
    }

    @Override
    public boolean isEstimationMode() {
        return this.shared.isEstimationMode();
    }

    @Override
    public byte[] toByteArray() {
        throw new UnsupportedOperationException("Local theta buffer need not be serialized");
    }

    @Override
    public void reset() {
        super.reset();
        this.isExactMode = true;
        this.localPropagationInProgress.set(false);
    }

    @Override
    UpdateReturnState hashUpdate(long hash2) {
        if (this.isExactMode) {
            this.isExactMode = !this.shared.isEstimationMode();
        }
        HashOperations.checkHashCorruption(hash2);
        if (this.getHashTableThreshold() == 0 || this.isExactMode) {
            if (HashOperations.continueCondition(this.getThetaLong(), hash2)) {
                return UpdateReturnState.RejectedOverTheta;
            }
            if (this.propagateToSharedSketch(hash2)) {
                return UpdateReturnState.ConcurrentPropagated;
            }
        }
        UpdateReturnState state = super.hashUpdate(hash2);
        if (this.isOutOfSpace(this.getRetainedEntries() + 1)) {
            this.propagateToSharedSketch();
            return UpdateReturnState.ConcurrentPropagated;
        }
        if (state == UpdateReturnState.InsertedCountIncremented) {
            return UpdateReturnState.ConcurrentBufferInserted;
        }
        return state;
    }

    private boolean propagateToSharedSketch(long hash2) {
        while (this.localPropagationInProgress.get()) {
        }
        this.localPropagationInProgress.set(true);
        boolean res = this.shared.propagate(this.localPropagationInProgress, null, hash2);
        this.thetaLong_ = this.shared.getVolatileTheta();
        return res;
    }

    private void propagateToSharedSketch() {
        while (this.localPropagationInProgress.get()) {
        }
        CompactSketch compactSketch = this.compact(this.propagateOrderedCompact, null);
        this.localPropagationInProgress.set(true);
        this.shared.propagate(this.localPropagationInProgress, compactSketch, -1L);
        super.reset();
        this.thetaLong_ = this.shared.getVolatileTheta();
    }
}

