/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.DirectCompactSketch;
import com.yahoo.sketches.theta.UpdateSketch;

final class DirectCompactUnorderedSketch
extends DirectCompactSketch {
    private DirectCompactUnorderedSketch(Memory mem) {
        super(mem);
    }

    static DirectCompactUnorderedSketch wrapInstance(Memory srcMem, long seed) {
        short memSeedHash = srcMem.getShort(6L);
        short computedSeedHash = Util.computeSeedHash(seed);
        Util.checkSeedHashes(memSeedHash, computedSeedHash);
        return new DirectCompactUnorderedSketch(srcMem);
    }

    static DirectCompactUnorderedSketch compact(UpdateSketch sketch, WritableMemory dstMem) {
        int curCount = sketch.getRetainedEntries(true);
        long thetaLong = sketch.getThetaLong();
        boolean empty = sketch.isEmpty();
        thetaLong = DirectCompactUnorderedSketch.thetaOnCompact(empty, curCount, thetaLong);
        empty = DirectCompactUnorderedSketch.emptyOnCompact(curCount, thetaLong);
        int preLongs = DirectCompactUnorderedSketch.computeCompactPreLongs(thetaLong, empty, curCount);
        short seedHash = sketch.getSeedHash();
        long[] cache = sketch.getCache();
        int requiredFlags = 10;
        byte flags = (byte)(0xA | (empty ? 4 : 0));
        boolean ordered = false;
        long[] compactCache = CompactSketch.compactCache(cache, curCount, thetaLong, false);
        DirectCompactUnorderedSketch.loadCompactMemory(compactCache, seedHash, curCount, thetaLong, dstMem, flags, preLongs);
        return new DirectCompactUnorderedSketch(dstMem);
    }

    static DirectCompactUnorderedSketch compact(long[] cache, boolean empty, short seedHash, int curCount, long thetaLong, WritableMemory dstMem) {
        int preLongs = DirectCompactUnorderedSketch.computeCompactPreLongs(thetaLong, empty, curCount);
        int requiredFlags = 10;
        byte flags = (byte)(0xA | (empty ? 4 : 0));
        DirectCompactUnorderedSketch.loadCompactMemory(cache, seedHash, curCount, thetaLong, dstMem, flags, preLongs);
        return new DirectCompactUnorderedSketch(dstMem);
    }

    @Override
    public boolean isOrdered() {
        return false;
    }
}

