/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.hash.MurmurHash3;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.HashIterator;
import com.yahoo.sketches.theta.HeapHashIterator;
import java.nio.charset.StandardCharsets;

public final class SingleItemSketch
extends CompactSketch {
    private static final long FLAGS = 26L;
    private static final long LO6BYTES = 28587302519553L;
    private static final long DEFAULT_SEED_HASH = (long)Util.computeSeedHash(9001L) & 0xFFFFL;
    private static final long DEFAULT_PRE0 = DEFAULT_SEED_HASH << 48 | 0x1A0000030301L;
    private final long[] arr = new long[2];

    private SingleItemSketch(long hash2) {
        this.arr[0] = DEFAULT_PRE0;
        this.arr[1] = hash2;
    }

    private SingleItemSketch(long hash2, long seed) {
        long seedHash = (long)Util.computeSeedHash(seed) & 0xFFFFL;
        this.arr[0] = seedHash << 48 | 0x1A0000030301L;
        this.arr[1] = hash2;
    }

    SingleItemSketch(long hash2, short seedHash) {
        long seedH = (long)seedHash & 0xFFFFL;
        this.arr[0] = seedH << 48 | 0x1A0000030301L;
        this.arr[1] = hash2;
    }

    public static SingleItemSketch heapify(Memory mem) {
        long memPre0 = mem.getLong(0L);
        SingleItemSketch.checkDefaultBytes0to7(memPre0);
        return new SingleItemSketch(mem.getLong(8L));
    }

    public static SingleItemSketch heapify(Memory mem, long seed) {
        long memPre0 = mem.getLong(0L);
        SingleItemSketch.checkDefaultBytes0to5(memPre0);
        short seedHashIn = mem.getShort(6L);
        short seedHashCk = Util.computeSeedHash(seed);
        Util.checkSeedHashes(seedHashIn, seedHashCk);
        return new SingleItemSketch(mem.getLong(8L), seed);
    }

    public static SingleItemSketch create(long datum) {
        long[] data = new long[]{datum};
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    public static SingleItemSketch create(double datum) {
        double d = datum == 0.0 ? 0.0 : datum;
        long[] data = new long[]{Double.doubleToLongBits(d)};
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    public static SingleItemSketch create(String datum) {
        if (datum == null || datum.isEmpty()) {
            return null;
        }
        byte[] data = datum.getBytes(StandardCharsets.UTF_8);
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    public static SingleItemSketch create(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    public static SingleItemSketch create(char[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    public static SingleItemSketch create(int[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    public static SingleItemSketch create(long[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    public static SingleItemSketch create(long datum, long seed) {
        long[] data = new long[]{datum};
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1);
    }

    public static SingleItemSketch create(double datum, long seed) {
        double d = datum == 0.0 ? 0.0 : datum;
        long[] data = new long[]{Double.doubleToLongBits(d)};
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    public static SingleItemSketch create(String datum, long seed) {
        if (datum == null || datum.isEmpty()) {
            return null;
        }
        byte[] data = datum.getBytes(StandardCharsets.UTF_8);
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    public static SingleItemSketch create(byte[] data, long seed) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    public static SingleItemSketch create(char[] data, long seed) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    public static SingleItemSketch create(int[] data, long seed) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    public static SingleItemSketch create(long[] data, long seed) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    @Override
    public int getCountLessThanTheta(double theta) {
        return (double)this.arr[1] < theta * 9.223372036854776E18 ? 1 : 0;
    }

    @Override
    public int getCurrentBytes(boolean compact) {
        return 16;
    }

    @Override
    public double getEstimate() {
        return 1.0;
    }

    @Override
    public HashIterator iterator() {
        return new HeapHashIterator(new long[]{this.arr[1]}, 1, Long.MAX_VALUE);
    }

    @Override
    public double getLowerBound(int numStdDev) {
        return 1.0;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return 1;
    }

    @Override
    public long getThetaLong() {
        return Long.MAX_VALUE;
    }

    @Override
    public double getUpperBound(int numStdDev) {
        return 1.0;
    }

    @Override
    public boolean hasMemory() {
        return false;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public byte[] toByteArray() {
        byte[] out = new byte[16];
        for (int i = 0; i < 8; ++i) {
            out[i] = (byte)(this.arr[0] >>> i * 8);
            out[i + 8] = (byte)(this.arr[1] >>> i * 8);
        }
        return out;
    }

    @Override
    long[] getCache() {
        return new long[]{this.arr[1]};
    }

    @Override
    int getCurrentPreambleLongs(boolean compact) {
        return 1;
    }

    @Override
    Memory getMemory() {
        return null;
    }

    @Override
    short getSeedHash() {
        return (short)(this.arr[0] >>> 48);
    }

    static void checkDefaultBytes0to7(long memPre0) {
        if (memPre0 != DEFAULT_PRE0) {
            throw new SketchesArgumentException("Input Memory does not match defualt Preamble bytes 0 through 7.");
        }
    }

    static void checkDefaultBytes0to5(long memPre0) {
        long mask = 0xFFFFFFFFFFFFL;
        if ((memPre0 & 0xFFFFFFFFFFFFL) != 28587302519553L) {
            throw new SketchesArgumentException("Input Memory does not match defualt Preamble bytes 0 through 5.");
        }
    }
}

