/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.memory.MemoryRequestServer;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.HashOperations;
import com.yahoo.sketches.QuickSelect;
import com.yahoo.sketches.ResizeFactor;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.DirectQuickSelectSketch;
import com.yahoo.sketches.theta.DirectQuickSelectSketchR;
import com.yahoo.sketches.theta.HeapQuickSelectSketch;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.Sketch;
import com.yahoo.sketches.theta.Union;
import com.yahoo.sketches.theta.UpdateSketch;

final class UnionImpl
extends Union {
    private final UpdateSketch gadget_;
    private final short seedHash_;
    private long unionThetaLong_;
    private boolean unionEmpty_;

    private UnionImpl(UpdateSketch gadget, long seed) {
        this.gadget_ = gadget;
        this.seedHash_ = UnionImpl.computeSeedHash(seed);
    }

    static UnionImpl initNewHeapInstance(int lgNomLongs, long seed, float p, ResizeFactor rf) {
        HeapQuickSelectSketch gadget = new HeapQuickSelectSketch(lgNomLongs, seed, p, rf, true);
        UnionImpl unionImpl = new UnionImpl(gadget, seed);
        unionImpl.unionThetaLong_ = ((Sketch)gadget).getThetaLong();
        unionImpl.unionEmpty_ = ((Sketch)gadget).isEmpty();
        return unionImpl;
    }

    static UnionImpl initNewDirectInstance(int lgNomLongs, long seed, float p, ResizeFactor rf, MemoryRequestServer memReqSvr, WritableMemory dstMem) {
        DirectQuickSelectSketch gadget = new DirectQuickSelectSketch(lgNomLongs, seed, p, rf, memReqSvr, dstMem, true);
        UnionImpl unionImpl = new UnionImpl(gadget, seed);
        unionImpl.unionThetaLong_ = ((Sketch)gadget).getThetaLong();
        unionImpl.unionEmpty_ = ((Sketch)gadget).isEmpty();
        return unionImpl;
    }

    static UnionImpl heapifyInstance(Memory srcMem, long seed) {
        Family.UNION.checkFamilyID(PreambleUtil.extractFamilyID(srcMem));
        HeapQuickSelectSketch gadget = HeapQuickSelectSketch.heapifyInstance(srcMem, seed);
        UnionImpl unionImpl = new UnionImpl(gadget, seed);
        unionImpl.unionThetaLong_ = PreambleUtil.extractUnionThetaLong(srcMem);
        unionImpl.unionEmpty_ = PreambleUtil.isEmpty(srcMem);
        return unionImpl;
    }

    static UnionImpl fastWrap(Memory srcMem, long seed) {
        Family.UNION.checkFamilyID(PreambleUtil.extractFamilyID(srcMem));
        DirectQuickSelectSketchR gadget = DirectQuickSelectSketchR.fastReadOnlyWrap(srcMem, seed);
        UnionImpl unionImpl = new UnionImpl(gadget, seed);
        unionImpl.unionThetaLong_ = PreambleUtil.extractUnionThetaLong(srcMem);
        unionImpl.unionEmpty_ = PreambleUtil.isEmpty(srcMem);
        return unionImpl;
    }

    static UnionImpl fastWrap(WritableMemory srcMem, long seed) {
        Family.UNION.checkFamilyID(PreambleUtil.extractFamilyID(srcMem));
        DirectQuickSelectSketch gadget = DirectQuickSelectSketch.fastWritableWrap(srcMem, seed);
        UnionImpl unionImpl = new UnionImpl(gadget, seed);
        unionImpl.unionThetaLong_ = PreambleUtil.extractUnionThetaLong(srcMem);
        unionImpl.unionEmpty_ = PreambleUtil.isEmpty(srcMem);
        return unionImpl;
    }

    static UnionImpl wrapInstance(Memory srcMem, long seed) {
        Family.UNION.checkFamilyID(PreambleUtil.extractFamilyID(srcMem));
        DirectQuickSelectSketchR gadget = DirectQuickSelectSketchR.readOnlyWrap(srcMem, seed);
        UnionImpl unionImpl = new UnionImpl(gadget, seed);
        unionImpl.unionThetaLong_ = PreambleUtil.extractUnionThetaLong(srcMem);
        unionImpl.unionEmpty_ = PreambleUtil.isEmpty(srcMem);
        return unionImpl;
    }

    static UnionImpl wrapInstance(WritableMemory srcMem, long seed) {
        Family.UNION.checkFamilyID(PreambleUtil.extractFamilyID(srcMem));
        DirectQuickSelectSketch gadget = DirectQuickSelectSketch.writableWrap(srcMem, seed);
        UnionImpl unionImpl = new UnionImpl(gadget, seed);
        unionImpl.unionThetaLong_ = PreambleUtil.extractUnionThetaLong(srcMem);
        unionImpl.unionEmpty_ = PreambleUtil.isEmpty(srcMem);
        return unionImpl;
    }

    @Override
    public CompactSketch getResult() {
        return this.getResult(true, null);
    }

    @Override
    public CompactSketch getResult(boolean dstOrdered, WritableMemory dstMem) {
        int gadgetCurCount = this.gadget_.getRetainedEntries(true);
        int k = 1 << this.gadget_.getLgNomLongs();
        long[] gadgetCacheCopy = this.gadget_.hasMemory() ? this.gadget_.getCache() : (long[])this.gadget_.getCache().clone();
        long curGadgetThetaLong = this.gadget_.getThetaLong();
        long adjGadgetThetaLong = gadgetCurCount > k ? QuickSelect.selectExcludingZeros(gadgetCacheCopy, gadgetCurCount, k + 1) : curGadgetThetaLong;
        long unionThetaLong = this.gadget_.hasMemory() ? this.gadget_.getMemory().getLong(24L) : this.unionThetaLong_;
        long minThetaLong = Math.min(Math.min(curGadgetThetaLong, adjGadgetThetaLong), unionThetaLong);
        int curCountOut = minThetaLong < curGadgetThetaLong ? HashOperations.count(gadgetCacheCopy, minThetaLong) : gadgetCurCount;
        long[] compactCacheOut = CompactSketch.compactCache(gadgetCacheCopy, curCountOut, minThetaLong, dstOrdered);
        boolean empty = this.gadget_.isEmpty() && this.unionEmpty_;
        return UnionImpl.createCompactSketch(compactCacheOut, empty, this.seedHash_, curCountOut, minThetaLong, dstOrdered, dstMem);
    }

    @Override
    public void reset() {
        this.gadget_.reset();
        this.unionThetaLong_ = this.gadget_.getThetaLong();
        this.unionEmpty_ = this.gadget_.isEmpty();
    }

    @Override
    public byte[] toByteArray() {
        byte[] gadgetByteArr = this.gadget_.toByteArray();
        WritableMemory mem = WritableMemory.wrap(gadgetByteArr);
        PreambleUtil.insertUnionThetaLong(mem, this.unionThetaLong_);
        if (this.gadget_.isEmpty() != this.unionEmpty_) {
            PreambleUtil.clearEmpty(mem);
            this.unionEmpty_ = false;
        }
        return gadgetByteArr;
    }

    @Override
    public boolean isSameResource(Memory that) {
        return this.gadget_ instanceof DirectQuickSelectSketchR ? this.gadget_.getMemory().isSameResource(that) : false;
    }

    @Override
    public void update(Sketch sketchIn) {
        if (sketchIn == null || sketchIn.isEmpty()) {
            return;
        }
        Util.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
        Sketch.checkSketchAndMemoryFlags(sketchIn);
        this.unionThetaLong_ = Math.min(Math.min(this.unionThetaLong_, sketchIn.getThetaLong()), this.gadget_.getThetaLong());
        this.unionEmpty_ = false;
        int curCountIn = sketchIn.getRetainedEntries(true);
        if (curCountIn > 0) {
            long[] cacheIn;
            if (sketchIn.isOrdered()) {
                if (sketchIn.hasMemory()) {
                    int offsetBytes;
                    long hashIn;
                    Memory skMem = ((CompactSketch)sketchIn).getMemory();
                    int preambleLongs = skMem.getByte(0L) & 0x3F;
                    for (int i = 0; i < curCountIn && (hashIn = skMem.getLong(offsetBytes = preambleLongs + i << 3)) < this.unionThetaLong_; ++i) {
                        this.gadget_.hashUpdate(hashIn);
                    }
                } else {
                    long hashIn;
                    cacheIn = sketchIn.getCache();
                    for (int i = 0; i < curCountIn && (hashIn = cacheIn[i]) < this.unionThetaLong_; ++i) {
                        this.gadget_.hashUpdate(hashIn);
                    }
                }
            } else {
                cacheIn = sketchIn.getCache();
                int arrLongs = cacheIn.length;
                int c = 0;
                for (int i = 0; i < arrLongs && c < curCountIn; ++i) {
                    long hashIn = cacheIn[i];
                    if (hashIn <= 0L || hashIn >= this.unionThetaLong_) continue;
                    this.gadget_.hashUpdate(hashIn);
                    ++c;
                }
            }
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
        if (this.gadget_.hasMemory()) {
            WritableMemory wmem = (WritableMemory)this.gadget_.getMemory();
            PreambleUtil.insertUnionThetaLong(wmem, this.unionThetaLong_);
            PreambleUtil.clearEmpty(wmem);
        }
    }

    @Override
    public void update(Memory skMem) {
        if (skMem == null) {
            return;
        }
        int cap = (int)skMem.getCapacity();
        byte fam = skMem.getByte(2L);
        byte serVer = skMem.getByte(1L);
        if (serVer == 1) {
            if (fam != 3) {
                throw new SketchesArgumentException("Family must be old SET_SKETCH: " + (Object)((Object)Family.idToFamily(fam)));
            }
            if (cap <= 24) {
                return;
            }
            this.processVer1(skMem);
        } else if (serVer == 2) {
            if (fam != 3) {
                throw new SketchesArgumentException("Family must be old SET_SKETCH: " + (Object)((Object)Family.idToFamily(fam)));
            }
            if (cap <= 8) {
                return;
            }
            Util.checkSeedHashes(this.seedHash_, skMem.getShort(6L));
            this.processVer2(skMem);
        } else if (serVer == 3) {
            if (fam < 1 || fam > 3) {
                throw new SketchesArgumentException("Family must be Alpha, QuickSelect, or Compact: " + (Object)((Object)Family.idToFamily(fam)));
            }
            if (cap <= 8) {
                return;
            }
            Util.checkSeedHashes(this.seedHash_, skMem.getShort(6L));
            this.processVer3(skMem);
        } else {
            throw new SketchesArgumentException("SerVer is unknown: " + serVer);
        }
    }

    @Override
    public void update(long datum) {
        this.gadget_.update(datum);
    }

    @Override
    public void update(double datum) {
        this.gadget_.update(datum);
    }

    @Override
    public void update(String datum) {
        this.gadget_.update(datum);
    }

    @Override
    public void update(byte[] data) {
        this.gadget_.update(data);
    }

    @Override
    public void update(char[] data) {
        this.gadget_.update(data);
    }

    @Override
    public void update(int[] data) {
        this.gadget_.update(data);
    }

    @Override
    public void update(long[] data) {
        this.gadget_.update(data);
    }

    @Override
    long[] getCache() {
        return this.gadget_.getCache();
    }

    @Override
    int getRetainedEntries(boolean valid) {
        return this.gadget_.getRetainedEntries(valid);
    }

    @Override
    short getSeedHash() {
        return this.gadget_.getSeedHash();
    }

    @Override
    long getThetaLong() {
        return Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
    }

    @Override
    boolean isEmpty() {
        return this.gadget_.isEmpty() && this.unionEmpty_;
    }

    private void processVer1(Memory skMem) {
        int offsetBytes;
        long hashIn;
        boolean emptyIn;
        long thetaLongIn = skMem.getLong(16L);
        int curCountIn = skMem.getInt(8L);
        this.unionThetaLong_ = Math.min(Math.min(this.unionThetaLong_, thetaLongIn), this.gadget_.getThetaLong());
        boolean bl = emptyIn = curCountIn == 0 && this.unionThetaLong_ == Long.MAX_VALUE;
        if (emptyIn) {
            return;
        }
        this.unionEmpty_ = false;
        int preLongs = 3;
        for (int i = 0; i < curCountIn && (hashIn = skMem.getLong(offsetBytes = 3 + i << 3)) < this.unionThetaLong_; ++i) {
            this.gadget_.hashUpdate(hashIn);
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
        if (this.gadget_.hasMemory()) {
            WritableMemory wmem = (WritableMemory)this.gadget_.getMemory();
            PreambleUtil.insertUnionThetaLong(wmem, this.unionThetaLong_);
            PreambleUtil.clearEmpty(wmem);
        }
    }

    private void processVer2(Memory skMem) {
        int offsetBytes;
        long hashIn;
        long thetaLongIn;
        int preLongs = skMem.getByte(0L) & 0x3F;
        int curCount = skMem.getInt(8L);
        if (preLongs == 1) {
            return;
        }
        if (preLongs == 2) {
            assert (curCount > 0);
            thetaLongIn = Long.MAX_VALUE;
        } else {
            thetaLongIn = skMem.getLong(16L);
        }
        this.unionThetaLong_ = Math.min(Math.min(this.unionThetaLong_, thetaLongIn), this.gadget_.getThetaLong());
        this.unionEmpty_ = false;
        for (int i = 0; i < curCount && (hashIn = skMem.getLong(offsetBytes = preLongs + i << 3)) < this.unionThetaLong_; ++i) {
            this.gadget_.hashUpdate(hashIn);
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
        if (this.gadget_.hasMemory()) {
            WritableMemory wmem = (WritableMemory)this.gadget_.getMemory();
            PreambleUtil.insertUnionThetaLong(wmem, this.unionThetaLong_);
            PreambleUtil.clearEmpty(wmem);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processVer3(Memory skMem) {
        boolean ordered;
        long thetaLongIn;
        int curCountIn;
        int preLongs = skMem.getByte(0L) & 0x3F;
        int flags = skMem.getByte(5L) & 0x3F;
        if (preLongs == 1) {
            if (flags != 26) return;
            curCountIn = 1;
            thetaLongIn = Long.MAX_VALUE;
        } else if (preLongs == 2) {
            curCountIn = skMem.getInt(8L);
            assert (curCountIn > 0);
            thetaLongIn = Long.MAX_VALUE;
        } else {
            curCountIn = skMem.getInt(8L);
            thetaLongIn = skMem.getLong(16L);
        }
        this.unionThetaLong_ = Math.min(Math.min(this.unionThetaLong_, thetaLongIn), this.gadget_.getThetaLong());
        this.unionEmpty_ = false;
        boolean bl = ordered = (skMem.getByte(5L) & 0x10) != 0;
        if (ordered) {
            int offsetBytes;
            long hashIn;
            for (int i = 0; i < curCountIn && (hashIn = skMem.getLong(offsetBytes = preLongs + i << 3)) < this.unionThetaLong_; ++i) {
                this.gadget_.hashUpdate(hashIn);
            }
        } else {
            boolean compact = (skMem.getByte(5L) & 8) != 0;
            int size2 = compact ? curCountIn : 1 << skMem.getByte(4L);
            for (int i = 0; i < size2; ++i) {
                int offsetBytes = preLongs + i << 3;
                long hashIn = skMem.getLong(offsetBytes);
                if (hashIn <= 0L || hashIn >= this.unionThetaLong_) continue;
                this.gadget_.hashUpdate(hashIn);
            }
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
        if (!this.gadget_.hasMemory()) return;
        WritableMemory wmem = (WritableMemory)this.gadget_.getMemory();
        PreambleUtil.insertUnionThetaLong(wmem, this.unionThetaLong_);
        PreambleUtil.clearEmpty(wmem);
    }
}

