/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.tuple;

import com.yahoo.sketches.HashOperations;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.tuple.CompactSketch;
import com.yahoo.sketches.tuple.QuickSelectSketch;
import com.yahoo.sketches.tuple.Sketch;
import com.yahoo.sketches.tuple.Summary;
import java.lang.reflect.Array;
import java.util.Arrays;

public final class AnotB<S extends Summary> {
    private boolean isEmpty_ = true;
    private long theta_ = Long.MAX_VALUE;
    private long[] keys_;
    private S[] summaries_;
    private int count_;

    public void update(Sketch<S> a, Sketch<S> b) {
        if (a != null) {
            this.isEmpty_ = a.isEmpty();
        }
        long thetaA = a == null ? Long.MAX_VALUE : a.getThetaLong();
        long thetaB = b == null ? Long.MAX_VALUE : b.getThetaLong();
        this.theta_ = Math.min(thetaA, thetaB);
        if (a == null || a.getRetainedEntries() == 0) {
            return;
        }
        if (b == null || b.getRetainedEntries() == 0) {
            this.getNoMatchSetFromSketch(a);
        } else {
            long[] hashTable = b instanceof CompactSketch ? this.convertToHashTable(b) : b.keys_;
            int lgHashTableSize = Integer.numberOfTrailingZeros(hashTable.length);
            int noMatchSize = a.getRetainedEntries();
            this.keys_ = new long[noMatchSize];
            this.summaries_ = (Summary[])Array.newInstance(a.summaries_.getClass().getComponentType(), noMatchSize);
            for (int i = 0; i < a.keys_.length; ++i) {
                int index;
                if (a.keys_[i] == 0L || (index = HashOperations.hashSearch(hashTable, lgHashTableSize, a.keys_[i])) != -1) continue;
                this.keys_[this.count_] = a.keys_[i];
                this.summaries_[this.count_] = a.summaries_[i];
                ++this.count_;
            }
        }
    }

    public CompactSketch<S> getResult() {
        if (this.count_ == 0) {
            return new CompactSketch(null, null, this.theta_, this.isEmpty_);
        }
        CompactSketch result2 = new CompactSketch(Arrays.copyOfRange(this.keys_, 0, this.count_), (Summary[])Arrays.copyOfRange(this.summaries_, 0, this.count_), this.theta_, this.isEmpty_);
        this.reset();
        return result2;
    }

    private long[] convertToHashTable(Sketch<S> sketch) {
        int size2 = Math.max(Util.ceilingPowerOf2((int)Math.ceil((double)sketch.getRetainedEntries() / 0.9375)), 16);
        long[] hashTable = new long[size2];
        HashOperations.hashArrayInsert(sketch.keys_, hashTable, Integer.numberOfTrailingZeros(size2), this.theta_);
        return hashTable;
    }

    private void reset() {
        this.isEmpty_ = true;
        this.theta_ = Long.MAX_VALUE;
        this.keys_ = null;
        this.summaries_ = null;
        this.count_ = 0;
    }

    private void getNoMatchSetFromSketch(Sketch<S> sketch) {
        if (sketch instanceof CompactSketch) {
            this.keys_ = (long[])sketch.keys_.clone();
            this.summaries_ = (Summary[])sketch.summaries_.clone();
        } else {
            CompactSketch compact = ((QuickSelectSketch)sketch).compact();
            this.keys_ = compact.keys_;
            this.summaries_ = compact.summaries_;
        }
        this.count_ = sketch.getRetainedEntries();
    }
}

