/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.tuple;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.ByteArrayUtil;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.tuple.DeserializeResult;
import com.yahoo.sketches.tuple.SerializerDeserializer;
import com.yahoo.sketches.tuple.Sketch;
import com.yahoo.sketches.tuple.Summary;
import com.yahoo.sketches.tuple.SummaryDeserializer;
import java.lang.reflect.Array;
import java.nio.ByteOrder;

public class CompactSketch<S extends Summary>
extends Sketch<S> {
    private static final byte serialVersionWithSummaryClassNameUID = 1;
    private static final byte serialVersionUID = 2;

    CompactSketch(long[] keys, S[] summaries, long theta, boolean isEmpty2) {
        this.keys_ = keys;
        this.summaries_ = summaries;
        this.theta_ = theta;
        this.isEmpty_ = isEmpty2;
    }

    CompactSketch(Memory mem, SummaryDeserializer<S> deserializer) {
        boolean hasEntries;
        boolean isThetaIncluded;
        boolean isBigEndian;
        int offset = 0;
        byte preambleLongs = mem.getByte(offset++);
        byte version2 = mem.getByte(offset++);
        byte familyId = mem.getByte(offset++);
        SerializerDeserializer.validateFamily(familyId, preambleLongs);
        if (version2 > 2) {
            throw new SketchesArgumentException("Unsupported serial version. Expected: 2 or lower, actual: " + version2);
        }
        SerializerDeserializer.validateType(mem.getByte(offset++), SerializerDeserializer.SketchType.CompactSketch);
        byte flags = mem.getByte(offset++);
        boolean bl = isBigEndian = (flags & 1 << Flags.IS_BIG_ENDIAN.ordinal()) > 0;
        if (isBigEndian ^ ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            throw new SketchesArgumentException("Byte order mismatch");
        }
        this.isEmpty_ = (flags & 1 << Flags.IS_EMPTY.ordinal()) > 0;
        boolean bl2 = isThetaIncluded = (flags & 1 << Flags.IS_THETA_INCLUDED.ordinal()) > 0;
        if (isThetaIncluded) {
            this.theta_ = mem.getLong(offset);
            offset += 8;
        } else {
            this.theta_ = Long.MAX_VALUE;
        }
        boolean bl3 = hasEntries = (flags & 1 << Flags.HAS_ENTRIES.ordinal()) > 0;
        if (hasEntries) {
            int i;
            byte classNameLength = 0;
            if (version2 == 1) {
                classNameLength = mem.getByte(offset++);
            }
            int count2 = mem.getInt(offset);
            offset += 4;
            if (version2 == 1) {
                offset += classNameLength;
            }
            this.keys_ = new long[count2];
            for (i = 0; i < count2; ++i) {
                this.keys_[i] = mem.getLong(offset);
                offset += 8;
            }
            for (i = 0; i < count2; ++i) {
                Memory memRegion = mem.region(offset, mem.getCapacity() - (long)offset);
                DeserializeResult<S> result2 = deserializer.heapifySummary(memRegion);
                Summary summary = (Summary)result2.getObject();
                offset += result2.getSize();
                if (this.summaries_ == null) {
                    this.summaries_ = (Summary[])Array.newInstance(summary.getClass(), count2);
                }
                this.summaries_[i] = summary;
            }
        }
    }

    @Override
    public int getRetainedEntries() {
        return this.keys_ == null ? 0 : this.keys_.length;
    }

    @Override
    public byte[] toByteArray() {
        boolean isThetaIncluded;
        int summariesBytesLength = 0;
        Object summariesBytes = null;
        int count2 = this.getRetainedEntries();
        if (count2 > 0) {
            summariesBytes = new byte[count2][];
            for (int i = 0; i < count2; ++i) {
                summariesBytes[i] = this.summaries_[i].toByteArray();
                summariesBytesLength += summariesBytes[i].length;
            }
        }
        int sizeBytes = 5;
        boolean bl = isThetaIncluded = this.theta_ < Long.MAX_VALUE;
        if (isThetaIncluded) {
            sizeBytes += 8;
        }
        if (count2 > 0) {
            sizeBytes += 4 + 8 * count2 + summariesBytesLength;
        }
        byte[] bytes2 = new byte[sizeBytes];
        int offset = 0;
        bytes2[offset++] = 1;
        bytes2[offset++] = 2;
        bytes2[offset++] = (byte)Family.TUPLE.getID();
        bytes2[offset++] = (byte)SerializerDeserializer.SketchType.CompactSketch.ordinal();
        boolean isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        bytes2[offset++] = (byte)((isBigEndian ? 1 << Flags.IS_BIG_ENDIAN.ordinal() : 0) | (this.isEmpty_ ? 1 << Flags.IS_EMPTY.ordinal() : 0) | (count2 > 0 ? 1 << Flags.HAS_ENTRIES.ordinal() : 0) | (isThetaIncluded ? 1 << Flags.IS_THETA_INCLUDED.ordinal() : 0));
        if (isThetaIncluded) {
            ByteArrayUtil.putLongLE(bytes2, offset, this.theta_);
            offset += 8;
        }
        if (count2 > 0) {
            int i;
            ByteArrayUtil.putIntLE(bytes2, offset, this.getRetainedEntries());
            offset += 4;
            for (i = 0; i < count2; ++i) {
                ByteArrayUtil.putLongLE(bytes2, offset, this.keys_[i]);
                offset += 8;
            }
            for (i = 0; i < count2; ++i) {
                System.arraycopy(summariesBytes[i], 0, bytes2, offset, summariesBytes[i].length);
                offset += summariesBytes[i].length;
            }
        }
        return bytes2;
    }

    private static enum Flags {
        IS_BIG_ENDIAN,
        IS_EMPTY,
        HAS_ENTRIES,
        IS_THETA_INCLUDED;

    }
}

