/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.tuple;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.tuple.ArrayOfDoublesCompactSketch;
import com.yahoo.sketches.tuple.ArrayOfDoublesSketch;
import com.yahoo.sketches.tuple.ArrayOfDoublesSketchIterator;
import com.yahoo.sketches.tuple.ArrayOfDoublesUpdatableSketch;
import com.yahoo.sketches.tuple.DirectArrayOfDoublesSketchIterator;
import com.yahoo.sketches.tuple.SerializerDeserializer;
import com.yahoo.sketches.tuple.Util;
import java.nio.ByteOrder;

final class DirectArrayOfDoublesCompactSketch
extends ArrayOfDoublesCompactSketch {
    private Memory mem_;

    DirectArrayOfDoublesCompactSketch(ArrayOfDoublesUpdatableSketch sketch, WritableMemory dstMem) {
        this(sketch, sketch.getThetaLong(), dstMem);
    }

    DirectArrayOfDoublesCompactSketch(ArrayOfDoublesUpdatableSketch sketch, long theta, WritableMemory dstMem) {
        super(sketch.getNumValues());
        DirectArrayOfDoublesCompactSketch.checkIfEnoughMemory(dstMem, sketch.getRetainedEntries(), sketch.getNumValues());
        this.mem_ = dstMem;
        dstMem.putByte(0L, (byte)1);
        dstMem.putByte(1L, (byte)1);
        dstMem.putByte(2L, (byte)Family.TUPLE.getID());
        dstMem.putByte(3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch.ordinal());
        boolean isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        this.isEmpty_ = sketch.isEmpty();
        int count2 = sketch.getRetainedEntries();
        dstMem.putByte(4L, (byte)((isBigEndian ? 1 << ArrayOfDoublesSketch.Flags.IS_BIG_ENDIAN.ordinal() : 0) | (this.isEmpty_ ? 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal() : 0) | (count2 > 0 ? 1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal() : 0)));
        dstMem.putByte(5L, (byte)this.numValues_);
        dstMem.putShort(6L, Util.computeSeedHash(sketch.getSeed()));
        this.theta_ = Math.min(sketch.getThetaLong(), theta);
        dstMem.putLong(8L, this.theta_);
        if (count2 > 0) {
            int keyOffset = 24;
            int valuesOffset = keyOffset + 8 * sketch.getRetainedEntries();
            ArrayOfDoublesSketchIterator it = sketch.iterator();
            int actualCount = 0;
            while (it.next()) {
                if (it.getKey() >= this.theta_) continue;
                dstMem.putLong(keyOffset, it.getKey());
                dstMem.putDoubleArray(valuesOffset, it.getValues(), 0, this.numValues_);
                keyOffset += 8;
                valuesOffset += 8 * this.numValues_;
                ++actualCount;
            }
            dstMem.putInt(16L, actualCount);
        }
    }

    DirectArrayOfDoublesCompactSketch(long[] keys, double[] values2, long theta, boolean isEmpty2, int numValues, short seedHash, WritableMemory dstMem) {
        super(numValues);
        DirectArrayOfDoublesCompactSketch.checkIfEnoughMemory(dstMem, values2.length, numValues);
        this.mem_ = dstMem;
        dstMem.putByte(0L, (byte)1);
        dstMem.putByte(1L, (byte)1);
        dstMem.putByte(2L, (byte)Family.TUPLE.getID());
        dstMem.putByte(3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch.ordinal());
        boolean isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        this.isEmpty_ = isEmpty2;
        int count2 = keys.length;
        dstMem.putByte(4L, (byte)((isBigEndian ? 1 << ArrayOfDoublesSketch.Flags.IS_BIG_ENDIAN.ordinal() : 0) | (this.isEmpty_ ? 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal() : 0) | (count2 > 0 ? 1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal() : 0)));
        dstMem.putByte(5L, (byte)this.numValues_);
        dstMem.putShort(6L, seedHash);
        this.theta_ = theta;
        dstMem.putLong(8L, this.theta_);
        if (count2 > 0) {
            dstMem.putInt(16L, count2);
            dstMem.putLongArray(24L, keys, 0, count2);
            dstMem.putDoubleArray(24L + 8L * (long)count2, values2, 0, values2.length);
        }
    }

    DirectArrayOfDoublesCompactSketch(Memory mem) {
        this(mem, 9001L);
    }

    DirectArrayOfDoublesCompactSketch(Memory mem, long seed) {
        super(mem.getByte(5L));
        boolean isBigEndian;
        this.mem_ = mem;
        SerializerDeserializer.validateFamily(mem.getByte(2L), mem.getByte(0L));
        SerializerDeserializer.validateType(this.mem_.getByte(3L), SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch);
        byte version2 = this.mem_.getByte(1L);
        if (version2 != 1) {
            throw new SketchesArgumentException("Serial version mismatch. Expected: 1, actual: " + version2);
        }
        boolean bl = isBigEndian = (mem.getByte(4L) & 1 << ArrayOfDoublesSketch.Flags.IS_BIG_ENDIAN.ordinal()) != 0;
        if (isBigEndian ^ ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            throw new SketchesArgumentException("Byte order mismatch");
        }
        Util.checkSeedHashes(mem.getShort(6L), Util.computeSeedHash(seed));
        this.isEmpty_ = (this.mem_.getByte(4L) & 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal()) != 0;
        this.theta_ = this.mem_.getLong(8L);
    }

    @Override
    public int getRetainedEntries() {
        boolean hasEntries = (this.mem_.getByte(4L) & 1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal()) != 0;
        return hasEntries ? this.mem_.getInt(16L) : 0;
    }

    @Override
    public double[][] getValues() {
        int count2 = this.getRetainedEntries();
        double[][] values2 = new double[count2][];
        if (count2 > 0) {
            int valuesOffset = 24 + 8 * count2;
            for (int i = 0; i < count2; ++i) {
                double[] array = new double[this.numValues_];
                this.mem_.getDoubleArray(valuesOffset, array, 0, this.numValues_);
                values2[i] = array;
                valuesOffset += 8 * this.numValues_;
            }
        }
        return values2;
    }

    @Override
    public byte[] toByteArray() {
        int count2 = this.getRetainedEntries();
        int sizeBytes = 16;
        if (count2 > 0) {
            sizeBytes = 24 + 8 * count2 + 8 * count2 * this.numValues_;
        }
        byte[] byteArray = new byte[sizeBytes];
        WritableMemory mem = WritableMemory.wrap(byteArray);
        this.mem_.copyTo(0L, mem, 0L, sizeBytes);
        return byteArray;
    }

    @Override
    public ArrayOfDoublesSketchIterator iterator() {
        return new DirectArrayOfDoublesSketchIterator(this.mem_, 24, this.getRetainedEntries(), this.numValues_);
    }

    @Override
    short getSeedHash() {
        return this.mem_.getShort(6L);
    }

    private static void checkIfEnoughMemory(Memory mem, int numEntries, int numValues) {
        int sizeNeeded = 24 + (8 + 8 * numValues) * numEntries;
        if ((long)sizeNeeded > mem.getCapacity()) {
            throw new SketchesArgumentException("Not enough memory: need " + sizeNeeded + " bytes, got " + mem.getCapacity() + " bytes");
        }
    }
}

