/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.tuple;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.tuple.ArrayOfDoublesQuickSelectSketch;
import com.yahoo.sketches.tuple.ArrayOfDoublesUnion;
import com.yahoo.sketches.tuple.HeapArrayOfDoublesQuickSelectSketch;
import com.yahoo.sketches.tuple.SerializerDeserializer;

final class HeapArrayOfDoublesUnion
extends ArrayOfDoublesUnion {
    HeapArrayOfDoublesUnion(int nomEntries, int numValues, long seed) {
        super(new HeapArrayOfDoublesQuickSelectSketch(nomEntries, 3, 1.0f, numValues, seed));
    }

    HeapArrayOfDoublesUnion(ArrayOfDoublesQuickSelectSketch sketch) {
        super(sketch);
    }

    static ArrayOfDoublesUnion heapifyUnion(Memory mem, long seed) {
        SerializerDeserializer.SketchType type = SerializerDeserializer.getSketchType(mem);
        if (type == SerializerDeserializer.SketchType.ArrayOfDoublesQuickSelectSketch) {
            HeapArrayOfDoublesQuickSelectSketch sketch = new HeapArrayOfDoublesQuickSelectSketch(mem, seed);
            return new HeapArrayOfDoublesUnion(sketch);
        }
        byte version2 = mem.getByte(1L);
        if (version2 != 1) {
            throw new SketchesArgumentException("Serial version mismatch. Expected: 1, actual: " + version2);
        }
        SerializerDeserializer.validateFamily(mem.getByte(2L), mem.getByte(0L));
        SerializerDeserializer.validateType(mem.getByte(3L), SerializerDeserializer.SketchType.ArrayOfDoublesUnion);
        long unionTheta = mem.getLong(8L);
        Memory sketchMem = mem.region(16L, mem.getCapacity() - 16L);
        HeapArrayOfDoublesQuickSelectSketch sketch = new HeapArrayOfDoublesQuickSelectSketch(sketchMem, seed);
        HeapArrayOfDoublesUnion union2 = new HeapArrayOfDoublesUnion(sketch);
        union2.theta_ = unionTheta;
        return union2;
    }

    @Override
    public void reset() {
        this.sketch_ = new HeapArrayOfDoublesQuickSelectSketch(this.nomEntries_, 3, 1.0f, this.numValues_, this.seed_);
        this.theta_ = this.sketch_.getThetaLong();
    }
}

