/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.linux;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Errno implements Constant
{
    EPERM(1),
    ENOENT(2),
    ESRCH(3),
    EINTR(4),
    EIO(5),
    ENXIO(6),
    E2BIG(7),
    ENOEXEC(8),
    EBADF(9),
    ECHILD(10),
    EDEADLK(35),
    ENOMEM(12),
    EACCES(13),
    EFAULT(14),
    ENOTBLK(15),
    EBUSY(16),
    EEXIST(17),
    EXDEV(18),
    ENODEV(19),
    ENOTDIR(20),
    EISDIR(21),
    EINVAL(22),
    ENFILE(23),
    EMFILE(24),
    ENOTTY(25),
    ETXTBSY(26),
    EFBIG(27),
    ENOSPC(28),
    ESPIPE(29),
    EROFS(30),
    EMLINK(31),
    EPIPE(32),
    EDOM(33),
    ERANGE(34),
    EWOULDBLOCK(11),
    EAGAIN(11),
    EINPROGRESS(115),
    EALREADY(114),
    ENOTSOCK(88),
    EDESTADDRREQ(89),
    EMSGSIZE(90),
    EPROTOTYPE(91),
    ENOPROTOOPT(92),
    EPROTONOSUPPORT(93),
    ESOCKTNOSUPPORT(94),
    EOPNOTSUPP(95),
    EPFNOSUPPORT(96),
    EAFNOSUPPORT(97),
    EADDRINUSE(98),
    EADDRNOTAVAIL(99),
    ENETDOWN(100),
    ENETUNREACH(101),
    ENETRESET(102),
    ECONNABORTED(103),
    ECONNRESET(104),
    ENOBUFS(105),
    EISCONN(106),
    ENOTCONN(107),
    ESHUTDOWN(108),
    ETOOMANYREFS(109),
    ETIMEDOUT(110),
    ECONNREFUSED(111),
    ELOOP(40),
    ENAMETOOLONG(36),
    EHOSTDOWN(112),
    EHOSTUNREACH(113),
    ENOTEMPTY(39),
    EUSERS(87),
    EDQUOT(122),
    ESTALE(116),
    EREMOTE(66),
    ENOLCK(37),
    ENOSYS(38),
    EOVERFLOW(75),
    EIDRM(43),
    ENOMSG(42),
    EILSEQ(84),
    EBADMSG(74),
    EMULTIHOP(72),
    ENODATA(61),
    ENOLINK(67),
    ENOSR(63),
    ENOSTR(60),
    EPROTO(71),
    ETIME(62);

    private final int value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 122L;

    private Errno(int value) {
        this.value = value;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return this.value;
    }

    @Override
    public final int intValue() {
        return this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringTable {
        public static final Map<Errno, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Errno, String> generateTable() {
            EnumMap<Errno, String> map2 = new EnumMap<Errno, String>(Errno.class);
            map2.put(EPERM, "Operation not permitted");
            map2.put(ENOENT, "No such file or directory");
            map2.put(ESRCH, "No such process");
            map2.put(EINTR, "Interrupted system call");
            map2.put(EIO, "Input/output error");
            map2.put(ENXIO, "No such device or address");
            map2.put(E2BIG, "Argument list too long");
            map2.put(ENOEXEC, "Exec format error");
            map2.put(EBADF, "Bad file descriptor");
            map2.put(ECHILD, "No child processes");
            map2.put(EDEADLK, "Resource deadlock avoided");
            map2.put(ENOMEM, "Cannot allocate memory");
            map2.put(EACCES, "Permission denied");
            map2.put(EFAULT, "Bad address");
            map2.put(ENOTBLK, "Block device required");
            map2.put(EBUSY, "Device or resource busy");
            map2.put(EEXIST, "File exists");
            map2.put(EXDEV, "Invalid cross-device link");
            map2.put(ENODEV, "No such device");
            map2.put(ENOTDIR, "Not a directory");
            map2.put(EISDIR, "Is a directory");
            map2.put(EINVAL, "Invalid argument");
            map2.put(ENFILE, "Too many open files in system");
            map2.put(EMFILE, "Too many open files");
            map2.put(ENOTTY, "Inappropriate ioctl for device");
            map2.put(ETXTBSY, "Text file busy");
            map2.put(EFBIG, "File too large");
            map2.put(ENOSPC, "No space left on device");
            map2.put(ESPIPE, "Illegal seek");
            map2.put(EROFS, "Read-only file system");
            map2.put(EMLINK, "Too many links");
            map2.put(EPIPE, "Broken pipe");
            map2.put(EDOM, "Numerical argument out of domain");
            map2.put(ERANGE, "Numerical result out of range");
            map2.put(EWOULDBLOCK, "Resource temporarily unavailable");
            map2.put(EAGAIN, "Resource temporarily unavailable");
            map2.put(EINPROGRESS, "Operation now in progress");
            map2.put(EALREADY, "Operation already in progress");
            map2.put(ENOTSOCK, "Socket operation on non-socket");
            map2.put(EDESTADDRREQ, "Destination address required");
            map2.put(EMSGSIZE, "Message too long");
            map2.put(EPROTOTYPE, "Protocol wrong type for socket");
            map2.put(ENOPROTOOPT, "Protocol not available");
            map2.put(EPROTONOSUPPORT, "Protocol not supported");
            map2.put(ESOCKTNOSUPPORT, "Socket type not supported");
            map2.put(EOPNOTSUPP, "Operation not supported");
            map2.put(EPFNOSUPPORT, "Protocol family not supported");
            map2.put(EAFNOSUPPORT, "Address family not supported by protocol");
            map2.put(EADDRINUSE, "Address already in use");
            map2.put(EADDRNOTAVAIL, "Cannot assign requested address");
            map2.put(ENETDOWN, "Network is down");
            map2.put(ENETUNREACH, "Network is unreachable");
            map2.put(ENETRESET, "Network dropped connection on reset");
            map2.put(ECONNABORTED, "Software caused connection abort");
            map2.put(ECONNRESET, "Connection reset by peer");
            map2.put(ENOBUFS, "No buffer space available");
            map2.put(EISCONN, "Transport endpoint is already connected");
            map2.put(ENOTCONN, "Transport endpoint is not connected");
            map2.put(ESHUTDOWN, "Cannot send after transport endpoint shutdown");
            map2.put(ETOOMANYREFS, "Too many references: cannot splice");
            map2.put(ETIMEDOUT, "Connection timed out");
            map2.put(ECONNREFUSED, "Connection refused");
            map2.put(ELOOP, "Too many levels of symbolic links");
            map2.put(ENAMETOOLONG, "File name too long");
            map2.put(EHOSTDOWN, "Host is down");
            map2.put(EHOSTUNREACH, "No route to host");
            map2.put(ENOTEMPTY, "Directory not empty");
            map2.put(EUSERS, "Too many users");
            map2.put(EDQUOT, "Disk quota exceeded");
            map2.put(ESTALE, "Stale NFS file handle");
            map2.put(EREMOTE, "Object is remote");
            map2.put(ENOLCK, "No locks available");
            map2.put(ENOSYS, "Function not implemented");
            map2.put(EOVERFLOW, "Value too large for defined data type");
            map2.put(EIDRM, "Identifier removed");
            map2.put(ENOMSG, "No message of desired type");
            map2.put(EILSEQ, "Invalid or incomplete multibyte or wide character");
            map2.put(EBADMSG, "Bad message");
            map2.put(EMULTIHOP, "Multihop attempted");
            map2.put(ENODATA, "No data available");
            map2.put(ENOLINK, "Link has been severed");
            map2.put(ENOSR, "Out of streams resources");
            map2.put(ENOSTR, "Device not a stream");
            map2.put(EPROTO, "Protocol error");
            map2.put(ETIME, "Timer expired");
            return map2;
        }
    }
}

