/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.typetools;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.jodah.typetools.TypeDescriptor;
import sun.reflect.ConstantPool;

public final class TypeResolver {
    private static Method GET_CONSTANT_POOL;
    private static final Map<Class<?>, Reference<Map<TypeVariable<?>, Type>>> typeVariableCache;
    private static boolean cacheEnabled;
    private static Map<String, Method> OBJECT_METHODS;

    private TypeResolver() {
    }

    public static void enableCache() {
        cacheEnabled = true;
    }

    public static void disableCache() {
        typeVariableCache.clear();
        cacheEnabled = false;
    }

    public static <T, S extends T> Class<?> resolveRawArgument(Class<T> type, Class<S> subType) {
        return TypeResolver.resolveRawArgument(TypeResolver.resolveGenericType(type, subType), subType);
    }

    public static Class<?> resolveRawArgument(Type genericType, Class<?> subType) {
        Class<?>[] arguments = TypeResolver.resolveRawArguments(genericType, subType);
        if (arguments == null) {
            return Unknown.class;
        }
        if (arguments.length != 1) {
            throw new IllegalArgumentException("Expected 1 argument for generic type " + genericType + " but found " + arguments.length);
        }
        return arguments[0];
    }

    public static <T, S extends T> Class<?>[] resolveRawArguments(Class<T> type, Class<S> subType) {
        return TypeResolver.resolveRawArguments(TypeResolver.resolveGenericType(type, subType), subType);
    }

    public static Class<?>[] resolveRawArguments(Type genericType, Class<?> subType) {
        Class[] result2;
        block5: {
            block6: {
                block4: {
                    result2 = null;
                    if (GET_CONSTANT_POOL != null && subType.isSynthetic()) {
                        Class functionalInterface;
                        Class clazz = genericType instanceof ParameterizedType && ((ParameterizedType)genericType).getRawType() instanceof Class ? (Class)((ParameterizedType)genericType).getRawType() : (functionalInterface = genericType instanceof Class ? (Class)genericType : null);
                        if (functionalInterface != null && functionalInterface.isInterface()) {
                            TypeResolver.getTypeVariableMap(subType, functionalInterface);
                        }
                    }
                    if (!(genericType instanceof ParameterizedType)) break block4;
                    ParameterizedType paramType = (ParameterizedType)genericType;
                    Type[] arguments = paramType.getActualTypeArguments();
                    result2 = new Class[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        result2[i] = TypeResolver.resolveRawClass(arguments[i], subType);
                    }
                    break block5;
                }
                if (!(genericType instanceof TypeVariable)) break block6;
                result2 = new Class[]{TypeResolver.resolveRawClass(genericType, subType)};
                break block5;
            }
            if (!(genericType instanceof Class)) break block5;
            TypeVariable<Class<T>>[] typeParams2 = ((Class)genericType).getTypeParameters();
            result2 = new Class[typeParams2.length];
            for (int i = 0; i < typeParams2.length; ++i) {
                result2[i] = TypeResolver.resolveRawClass(typeParams2[i], subType);
            }
        }
        return result2;
    }

    public static Type resolveGenericType(Class<?> type, Type subType) {
        Type superClass;
        Type result2;
        Class rawType = subType instanceof ParameterizedType ? (Class)((ParameterizedType)subType).getRawType() : (Class)subType;
        if (type.equals(rawType)) {
            return subType;
        }
        if (type.isInterface()) {
            for (Type superInterface : rawType.getGenericInterfaces()) {
                if (superInterface == null || superInterface.equals(Object.class) || (result2 = TypeResolver.resolveGenericType(type, superInterface)) == null) continue;
                return result2;
            }
        }
        if ((superClass = rawType.getGenericSuperclass()) != null && !superClass.equals(Object.class) && (result2 = TypeResolver.resolveGenericType(type, superClass)) != null) {
            return result2;
        }
        return null;
    }

    public static Class<?> resolveRawClass(Type genericType, Class<?> subType) {
        if (genericType instanceof Class) {
            return genericType;
        }
        if (genericType instanceof ParameterizedType) {
            return TypeResolver.resolveRawClass(((ParameterizedType)genericType).getRawType(), subType);
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)genericType;
            Class<?> compoment = TypeResolver.resolveRawClass(arrayType.getGenericComponentType(), subType);
            return Array.newInstance(compoment, 0).getClass();
        }
        if (genericType instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)genericType;
            genericType = TypeResolver.getTypeVariableMap(subType, null).get(variable);
            genericType = genericType == null ? TypeResolver.resolveBound(variable) : TypeResolver.resolveRawClass(genericType, subType);
        }
        return genericType instanceof Class ? (Class)genericType : Unknown.class;
    }

    private static Map<TypeVariable<?>, Type> getTypeVariableMap(Class<?> targetType, Class<?> functionalInterface) {
        Map<TypeVariable<?>, Type> map2;
        Reference<Map<TypeVariable<?>, Type>> ref = typeVariableCache.get(targetType);
        Map<TypeVariable<?>, Type> map3 = map2 = ref != null ? ref.get() : null;
        if (map2 == null) {
            Class<?> type;
            map2 = new HashMap();
            if (functionalInterface != null) {
                TypeResolver.populateLambdaArgs(functionalInterface, targetType, map2);
            }
            TypeResolver.populateSuperTypeArgs(targetType.getGenericInterfaces(), map2, functionalInterface != null);
            Type genericType = targetType.getGenericSuperclass();
            for (type = targetType.getSuperclass(); type != null && !Object.class.equals(type); type = type.getSuperclass()) {
                if (genericType instanceof ParameterizedType) {
                    TypeResolver.populateTypeArgs((ParameterizedType)genericType, map2, false);
                }
                TypeResolver.populateSuperTypeArgs(type.getGenericInterfaces(), map2, false);
                genericType = type.getGenericSuperclass();
            }
            type = targetType;
            while (type.isMemberClass()) {
                genericType = type.getGenericSuperclass();
                if (genericType instanceof ParameterizedType) {
                    TypeResolver.populateTypeArgs((ParameterizedType)genericType, map2, functionalInterface != null);
                }
                type = type.getEnclosingClass();
            }
            if (cacheEnabled) {
                typeVariableCache.put(targetType, new WeakReference(map2));
            }
        }
        return map2;
    }

    private static void populateLambdaArgs(Class<?> functionalInterface, Class<?> lambdaType, Map<TypeVariable<?>, Type> map2) {
        if (GET_CONSTANT_POOL != null) {
            try {
                for (Method m : functionalInterface.getMethods()) {
                    Class<?> returnType;
                    Method objectMethod;
                    if (m.isDefault() || Modifier.isStatic(m.getModifiers()) || m.isBridge() || (objectMethod = OBJECT_METHODS.get(m.getName())) != null && Arrays.equals(m.getTypeParameters(), objectMethod.getTypeParameters())) continue;
                    Type returnTypeVar = m.getGenericReturnType();
                    Type[] paramTypeVars = m.getGenericParameterTypes();
                    ConstantPool constantPool = (ConstantPool)GET_CONSTANT_POOL.invoke(lambdaType, new Object[0]);
                    String[] methodRefInfo = constantPool.getMemberRefInfoAt(constantPool.getSize() - 2);
                    if (methodRefInfo[1].equals("valueOf") && constantPool.getSize() > 22) {
                        methodRefInfo = constantPool.getMemberRefInfoAt(constantPool.getSize() - 8);
                    }
                    if (returnTypeVar instanceof TypeVariable && !(returnType = TypeDescriptor.getReturnType(methodRefInfo[2]).getType(lambdaType.getClassLoader())).equals(Void.class)) {
                        map2.put((TypeVariable)returnTypeVar, returnType);
                    }
                    TypeDescriptor[] arguments = TypeDescriptor.getArgumentTypes(methodRefInfo[2]);
                    int offset = 0;
                    if (paramTypeVars[0] instanceof TypeVariable && paramTypeVars.length == arguments.length + 1) {
                        Class<?> instanceType = TypeDescriptor.getObjectType(methodRefInfo[0]).getType(lambdaType.getClassLoader());
                        map2.put((TypeVariable)paramTypeVars[0], instanceType);
                        offset = 1;
                    }
                    for (int i = 0; i < arguments.length; ++i) {
                        if (!(paramTypeVars[i + offset] instanceof TypeVariable)) continue;
                        map2.put((TypeVariable)paramTypeVars[i + offset], arguments[i].getType(lambdaType.getClassLoader()));
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void populateSuperTypeArgs(Type[] types, Map<TypeVariable<?>, Type> map2, boolean depthFirst) {
        for (Type type : types) {
            if (type instanceof ParameterizedType) {
                Type rawType;
                ParameterizedType parameterizedType = (ParameterizedType)type;
                if (!depthFirst) {
                    TypeResolver.populateTypeArgs(parameterizedType, map2, depthFirst);
                }
                if ((rawType = parameterizedType.getRawType()) instanceof Class) {
                    TypeResolver.populateSuperTypeArgs(((Class)rawType).getGenericInterfaces(), map2, depthFirst);
                }
                if (!depthFirst) continue;
                TypeResolver.populateTypeArgs(parameterizedType, map2, depthFirst);
                continue;
            }
            if (!(type instanceof Class)) continue;
            TypeResolver.populateSuperTypeArgs(((Class)type).getGenericInterfaces(), map2, depthFirst);
        }
    }

    private static void populateTypeArgs(ParameterizedType type, Map<TypeVariable<?>, Type> map2, boolean depthFirst) {
        if (type.getRawType() instanceof Class) {
            Type owner2;
            TypeVariable<Class<T>>[] typeVariables = ((Class)type.getRawType()).getTypeParameters();
            Type[] typeArguments = type.getActualTypeArguments();
            if (type.getOwnerType() != null && (owner2 = type.getOwnerType()) instanceof ParameterizedType) {
                TypeResolver.populateTypeArgs((ParameterizedType)owner2, map2, depthFirst);
            }
            for (int i = 0; i < typeArguments.length; ++i) {
                Type existingType;
                TypeVariable variable = typeVariables[i];
                Type typeArgument = typeArguments[i];
                if (typeArgument instanceof Class) {
                    map2.put(variable, typeArgument);
                    continue;
                }
                if (typeArgument instanceof GenericArrayType) {
                    map2.put(variable, typeArgument);
                    continue;
                }
                if (typeArgument instanceof ParameterizedType) {
                    map2.put(variable, typeArgument);
                    continue;
                }
                if (!(typeArgument instanceof TypeVariable)) continue;
                TypeVariable typeVariableArgument = (TypeVariable)typeArgument;
                if (depthFirst && (existingType = map2.get(variable)) != null) {
                    map2.put(typeVariableArgument, existingType);
                    continue;
                }
                Type resolvedType = map2.get(typeVariableArgument);
                if (resolvedType == null) {
                    resolvedType = TypeResolver.resolveBound(typeVariableArgument);
                }
                map2.put(variable, resolvedType);
            }
        }
    }

    public static Type resolveBound(TypeVariable<?> typeVariable) {
        Type[] bounds = typeVariable.getBounds();
        if (bounds.length == 0) {
            return Unknown.class;
        }
        Type bound = bounds[0];
        if (bound instanceof TypeVariable) {
            bound = TypeResolver.resolveBound((TypeVariable)bound);
        }
        return bound == Object.class ? Unknown.class : bound;
    }

    static {
        typeVariableCache = Collections.synchronizedMap(new WeakHashMap());
        cacheEnabled = true;
        OBJECT_METHODS = new HashMap<String, Method>();
        for (Method method : Object.class.getDeclaredMethods()) {
            OBJECT_METHODS.put(method.getName(), method);
        }
        try {
            GET_CONSTANT_POOL = Class.class.getDeclaredMethod("getConstantPool", new Class[0]);
            GET_CONSTANT_POOL.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final class Unknown {
        private Unknown() {
        }
    }
}

