/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import java.io.IOException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilderBase;
import org.apache.avro.generic.GenericData;

public class GenericRecordBuilder
extends RecordBuilderBase<GenericData.Record> {
    private final GenericData.Record record;

    public GenericRecordBuilder(Schema schema) {
        super(schema, GenericData.get());
        this.record = new GenericData.Record(schema);
    }

    public GenericRecordBuilder(GenericRecordBuilder other) {
        super(other, GenericData.get());
        this.record = new GenericData.Record(other.record, true);
    }

    public GenericRecordBuilder(GenericData.Record other) {
        super(other.getSchema(), GenericData.get());
        this.record = new GenericData.Record(other, true);
        for (Schema.Field f : this.schema().getFields()) {
            Object value;
            if (!GenericRecordBuilder.isValidValue(f, value = other.get(f.pos()))) continue;
            this.set(f, this.data().deepCopy(f.schema(), value));
        }
    }

    public Object get(String fieldName2) {
        return this.get(this.schema().getField(fieldName2));
    }

    public Object get(Schema.Field field2) {
        return this.get(field2.pos());
    }

    protected Object get(int pos) {
        return this.record.get(pos);
    }

    public GenericRecordBuilder set(String fieldName2, Object value) {
        return this.set(this.schema().getField(fieldName2), value);
    }

    public GenericRecordBuilder set(Schema.Field field2, Object value) {
        return this.set(field2, field2.pos(), value);
    }

    protected GenericRecordBuilder set(int pos, Object value) {
        return this.set(this.fields()[pos], pos, value);
    }

    private GenericRecordBuilder set(Schema.Field field2, int pos, Object value) {
        this.validate(field2, value);
        this.record.put(pos, value);
        this.fieldSetFlags()[pos] = true;
        return this;
    }

    public boolean has(String fieldName2) {
        return this.has(this.schema().getField(fieldName2));
    }

    public boolean has(Schema.Field field2) {
        return this.has(field2.pos());
    }

    protected boolean has(int pos) {
        return this.fieldSetFlags()[pos];
    }

    public GenericRecordBuilder clear(String fieldName2) {
        return this.clear(this.schema().getField(fieldName2));
    }

    public GenericRecordBuilder clear(Schema.Field field2) {
        return this.clear(field2.pos());
    }

    protected GenericRecordBuilder clear(int pos) {
        this.record.put(pos, null);
        this.fieldSetFlags()[pos] = false;
        return this;
    }

    @Override
    public GenericData.Record build() {
        GenericData.Record record;
        try {
            record = new GenericData.Record(this.schema());
        }
        catch (Exception e) {
            throw new AvroRuntimeException(e);
        }
        for (Schema.Field field2 : this.fields()) {
            Object value;
            try {
                value = this.getWithDefault(field2);
            }
            catch (IOException e) {
                throw new AvroRuntimeException(e);
            }
            if (value == null) continue;
            record.put(field2.pos(), value);
        }
        return record;
    }

    private Object getWithDefault(Schema.Field field2) throws IOException {
        return this.fieldSetFlags()[field2.pos()] ? this.record.get(field2.pos()) : this.defaultValue(field2);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.record == null ? 0 : this.record.hashCode());
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericRecordBuilder other = (GenericRecordBuilder)obj;
        return !(this.record == null ? other.record != null : !this.record.equals(other.record));
    }
}

