/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import org.apache.thrift.transport.AutoExpandingBufferReadTransport;
import org.apache.thrift.transport.AutoExpandingBufferWriteTransport;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class TFastFramedTransport
extends TTransport {
    public static final int DEFAULT_BUF_CAPACITY = 1024;
    public static final int DEFAULT_MAX_LENGTH = 0xFA0000;
    private final TTransport underlying;
    private final AutoExpandingBufferWriteTransport writeBuffer;
    private AutoExpandingBufferReadTransport readBuffer;
    private final int initialBufferCapacity;
    private final byte[] i32buf = new byte[4];
    private final int maxLength;

    public TFastFramedTransport(TTransport underlying) {
        this(underlying, 1024, 0xFA0000);
    }

    public TFastFramedTransport(TTransport underlying, int initialBufferCapacity) {
        this(underlying, initialBufferCapacity, 0xFA0000);
    }

    public TFastFramedTransport(TTransport underlying, int initialBufferCapacity, int maxLength) {
        this.underlying = underlying;
        this.maxLength = maxLength;
        this.initialBufferCapacity = initialBufferCapacity;
        this.readBuffer = new AutoExpandingBufferReadTransport(initialBufferCapacity);
        this.writeBuffer = new AutoExpandingBufferWriteTransport(initialBufferCapacity, 4);
    }

    @Override
    public void close() {
        this.underlying.close();
    }

    @Override
    public boolean isOpen() {
        return this.underlying.isOpen();
    }

    @Override
    public void open() throws TTransportException {
        this.underlying.open();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        int got = this.readBuffer.read(buf, off, len);
        if (got > 0) {
            return got;
        }
        this.readFrame();
        return this.readBuffer.read(buf, off, len);
    }

    private void readFrame() throws TTransportException {
        this.underlying.readAll(this.i32buf, 0, 4);
        int size2 = TFramedTransport.decodeFrameSize(this.i32buf);
        if (size2 < 0) {
            this.close();
            throw new TTransportException(5, "Read a negative frame size (" + size2 + ")!");
        }
        if (size2 > this.maxLength) {
            this.close();
            throw new TTransportException(5, "Frame size (" + size2 + ") larger than max length (" + this.maxLength + ")!");
        }
        this.readBuffer.fill(this.underlying, size2);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws TTransportException {
        this.writeBuffer.write(buf, off, len);
    }

    @Override
    public void consumeBuffer(int len) {
        this.readBuffer.consumeBuffer(len);
    }

    public void clear() {
        this.readBuffer = new AutoExpandingBufferReadTransport(this.initialBufferCapacity);
    }

    @Override
    public void flush() throws TTransportException {
        int payloadLength = this.writeBuffer.getLength() - 4;
        byte[] data = this.writeBuffer.getBuf().array();
        TFramedTransport.encodeFrameSize(payloadLength, data);
        this.underlying.write(data, 0, payloadLength + 4);
        this.writeBuffer.reset();
        this.underlying.flush();
    }

    @Override
    public byte[] getBuffer() {
        return this.readBuffer.getBuffer();
    }

    @Override
    public int getBufferPosition() {
        return this.readBuffer.getBufferPosition();
    }

    @Override
    public int getBytesRemainingInBuffer() {
        return this.readBuffer.getBytesRemainingInBuffer();
    }

    public static class Factory
    extends TTransportFactory {
        private final int initialCapacity;
        private final int maxLength;

        public Factory() {
            this(1024, 0xFA0000);
        }

        public Factory(int initialCapacity) {
            this(initialCapacity, 0xFA0000);
        }

        public Factory(int initialCapacity, int maxLength) {
            this.initialCapacity = initialCapacity;
            this.maxLength = maxLength;
        }

        @Override
        public TTransport getTransport(TTransport trans) {
            return new TFastFramedTransport(trans, this.initialCapacity, this.maxLength);
        }
    }
}

