/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.node;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BaseJsonNode;
import org.codehaus.jackson.node.ContainerNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.MissingNode;
import org.codehaus.jackson.node.TextNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectNode
extends ContainerNode {
    protected LinkedHashMap<String, JsonNode> _children = null;

    public ObjectNode(JsonNodeFactory nc) {
        super(nc);
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public int size() {
        return this._children == null ? 0 : this._children.size();
    }

    @Override
    public Iterator<JsonNode> getElements() {
        return this._children == null ? ContainerNode.NoNodesIterator.instance() : this._children.values().iterator();
    }

    @Override
    public JsonNode get(int index) {
        return null;
    }

    @Override
    public JsonNode get(String fieldName2) {
        if (this._children != null) {
            return this._children.get(fieldName2);
        }
        return null;
    }

    @Override
    public Iterator<String> getFieldNames() {
        return this._children == null ? ContainerNode.NoStringsIterator.instance() : this._children.keySet().iterator();
    }

    @Override
    public JsonNode path(int index) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(String fieldName2) {
        JsonNode n;
        if (this._children != null && (n = this._children.get(fieldName2)) != null) {
            return n;
        }
        return MissingNode.getInstance();
    }

    @Override
    public Iterator<Map.Entry<String, JsonNode>> getFields() {
        if (this._children == null) {
            return NoFieldsIterator.instance;
        }
        return this._children.entrySet().iterator();
    }

    @Override
    public ObjectNode with(String propertyName) {
        if (this._children == null) {
            this._children = new LinkedHashMap();
        } else {
            JsonNode n = this._children.get(propertyName);
            if (n != null) {
                if (n instanceof ObjectNode) {
                    return (ObjectNode)n;
                }
                throw new UnsupportedOperationException("Property '" + propertyName + "' has value that is not of type ObjectNode (but " + n.getClass().getName() + ")");
            }
        }
        ObjectNode result2 = this.objectNode();
        this._children.put(propertyName, result2);
        return result2;
    }

    @Override
    public JsonNode findValue(String fieldName2) {
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                if (fieldName2.equals(entry.getKey())) {
                    return entry.getValue();
                }
                JsonNode value = entry.getValue().findValue(fieldName2);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String fieldName2, List<JsonNode> foundSoFar) {
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                if (fieldName2.equals(entry.getKey())) {
                    if (foundSoFar == null) {
                        foundSoFar = new ArrayList<JsonNode>();
                    }
                    foundSoFar.add(entry.getValue());
                    continue;
                }
                foundSoFar = entry.getValue().findValues(fieldName2, foundSoFar);
            }
        }
        return foundSoFar;
    }

    @Override
    public List<String> findValuesAsText(String fieldName2, List<String> foundSoFar) {
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                if (fieldName2.equals(entry.getKey())) {
                    if (foundSoFar == null) {
                        foundSoFar = new ArrayList<String>();
                    }
                    foundSoFar.add(entry.getValue().asText());
                    continue;
                }
                foundSoFar = entry.getValue().findValuesAsText(fieldName2, foundSoFar);
            }
        }
        return foundSoFar;
    }

    @Override
    public ObjectNode findParent(String fieldName2) {
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                if (fieldName2.equals(entry.getKey())) {
                    return this;
                }
                JsonNode value = entry.getValue().findParent(fieldName2);
                if (value == null) continue;
                return (ObjectNode)value;
            }
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String fieldName2, List<JsonNode> foundSoFar) {
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                if (fieldName2.equals(entry.getKey())) {
                    if (foundSoFar == null) {
                        foundSoFar = new ArrayList<JsonNode>();
                    }
                    foundSoFar.add(this);
                    continue;
                }
                foundSoFar = entry.getValue().findParents(fieldName2, foundSoFar);
            }
        }
        return foundSoFar;
    }

    @Override
    public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.writeStartObject();
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
                jg.writeFieldName(en.getKey());
                ((BaseJsonNode)en.getValue()).serialize(jg, provider);
            }
        }
        jg.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator jg, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForObject(this, jg);
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
                jg.writeFieldName(en.getKey());
                ((BaseJsonNode)en.getValue()).serialize(jg, provider);
            }
        }
        typeSer.writeTypeSuffixForObject(this, jg);
    }

    public JsonNode put(String fieldName2, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        return this._put(fieldName2, value);
    }

    public JsonNode remove(String fieldName2) {
        if (this._children != null) {
            return (JsonNode)this._children.remove(fieldName2);
        }
        return null;
    }

    public ObjectNode remove(Collection<String> fieldNames2) {
        if (this._children != null) {
            for (String fieldName2 : fieldNames2) {
                this._children.remove(fieldName2);
            }
        }
        return this;
    }

    @Override
    public ObjectNode removeAll() {
        this._children = null;
        return this;
    }

    public JsonNode putAll(Map<String, JsonNode> properties) {
        if (this._children == null) {
            this._children = new LinkedHashMap<String, JsonNode>(properties);
        } else {
            for (Map.Entry<String, JsonNode> en : properties.entrySet()) {
                JsonNode n = en.getValue();
                if (n == null) {
                    n = this.nullNode();
                }
                this._children.put(en.getKey(), n);
            }
        }
        return this;
    }

    public JsonNode putAll(ObjectNode other) {
        int len = other.size();
        if (len > 0) {
            if (this._children == null) {
                this._children = new LinkedHashMap(len);
            }
            other.putContentsTo(this._children);
        }
        return this;
    }

    public ObjectNode retain(Collection<String> fieldNames2) {
        if (this._children != null) {
            Iterator<Map.Entry<String, JsonNode>> entries = this._children.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, JsonNode> entry = entries.next();
                if (fieldNames2.contains(entry.getKey())) continue;
                entries.remove();
            }
        }
        return this;
    }

    public ObjectNode retain(String ... fieldNames2) {
        return this.retain(Arrays.asList(fieldNames2));
    }

    public ArrayNode putArray(String fieldName2) {
        ArrayNode n = this.arrayNode();
        this._put(fieldName2, n);
        return n;
    }

    public ObjectNode putObject(String fieldName2) {
        ObjectNode n = this.objectNode();
        this._put(fieldName2, n);
        return n;
    }

    public void putPOJO(String fieldName2, Object pojo) {
        this._put(fieldName2, this.POJONode(pojo));
    }

    public void putNull(String fieldName2) {
        this._put(fieldName2, this.nullNode());
    }

    public void put(String fieldName2, int v) {
        this._put(fieldName2, this.numberNode(v));
    }

    public void put(String fieldName2, Integer value) {
        if (value == null) {
            this._put(fieldName2, this.nullNode());
        } else {
            this._put(fieldName2, this.numberNode(value));
        }
    }

    public void put(String fieldName2, long v) {
        this._put(fieldName2, this.numberNode(v));
    }

    public void put(String fieldName2, Long value) {
        if (value == null) {
            this._put(fieldName2, this.nullNode());
        } else {
            this._put(fieldName2, this.numberNode(value));
        }
    }

    public void put(String fieldName2, float v) {
        this._put(fieldName2, this.numberNode(v));
    }

    public void put(String fieldName2, Float value) {
        if (value == null) {
            this._put(fieldName2, this.nullNode());
        } else {
            this._put(fieldName2, this.numberNode(value.floatValue()));
        }
    }

    public void put(String fieldName2, double v) {
        this._put(fieldName2, this.numberNode(v));
    }

    public void put(String fieldName2, Double value) {
        if (value == null) {
            this._put(fieldName2, this.nullNode());
        } else {
            this._put(fieldName2, this.numberNode(value));
        }
    }

    public void put(String fieldName2, BigDecimal v) {
        if (v == null) {
            this.putNull(fieldName2);
        } else {
            this._put(fieldName2, this.numberNode(v));
        }
    }

    public void put(String fieldName2, String v) {
        if (v == null) {
            this.putNull(fieldName2);
        } else {
            this._put(fieldName2, this.textNode(v));
        }
    }

    public void put(String fieldName2, boolean v) {
        this._put(fieldName2, this.booleanNode(v));
    }

    public void put(String fieldName2, Boolean value) {
        if (value == null) {
            this._put(fieldName2, this.nullNode());
        } else {
            this._put(fieldName2, this.booleanNode(value));
        }
    }

    public void put(String fieldName2, byte[] v) {
        if (v == null) {
            this._put(fieldName2, this.nullNode());
        } else {
            this._put(fieldName2, this.binaryNode(v));
        }
    }

    protected void putContentsTo(Map<String, JsonNode> dst) {
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
                dst.put(en.getKey(), en.getValue());
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ObjectNode other = (ObjectNode)o;
        if (other.size() != this.size()) {
            return false;
        }
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
                String key = en.getKey();
                JsonNode value = en.getValue();
                JsonNode otherValue = other.get(key);
                if (otherValue != null && otherValue.equals(value)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this._children == null ? -1 : this._children.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32 + (this.size() << 4));
        sb.append("{");
        if (this._children != null) {
            int count2 = 0;
            for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
                if (count2 > 0) {
                    sb.append(",");
                }
                ++count2;
                TextNode.appendQuoted(sb, en.getKey());
                sb.append(':');
                sb.append(en.getValue().toString());
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private final JsonNode _put(String fieldName2, JsonNode value) {
        if (this._children == null) {
            this._children = new LinkedHashMap();
        }
        return this._children.put(fieldName2, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NoFieldsIterator
    implements Iterator<Map.Entry<String, JsonNode>> {
        static final NoFieldsIterator instance = new NoFieldsIterator();

        private NoFieldsIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Map.Entry<String, JsonNode> next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

