/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.RemappingSignatureAdapter;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;

public abstract class Remapper {
    public String mapDesc(String string2) {
        Type type = Type.getType(string2);
        switch (type.getSort()) {
            case 9: {
                String string3 = this.mapDesc(type.getElementType().getDescriptor());
                for (int i = 0; i < type.getDimensions(); ++i) {
                    string3 = '[' + string3;
                }
                return string3;
            }
            case 10: {
                String string4 = this.map(type.getInternalName());
                if (string4 == null) break;
                return 'L' + string4 + ';';
            }
        }
        return string2;
    }

    private Type mapType(Type type) {
        switch (type.getSort()) {
            case 9: {
                String string2 = this.mapDesc(type.getElementType().getDescriptor());
                for (int i = 0; i < type.getDimensions(); ++i) {
                    string2 = '[' + string2;
                }
                return Type.getType(string2);
            }
            case 10: {
                String string3 = this.map(type.getInternalName());
                return string3 != null ? Type.getObjectType(string3) : type;
            }
            case 11: {
                return Type.getMethodType(this.mapMethodDesc(type.getDescriptor()));
            }
        }
        return type;
    }

    public String mapType(String string2) {
        if (string2 == null) {
            return null;
        }
        return this.mapType(Type.getObjectType(string2)).getInternalName();
    }

    public String[] mapTypes(String[] stringArray) {
        String[] stringArray2 = null;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = this.map(string2);
            if (string3 != null && stringArray2 == null) {
                stringArray2 = new String[stringArray.length];
                if (i > 0) {
                    System.arraycopy(stringArray, 0, stringArray2, 0, i);
                }
                bl = true;
            }
            if (!bl) continue;
            stringArray2[i] = string3 == null ? string2 : string3;
        }
        return bl ? stringArray2 : stringArray;
    }

    public String mapMethodDesc(String string2) {
        if ("()V".equals(string2)) {
            return string2;
        }
        Type[] typeArray = Type.getArgumentTypes(string2);
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < typeArray.length; ++i) {
            stringBuffer.append(this.mapDesc(typeArray[i].getDescriptor()));
        }
        Type type = Type.getReturnType(string2);
        if (type == Type.VOID_TYPE) {
            stringBuffer.append(")V");
            return stringBuffer.toString();
        }
        stringBuffer.append(')').append(this.mapDesc(type.getDescriptor()));
        return stringBuffer.toString();
    }

    public Object mapValue(Object object) {
        if (object instanceof Type) {
            return this.mapType((Type)object);
        }
        if (object instanceof Handle) {
            Handle handle = (Handle)object;
            return new Handle(handle.getTag(), this.mapType(handle.getOwner()), this.mapMethodName(handle.getOwner(), handle.getName(), handle.getDesc()), this.mapMethodDesc(handle.getDesc()));
        }
        return object;
    }

    public String mapSignature(String string2, boolean bl) {
        if (string2 == null) {
            return null;
        }
        SignatureReader signatureReader = new SignatureReader(string2);
        SignatureWriter signatureWriter = new SignatureWriter();
        SignatureVisitor signatureVisitor = this.createRemappingSignatureAdapter(signatureWriter);
        if (bl) {
            signatureReader.acceptType(signatureVisitor);
        } else {
            signatureReader.accept(signatureVisitor);
        }
        return signatureWriter.toString();
    }

    protected SignatureVisitor createRemappingSignatureAdapter(SignatureVisitor signatureVisitor) {
        return new RemappingSignatureAdapter(signatureVisitor, this);
    }

    public String mapMethodName(String string2, String string3, String string4) {
        return string3;
    }

    public String mapInvokeDynamicMethodName(String string2, String string3) {
        return string2;
    }

    public String mapFieldName(String string2, String string3, String string4) {
        return string3;
    }

    public String map(String string2) {
        return string2;
    }
}

