/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Output {
    private String requestId;
    private int code;
    private String message;
    private Map<String, String> properties;
    private byte[] content;

    public Output(String requestId) {
        this.requestId = requestId;
    }

    public Output(String requestId, int code, String message) {
        this.requestId = requestId;
        this.code = code;
        this.message = message;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void setContent(String content) {
        this.content = content.getBytes(StandardCharsets.UTF_8);
    }
}

