/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository.zoo;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.Model;
import ai.djl.nn.Block;
import ai.djl.repository.zoo.DefaultModelZoo;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.JsonUtils;
import ai.djl.util.Progress;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class Criteria<I, O> {
    private Application application;
    private Class<I> inputClass;
    private Class<O> outputClass;
    private String engine;
    private Device device;
    private String groupId;
    private String artifactId;
    private ModelZoo modelZoo;
    private Map<String, String> filters;
    private Map<String, Object> arguments;
    private Map<String, String> options;
    private TranslatorFactory<I, O> factory;
    private Block block;
    private String modelName;
    private Progress progress;

    Criteria(Builder<I, O> builder) {
        this.application = builder.application;
        this.inputClass = builder.inputClass;
        this.outputClass = builder.outputClass;
        this.engine = builder.engine;
        this.device = builder.device;
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.modelZoo = builder.modelZoo;
        this.filters = builder.filters;
        this.arguments = builder.arguments;
        this.options = builder.options;
        this.factory = builder.factory;
        this.block = builder.block;
        this.modelName = builder.modelName;
        this.progress = builder.progress;
    }

    public Application getApplication() {
        return this.application;
    }

    public Class<I> getInputClass() {
        return this.inputClass;
    }

    public Class<O> getOutputClass() {
        return this.outputClass;
    }

    public String getEngine() {
        return this.engine;
    }

    public Device getDevice() {
        return this.device;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public ModelZoo getModelZoo() {
        return this.modelZoo;
    }

    public Map<String, String> getFilters() {
        return this.filters;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public TranslatorFactory<I, O> getTranslatorFactory() {
        return this.factory;
    }

    public Block getBlock() {
        return this.block;
    }

    public String getModelName() {
        return this.modelName;
    }

    public Progress getProgress() {
        return this.progress;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Criteria:\n");
        if (this.application != null) {
            sb.append("\tApplication: ").append(this.application).append('\n');
        }
        sb.append("\tInput: ").append(this.inputClass).append('\n');
        sb.append("\tOutput: ").append(this.outputClass).append('\n');
        if (this.engine != null) {
            sb.append("\tEngine: ").append(this.engine).append('\n');
        }
        if (this.modelZoo != null) {
            sb.append("\tModelZoo: ").append(this.modelZoo.getGroupId()).append('\n');
        }
        if (this.groupId != null) {
            sb.append("\tGroupID: ").append(this.groupId).append('\n');
        }
        if (this.artifactId != null) {
            sb.append("\tArtifactId: ").append(this.artifactId).append('\n');
        }
        if (this.filters != null) {
            sb.append("\tFilter: ").append(JsonUtils.GSON.toJson(this.filters)).append('\n');
        }
        if (this.arguments != null) {
            sb.append("\tArguments: ").append(JsonUtils.GSON.toJson(this.arguments)).append('\n');
        }
        if (this.options != null) {
            sb.append("\tOptions: ").append(JsonUtils.GSON.toJson(this.options)).append('\n');
        }
        if (this.factory == null) {
            sb.append("\tNo translator supplied\n");
        }
        return sb.toString();
    }

    public static Builder<?, ?> builder() {
        return new Builder();
    }

    private static final class TranslatorFactorImpl<I, O>
    implements TranslatorFactory<I, O> {
        private Translator<I, O> translator;

        public TranslatorFactorImpl(Translator<I, O> translator) {
            this.translator = translator;
        }

        @Override
        public Translator<I, O> newInstance(Model model, Map<String, ?> arguments) {
            return this.translator;
        }
    }

    public static final class Builder<I, O> {
        Application application;
        Class<I> inputClass;
        Class<O> outputClass;
        String engine;
        Device device;
        String groupId;
        String artifactId;
        ModelZoo modelZoo;
        Map<String, String> filters;
        Map<String, Object> arguments;
        Map<String, String> options;
        TranslatorFactory<I, O> factory;
        Block block;
        String modelName;
        Progress progress;

        Builder() {
            this.application = Application.UNDEFINED;
        }

        private Builder(Class<I> inputClass, Class<O> outputClass, Builder<?, ?> parent) {
            this.inputClass = inputClass;
            this.outputClass = outputClass;
            this.application = parent.application;
            this.engine = parent.engine;
            this.device = parent.device;
            this.groupId = parent.groupId;
            this.filters = parent.filters;
            this.arguments = parent.arguments;
            this.options = parent.options;
            this.block = parent.block;
            this.modelName = parent.modelName;
            this.progress = parent.progress;
        }

        public <P, Q> Builder<P, Q> setTypes(Class<P> inputClass, Class<Q> outputClass) {
            return new Builder<P, Q>(inputClass, outputClass, this);
        }

        public Builder<I, O> optApplication(Application application) {
            this.application = application;
            return this;
        }

        public Builder<I, O> optEngine(String engine) {
            this.engine = engine;
            return this;
        }

        public Builder<I, O> optDevice(Device device) {
            this.device = device;
            return this;
        }

        public Builder<I, O> optGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder<I, O> optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this;
        }

        public Builder<I, O> optModelUrls(String modelUrls) {
            this.modelZoo = new DefaultModelZoo(modelUrls);
            return this;
        }

        public Builder<I, O> optModelPath(Path modelPath) throws MalformedURLException {
            this.modelZoo = new DefaultModelZoo(modelPath.toUri().toURL().toString());
            return this;
        }

        public Builder<I, O> optModelZoo(ModelZoo modelZoo) {
            this.modelZoo = modelZoo;
            return this;
        }

        public Builder<I, O> optFilters(Map<String, String> filters) {
            this.filters = filters;
            return this;
        }

        public Builder<I, O> optFilter(String key, String value) {
            if (this.filters == null) {
                this.filters = new HashMap<String, String>();
            }
            this.filters.put(key, value);
            return this;
        }

        public Builder<I, O> optBlock(Block block) {
            this.block = block;
            return this;
        }

        public Builder<I, O> optModelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public Builder<I, O> optArguments(Map<String, Object> arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder<I, O> optArgument(String key, Object value) {
            if (this.arguments == null) {
                this.arguments = new HashMap<String, Object>();
            }
            this.arguments.put(key, value);
            return this;
        }

        public Builder<I, O> optOptions(Map<String, String> options) {
            this.options = options;
            return this;
        }

        public Builder<I, O> optOption(String key, String value) {
            if (this.options == null) {
                this.options = new HashMap<String, String>();
            }
            this.options.put(key, value);
            return this;
        }

        public Builder<I, O> optTranslator(Translator<I, O> translator) {
            this.factory = new TranslatorFactorImpl<I, O>(translator);
            return this;
        }

        public Builder<I, O> optTranslatorFactory(TranslatorFactory<I, O> factory) {
            this.factory = factory;
            return this;
        }

        public Builder<I, O> optProgress(Progress progress) {
            this.progress = progress;
            return this;
        }

        public Criteria<I, O> build() {
            return new Criteria(this);
        }
    }
}

