/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.paddlepaddle.engine;

import ai.djl.Device;
import ai.djl.Model;
import ai.djl.engine.Engine;
import ai.djl.ndarray.NDManager;
import ai.djl.paddlepaddle.engine.PpModel;
import ai.djl.paddlepaddle.engine.PpNDManager;
import ai.djl.paddlepaddle.jni.LibUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class PpEngine
extends Engine {
    public static final String ENGINE_NAME = "PaddlePaddle";
    static final int RANK = 10;
    private Engine alternativeEngine;
    private boolean initialized;

    private PpEngine() {
    }

    static Engine newInstance() {
        LibUtils.loadLibrary();
        return new PpEngine();
    }

    public Engine getAlternativeEngine() {
        if (!this.initialized && !Boolean.getBoolean("ai.djl.paddlepaddle.disable_alternative")) {
            Engine engine = Engine.getInstance();
            if (engine.getRank() < this.getRank()) {
                this.alternativeEngine = engine;
            }
            this.initialized = true;
        }
        return this.alternativeEngine;
    }

    public String getEngineName() {
        return ENGINE_NAME;
    }

    public int getRank() {
        return 10;
    }

    public String getVersion() {
        String string;
        block8: {
            InputStream is = PpEngine.class.getResourceAsStream("/paddlepaddle-engine.properties");
            try {
                Properties prop = new Properties();
                prop.load(is);
                string = prop.getProperty("paddlepaddle_version");
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssertionError("Failed to load paddlapaddle-engine.properties", e);
                }
            }
            is.close();
        }
        return string;
    }

    public boolean hasCapability(String capability) {
        return false;
    }

    public Model newModel(String name, Device device) {
        return new PpModel(name, device, this.newBaseManager(device));
    }

    public NDManager newBaseManager() {
        return this.newBaseManager(null);
    }

    public NDManager newBaseManager(Device device) {
        return PpNDManager.getSystemManager().newSubManager(device);
    }
}

