package ai.koog.a2a.model

import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonObject

/**
 * Represents a file, data structure, or other resource generated by an agent during a task.
 *
 * @property artifactId A unique identifier (e.g. UUID) for the artifact within the scope of the task.
 * @property name An optional, human-readable name for the artifact.
 * @property description An optional, human-readable description of the artifact.
 * @property parts A list of content parts that make up the artifact.
 * @property extensions Optional URIs of extensions that are relevant to this artifact.
 * @property metadata Optional metadata for extensions. The key is an extension-specific identifier.
 */
@Serializable
public data class Artifact(
    public val artifactId: String,
    public val name: String? = null,
    public val description: String? = null,
    public val parts: List<Part>,
    public val extensions: List<String>? = null,
    public val metadata: JsonObject? = null,
)
