package ai.koog.agents.core.agent

/**
 * Represents a basic interface for AI agent.
 */
public interface AIAgentBase {

    /**
     * Initiates the execution of the AI agent based on the provided input prompt.
     *
     * @param agentInput the input text that guides the agent's behavior or response generation
     */
    public suspend fun run(agentInput: String)

    /**
     * Executes the AI agent with the given prompt and retrieves the resulting output.
     *
     * @param agentInput the input text used to guide the behavior or response of the AI agent
     * @return the response generated by the AI agent, or null if no result is available
     */
    public suspend fun runAndGetResult(agentInput: String): String?
}