/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.prompt.executor.ollama.client.dto;

import ai.koog.agents.core.tools.ToolDescriptor;
import ai.koog.prompt.dsl.Prompt;
import ai.koog.prompt.executor.ollama.client.dto.OllamaChatMessageDTO;
import ai.koog.prompt.executor.ollama.client.dto.OllamaChatRequestDTO;
import ai.koog.prompt.executor.ollama.client.dto.OllamaToolCallDTO;
import ai.koog.prompt.executor.ollama.client.dto.OllamaToolDTO;
import ai.koog.prompt.executor.ollama.tools.json.JSONSchemaFunctionConverterKt;
import ai.koog.prompt.llm.LLMCapability;
import ai.koog.prompt.llm.LLModel;
import ai.koog.prompt.message.Attachment;
import ai.koog.prompt.message.AttachmentContent;
import ai.koog.prompt.message.Message;
import ai.koog.prompt.message.ResponseMetaInfo;
import ai.koog.prompt.params.LLMParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u0002*\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0000\u001a\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u0003H\u0000\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0003H\u0000\u001a\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0001*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"toOllamaChatMessages", "", "Lai/koog/prompt/executor/ollama/client/dto/OllamaChatMessageDTO;", "Lai/koog/prompt/dsl/Prompt;", "model", "Lai/koog/prompt/llm/LLModel;", "toOllamaChatMessage", "Lai/koog/prompt/message/Message$User;", "toOllamaTool", "Lai/koog/prompt/executor/ollama/client/dto/OllamaToolDTO;", "Lai/koog/agents/core/tools/ToolDescriptor;", "extractOllamaJsonFormat", "Lkotlinx/serialization/json/JsonObject;", "extractOllamaOptions", "Lai/koog/prompt/executor/ollama/client/dto/OllamaChatRequestDTO$Options;", "getFirstToolCall", "Lai/koog/prompt/message/Message$Tool$Call;", "responseMetadata", "Lai/koog/prompt/message/ResponseMetaInfo;", "getToolCalls", "generateToolCallId", "", "toolName", "content", "index", "", "prompt-executor-ollama-client"})
@SourceDebugExtension(value={"SMAP\nOllamaConverters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OllamaConverters.kt\nai/koog/prompt/executor/ollama/client/dto/OllamaConvertersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,191:1\n1869#2,2:192\n1573#2:196\n1604#2,3:197\n1607#2:201\n1#3:194\n205#4:195\n205#4:200\n*S KotlinDebug\n*F\n+ 1 OllamaConverters.kt\nai/koog/prompt/executor/ollama/client/dto/OllamaConvertersKt\n*L\n64#1:192,2\n160#1:196\n160#1:197,3\n160#1:201\n139#1:195\n162#1:200\n*E\n"})
public final class OllamaConvertersKt {
    @NotNull
    public static final List<OllamaChatMessageDTO> toOllamaChatMessages(@NotNull Prompt $this$toOllamaChatMessages, @NotNull LLModel model) {
        Intrinsics.checkNotNullParameter((Object)$this$toOllamaChatMessages, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        List messages = new ArrayList();
        for (Message message : $this$toOllamaChatMessages.getMessages()) {
            OllamaChatMessageDTO ollamaChatMessageDTO;
            Message message2 = message;
            if (message2 instanceof Message.System) {
                ollamaChatMessageDTO = new OllamaChatMessageDTO("system", ((Message.System)message).getContent(), null, null, 12, null);
            } else if (message2 instanceof Message.User) {
                ollamaChatMessageDTO = OllamaConvertersKt.toOllamaChatMessage((Message.User)message, model);
            } else if (message2 instanceof Message.Assistant) {
                ollamaChatMessageDTO = new OllamaChatMessageDTO("assistant", ((Message.Assistant)message).getContent(), null, null, 12, null);
            } else if (message2 instanceof Message.Tool.Call) {
                ollamaChatMessageDTO = new OllamaChatMessageDTO("assistant", "", null, CollectionsKt.listOf((Object)new OllamaToolCallDTO(new OllamaToolCallDTO.Call(((Message.Tool.Call)message).getTool(), Json.Default.parseToJsonElement(((Message.Tool.Call)message).getContent())))), 4, null);
            } else if (message2 instanceof Message.Tool.Result) {
                ollamaChatMessageDTO = new OllamaChatMessageDTO("tool", ((Message.Tool.Result)message).getContent(), null, null, 12, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            OllamaChatMessageDTO converted = ollamaChatMessageDTO;
            messages.add(converted);
        }
        return messages;
    }

    /*
     * WARNING - void declaration
     */
    private static final OllamaChatMessageDTO toOllamaChatMessage(Message.User $this$toOllamaChatMessage, LLModel model) {
        void it;
        List list;
        List images = new ArrayList();
        Iterable $this$forEach$iv = $this$toOllamaChatMessage.getAttachments();
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            Attachment attachment = (Attachment)element$iv;
            boolean bl = false;
            if (attachment instanceof Attachment.Image) {
                if (!model.getCapabilities().contains(LLMCapability.Vision.Image.INSTANCE)) {
                    boolean $i$a$-require-OllamaConvertersKt$toOllamaChatMessage$1$22 = false;
                    String $i$a$-require-OllamaConvertersKt$toOllamaChatMessage$1$22 = "Model " + model.getId() + " doesn't support images";
                    throw new IllegalArgumentException($i$a$-require-OllamaConvertersKt$toOllamaChatMessage$1$22.toString());
                }
                AttachmentContent content = ((Attachment.Image)attachment).getContent();
                if (!(content instanceof AttachmentContent.Binary)) {
                    throw new IllegalArgumentException("Unsupported image attachment content: " + Reflection.getOrCreateKotlinClass(content.getClass()));
                }
                String image = ((AttachmentContent.Binary)content).getBase64();
                ((Collection)images).add(image);
                continue;
            }
            throw new IllegalArgumentException("Unsupported attachment type: " + attachment);
        }
        List $i$f$forEach22 = list = images;
        String string = $this$toOllamaChatMessage.getContent();
        String string2 = "user";
        boolean bl = false;
        boolean bl2 = !((Collection)it).isEmpty();
        List list2 = bl2 ? list : null;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8;
        List list3 = null;
        List list4 = list2;
        String string3 = string;
        String string4 = string2;
        return new OllamaChatMessageDTO(string4, string3, list4, list3, n, defaultConstructorMarker);
    }

    @NotNull
    public static final OllamaToolDTO toOllamaTool(@NotNull ToolDescriptor $this$toOllamaTool) {
        Intrinsics.checkNotNullParameter((Object)$this$toOllamaTool, (String)"<this>");
        JsonObject jsonSchema = JSONSchemaFunctionConverterKt.toJSONSchema($this$toOllamaTool);
        return new OllamaToolDTO("function", new OllamaToolDTO.Definition($this$toOllamaTool.getName(), $this$toOllamaTool.getDescription(), (JsonElement)jsonSchema));
    }

    @Nullable
    public static final JsonObject extractOllamaJsonFormat(@NotNull Prompt $this$extractOllamaJsonFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$extractOllamaJsonFormat, (String)"<this>");
        LLMParams.Schema schema = $this$extractOllamaJsonFormat.getParams().getSchema();
        return schema instanceof LLMParams.Schema.JSON ? ((LLMParams.Schema.JSON)schema).getSchema() : null;
    }

    @Nullable
    public static final OllamaChatRequestDTO.Options extractOllamaOptions(@NotNull Prompt $this$extractOllamaOptions) {
        OllamaChatRequestDTO.Options options;
        Double temperature;
        Intrinsics.checkNotNullParameter((Object)$this$extractOllamaOptions, (String)"<this>");
        Double d = temperature = $this$extractOllamaOptions.getParams().getTemperature();
        if (d != null) {
            double it = ((Number)d).doubleValue();
            boolean bl = false;
            options = new OllamaChatRequestDTO.Options(temperature);
        } else {
            options = null;
        }
        return options;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Message.Tool.Call getFirstToolCall(@NotNull OllamaChatMessageDTO $this$getFirstToolCall, @NotNull ResponseMetaInfo responseMetadata) {
        void this_$iv;
        Json json;
        Intrinsics.checkNotNullParameter((Object)$this$getFirstToolCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)responseMetadata, (String)"responseMetadata");
        Collection collection = $this$getFirstToolCall.getToolCalls();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        OllamaToolCallDTO ollamaToolCallDTO = (OllamaToolCallDTO)CollectionsKt.firstOrNull($this$getFirstToolCall.getToolCalls());
        if (ollamaToolCallDTO == null) {
            return null;
        }
        OllamaToolCallDTO toolCall = ollamaToolCallDTO;
        String name = toolCall.getFunction().getName();
        Json json2 = json = JsonKt.Json$default(null, OllamaConvertersKt::getFirstToolCall$lambda$4, (int)1, null);
        JsonElement value$iv = toolCall.getFunction().getArguments();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        String content = this_$iv.encodeToString((SerializationStrategy)JsonElement.Companion.serializer(), (Object)value$iv);
        return new Message.Tool.Call(OllamaConvertersKt.generateToolCallId$default(name, content, 0, 4, null), name, content, responseMetadata);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Message.Tool.Call> getToolCalls(@NotNull OllamaChatMessageDTO $this$getToolCalls, @NotNull ResponseMetaInfo responseMetadata) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getToolCalls, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)responseMetadata, (String)"responseMetadata");
        Collection collection = $this$getToolCalls.getToolCalls();
        if (collection == null || collection.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapIndexed$iv = $this$getToolCalls.getToolCalls();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void this_$iv;
            void toolCall;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            OllamaToolCallDTO ollamaToolCallDTO = (OllamaToolCallDTO)item$iv$iv;
            int n2 = n;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String name = toolCall.getFunction().getName();
            Json json = (Json)Json.Default;
            JsonElement value$iv = toolCall.getFunction().getArguments();
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            String content = this_$iv.encodeToString((SerializationStrategy)JsonElement.Companion.serializer(), (Object)value$iv);
            collection2.add(new Message.Tool.Call(OllamaConvertersKt.generateToolCallId(name, content, (int)index), name, content, responseMetadata));
        }
        return (List)destination$iv$iv;
    }

    private static final String generateToolCallId(String toolName, String content, int index) {
        String combined = toolName + ":" + content + ":" + index;
        int hashCode = combined.hashCode();
        return "ollama_tool_call_" + UInt.toString-impl((int)UInt.constructor-impl((int)hashCode));
    }

    static /* synthetic */ String generateToolCallId$default(String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return OllamaConvertersKt.generateToolCallId(string, string2, n);
    }

    private static final Unit getFirstToolCall$lambda$4(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setAllowStructuredMapKeys(true);
        return Unit.INSTANCE;
    }
}

