/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.hook;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.codehaus.aspectwerkz.hook.AbstractStarter;

public class JDWPStarter
extends AbstractStarter {
    private String transport;
    private String address;

    public JDWPStarter(String opt, String main, String transport, String address) {
        super(opt, main);
        Map jdwpOpt = this.parseJdwp();
        if (jdwpOpt.containsKey("transport")) {
            this.transport = (String)jdwpOpt.get("transport");
        } else {
            this.transport = transport;
            jdwpOpt.put("transport", this.transport);
        }
        if (jdwpOpt.containsKey("address")) {
            this.address = (String)jdwpOpt.get("address");
        } else {
            this.address = address;
            jdwpOpt.put("address", this.address);
        }
        this.patchOptions(jdwpOpt);
    }

    public String getTransport() {
        return this.transport;
    }

    public String getAddress() {
        return this.address;
    }

    private void patchOptions(Map jdwpOpt) {
        if (this.opt.indexOf("-Xdebug") < 0) {
            this.opt = "-Xdebug " + this.opt;
        }
        jdwpOpt.put("server", "y");
        jdwpOpt.put("suspend", "y");
        StringBuffer jdwp = new StringBuffer("-Xrunjdwp:");
        List<Object> keys = new ArrayList(jdwpOpt.keySet());
        keys = this.jdwpOptionSort(keys);
        Iterator<Object> i = keys.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            jdwp.append(key).append("=").append((String)jdwpOpt.get(key));
            if (!i.hasNext()) continue;
            jdwp.append(",");
        }
        if (this.opt.indexOf("-Xrunjdwp:") < 0) {
            this.opt = jdwp + " " + this.opt;
        } else {
            int from = this.opt.indexOf("-Xrunjdwp:");
            int to = Math.min(this.opt.length(), this.opt.indexOf(32, from));
            StringBuffer newOpt = new StringBuffer("");
            if (from > 0) {
                newOpt.append(this.opt.substring(0, from));
            }
            newOpt.append(" ").append(jdwp);
            if (to < this.opt.length()) {
                newOpt.append(" ").append(this.opt.substring(to, this.opt.length()));
            }
            this.opt = newOpt.toString();
        }
    }

    private Map parseJdwp() {
        if (this.opt.indexOf("-Xrunjdwp:") < 0) {
            return new HashMap();
        }
        String jdwp = this.opt.substring(this.opt.indexOf("-Xrunjdwp:") + "-Xrunjdwp:".length(), Math.min(this.opt.length(), this.opt.indexOf(32, this.opt.indexOf("-Xrunjdwp:"))));
        HashMap<String, String> jdwpOpt = new HashMap<String, String>();
        StringTokenizer stz = new StringTokenizer(jdwp, ",");
        while (stz.hasMoreTokens()) {
            String jdwpo = stz.nextToken();
            if (jdwpo.indexOf(61) < 0) {
                System.err.println("WARN - unrecognized JDWP option: " + jdwpo);
                continue;
            }
            jdwpOpt.put(jdwpo.substring(0, jdwpo.indexOf(61)), jdwpo.substring(jdwpo.indexOf(61) + 1));
        }
        return jdwpOpt;
    }

    private List jdwpOptionSort(List opt) {
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    if ("transport".equals((String)o1)) {
                        return -1000;
                    }
                    if ("transport".equals((String)o2)) {
                        return 1000;
                    }
                    return 0;
                }
                return 0;
            }
        };
        Collections.sort(opt, c);
        return opt;
    }
}

