// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chimesdkidentity

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.chimesdkidentity.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.chimesdkidentity.endpoints.EndpointParameters
import aws.sdk.kotlin.services.chimesdkidentity.endpoints.EndpointProvider
import aws.sdk.kotlin.services.chimesdkidentity.model.CreateAppInstanceAdminRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.CreateAppInstanceAdminResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.CreateAppInstanceBotRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.CreateAppInstanceBotResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.CreateAppInstanceRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.CreateAppInstanceResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.CreateAppInstanceUserRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.CreateAppInstanceUserResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.DeleteAppInstanceAdminRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.DeleteAppInstanceAdminResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.DeleteAppInstanceBotRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.DeleteAppInstanceBotResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.DeleteAppInstanceRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.DeleteAppInstanceResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.DeleteAppInstanceUserRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.DeleteAppInstanceUserResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.DeregisterAppInstanceUserEndpointRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.DeregisterAppInstanceUserEndpointResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.DescribeAppInstanceAdminRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.DescribeAppInstanceAdminResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.DescribeAppInstanceBotRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.DescribeAppInstanceBotResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.DescribeAppInstanceRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.DescribeAppInstanceResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.DescribeAppInstanceUserEndpointRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.DescribeAppInstanceUserEndpointResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.DescribeAppInstanceUserRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.DescribeAppInstanceUserResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.GetAppInstanceRetentionSettingsRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.GetAppInstanceRetentionSettingsResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstanceAdminsRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstanceAdminsResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstanceBotsRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstanceBotsResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstanceUserEndpointsRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstanceUserEndpointsResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstanceUsersRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstanceUsersResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstancesRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.ListAppInstancesResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.PutAppInstanceRetentionSettingsRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.PutAppInstanceRetentionSettingsResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.PutAppInstanceUserExpirationSettingsRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.PutAppInstanceUserExpirationSettingsResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.RegisterAppInstanceUserEndpointRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.RegisterAppInstanceUserEndpointResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.TagResourceRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.TagResourceResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.UntagResourceRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.UntagResourceResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.UpdateAppInstanceBotRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.UpdateAppInstanceBotResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.UpdateAppInstanceRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.UpdateAppInstanceResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.UpdateAppInstanceUserEndpointRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.UpdateAppInstanceUserEndpointResponse
import aws.sdk.kotlin.services.chimesdkidentity.model.UpdateAppInstanceUserRequest
import aws.sdk.kotlin.services.chimesdkidentity.model.UpdateAppInstanceUserResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Chime SDK Identity"
public const val SdkVersion: String = "0.29.1-beta"

/**
 * The Amazon Chime SDK Identity APIs in this section allow software developers to create and manage unique instances of their messaging applications. These APIs provide the overarching framework for creating and sending messages. For more information about the identity APIs, refer to [Amazon Chime SDK identity](https://docs.aws.amazon.com/chime/latest/APIReference/API_Operations_Amazon_Chime_SDK_Identity.html).
 */
public interface ChimeSdkIdentityClient : SdkClient {
    /**
     * ChimeSdkIdentityClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ChimeSdkIdentityClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ChimeSdkIdentityClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ChimeSdkIdentityClient = DefaultChimeSdkIdentityClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Chime SDK Identity"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [HttpAuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an Amazon Chime SDK messaging `AppInstance` under an AWS account. Only SDK messaging customers use this API. `CreateAppInstance` supports idempotency behavior as described in the AWS API Standard.
     *
     * identity
     */
    public suspend fun createAppInstance(input: CreateAppInstanceRequest): CreateAppInstanceResponse

    /**
     * Promotes an `AppInstanceUser` or `AppInstanceBot` to an `AppInstanceAdmin`. The promoted entity can perform the following actions.
     * + `ChannelModerator` actions across all channels in the `AppInstance`.
     * + `DeleteChannelMessage` actions.
     *
     * Only an `AppInstanceUser` and `AppInstanceBot` can be promoted to an `AppInstanceAdmin` role.
     */
    public suspend fun createAppInstanceAdmin(input: CreateAppInstanceAdminRequest): CreateAppInstanceAdminResponse

    /**
     * Creates a bot under an Amazon Chime `AppInstance`. The request consists of a unique `Configuration` and `Name` for that bot.
     */
    public suspend fun createAppInstanceBot(input: CreateAppInstanceBotRequest): CreateAppInstanceBotResponse

    /**
     * Creates a user under an Amazon Chime `AppInstance`. The request consists of a unique `appInstanceUserId` and `Name` for that user.
     */
    public suspend fun createAppInstanceUser(input: CreateAppInstanceUserRequest): CreateAppInstanceUserResponse

    /**
     * Deletes an `AppInstance` and all associated data asynchronously.
     */
    public suspend fun deleteAppInstance(input: DeleteAppInstanceRequest): DeleteAppInstanceResponse

    /**
     * Demotes an `AppInstanceAdmin` to an `AppInstanceUser` or `AppInstanceBot`. This action does not delete the user.
     */
    public suspend fun deleteAppInstanceAdmin(input: DeleteAppInstanceAdminRequest): DeleteAppInstanceAdminResponse

    /**
     * Deletes an `AppInstanceBot`.
     */
    public suspend fun deleteAppInstanceBot(input: DeleteAppInstanceBotRequest): DeleteAppInstanceBotResponse

    /**
     * Deletes an `AppInstanceUser`.
     */
    public suspend fun deleteAppInstanceUser(input: DeleteAppInstanceUserRequest): DeleteAppInstanceUserResponse

    /**
     * Deregisters an `AppInstanceUserEndpoint`.
     */
    public suspend fun deregisterAppInstanceUserEndpoint(input: DeregisterAppInstanceUserEndpointRequest): DeregisterAppInstanceUserEndpointResponse

    /**
     * Returns the full details of an `AppInstance`.
     */
    public suspend fun describeAppInstance(input: DescribeAppInstanceRequest): DescribeAppInstanceResponse

    /**
     * Returns the full details of an `AppInstanceAdmin`.
     */
    public suspend fun describeAppInstanceAdmin(input: DescribeAppInstanceAdminRequest): DescribeAppInstanceAdminResponse

    /**
     * The `AppInstanceBot's` information.
     */
    public suspend fun describeAppInstanceBot(input: DescribeAppInstanceBotRequest): DescribeAppInstanceBotResponse

    /**
     * Returns the full details of an `AppInstanceUser`.
     */
    public suspend fun describeAppInstanceUser(input: DescribeAppInstanceUserRequest): DescribeAppInstanceUserResponse

    /**
     * Returns the full details of an `AppInstanceUserEndpoint`.
     */
    public suspend fun describeAppInstanceUserEndpoint(input: DescribeAppInstanceUserEndpointRequest): DescribeAppInstanceUserEndpointResponse

    /**
     * Gets the retention settings for an `AppInstance`.
     */
    public suspend fun getAppInstanceRetentionSettings(input: GetAppInstanceRetentionSettingsRequest): GetAppInstanceRetentionSettingsResponse

    /**
     * Returns a list of the administrators in the `AppInstance`.
     */
    public suspend fun listAppInstanceAdmins(input: ListAppInstanceAdminsRequest): ListAppInstanceAdminsResponse

    /**
     * Lists all `AppInstanceBots` created under a single `AppInstance`.
     */
    public suspend fun listAppInstanceBots(input: ListAppInstanceBotsRequest): ListAppInstanceBotsResponse

    /**
     * Lists all the `AppInstanceUserEndpoints` created under a single `AppInstanceUser`.
     */
    public suspend fun listAppInstanceUserEndpoints(input: ListAppInstanceUserEndpointsRequest): ListAppInstanceUserEndpointsResponse

    /**
     * List all `AppInstanceUsers` created under a single `AppInstance`.
     */
    public suspend fun listAppInstanceUsers(input: ListAppInstanceUsersRequest): ListAppInstanceUsersResponse

    /**
     * Lists all Amazon Chime `AppInstance`s created under a single AWS account.
     */
    public suspend fun listAppInstances(input: ListAppInstancesRequest = ListAppInstancesRequest {}): ListAppInstancesResponse

    /**
     * Lists the tags applied to an Amazon Chime SDK identity resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Sets the amount of time in days that a given `AppInstance` retains data.
     */
    public suspend fun putAppInstanceRetentionSettings(input: PutAppInstanceRetentionSettingsRequest): PutAppInstanceRetentionSettingsResponse

    /**
     * Sets the number of days before the `AppInstanceUser` is automatically deleted.
     *
     * A background process deletes expired `AppInstanceUsers` within 6 hours of expiration. Actual deletion times may vary.
     *
     * Expired `AppInstanceUsers` that have not yet been deleted appear as active, and you can update their expiration settings. The system honors the new settings.
     */
    public suspend fun putAppInstanceUserExpirationSettings(input: PutAppInstanceUserExpirationSettingsRequest): PutAppInstanceUserExpirationSettingsResponse

    /**
     * Registers an endpoint under an Amazon Chime `AppInstanceUser`. The endpoint receives messages for a user. For push notifications, the endpoint is a mobile device used to receive mobile push notifications for a user.
     */
    public suspend fun registerAppInstanceUserEndpoint(input: RegisterAppInstanceUserEndpointRequest): RegisterAppInstanceUserEndpointResponse

    /**
     * Applies the specified tags to the specified Amazon Chime SDK identity resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the specified Amazon Chime SDK identity resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates `AppInstance` metadata.
     */
    public suspend fun updateAppInstance(input: UpdateAppInstanceRequest): UpdateAppInstanceResponse

    /**
     * Updates the name and metadata of an `AppInstanceBot`.
     */
    public suspend fun updateAppInstanceBot(input: UpdateAppInstanceBotRequest): UpdateAppInstanceBotResponse

    /**
     * Updates the details of an `AppInstanceUser`. You can update names and metadata.
     */
    public suspend fun updateAppInstanceUser(input: UpdateAppInstanceUserRequest): UpdateAppInstanceUserResponse

    /**
     * Updates the details of an `AppInstanceUserEndpoint`. You can update the name and `AllowMessage` values.
     */
    public suspend fun updateAppInstanceUserEndpoint(input: UpdateAppInstanceUserEndpointRequest): UpdateAppInstanceUserEndpointResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ChimeSdkIdentityClient.withConfig(block: ChimeSdkIdentityClient.Config.Builder.() -> Unit): ChimeSdkIdentityClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultChimeSdkIdentityClient(newConfig)
}

/**
 * Creates an Amazon Chime SDK messaging `AppInstance` under an AWS account. Only SDK messaging customers use this API. `CreateAppInstance` supports idempotency behavior as described in the AWS API Standard.
 *
 * identity
 */
public suspend inline fun ChimeSdkIdentityClient.createAppInstance(crossinline block: CreateAppInstanceRequest.Builder.() -> Unit): CreateAppInstanceResponse = createAppInstance(CreateAppInstanceRequest.Builder().apply(block).build())

/**
 * Promotes an `AppInstanceUser` or `AppInstanceBot` to an `AppInstanceAdmin`. The promoted entity can perform the following actions.
 * + `ChannelModerator` actions across all channels in the `AppInstance`.
 * + `DeleteChannelMessage` actions.
 *
 * Only an `AppInstanceUser` and `AppInstanceBot` can be promoted to an `AppInstanceAdmin` role.
 */
public suspend inline fun ChimeSdkIdentityClient.createAppInstanceAdmin(crossinline block: CreateAppInstanceAdminRequest.Builder.() -> Unit): CreateAppInstanceAdminResponse = createAppInstanceAdmin(CreateAppInstanceAdminRequest.Builder().apply(block).build())

/**
 * Creates a bot under an Amazon Chime `AppInstance`. The request consists of a unique `Configuration` and `Name` for that bot.
 */
public suspend inline fun ChimeSdkIdentityClient.createAppInstanceBot(crossinline block: CreateAppInstanceBotRequest.Builder.() -> Unit): CreateAppInstanceBotResponse = createAppInstanceBot(CreateAppInstanceBotRequest.Builder().apply(block).build())

/**
 * Creates a user under an Amazon Chime `AppInstance`. The request consists of a unique `appInstanceUserId` and `Name` for that user.
 */
public suspend inline fun ChimeSdkIdentityClient.createAppInstanceUser(crossinline block: CreateAppInstanceUserRequest.Builder.() -> Unit): CreateAppInstanceUserResponse = createAppInstanceUser(CreateAppInstanceUserRequest.Builder().apply(block).build())

/**
 * Deletes an `AppInstance` and all associated data asynchronously.
 */
public suspend inline fun ChimeSdkIdentityClient.deleteAppInstance(crossinline block: DeleteAppInstanceRequest.Builder.() -> Unit): DeleteAppInstanceResponse = deleteAppInstance(DeleteAppInstanceRequest.Builder().apply(block).build())

/**
 * Demotes an `AppInstanceAdmin` to an `AppInstanceUser` or `AppInstanceBot`. This action does not delete the user.
 */
public suspend inline fun ChimeSdkIdentityClient.deleteAppInstanceAdmin(crossinline block: DeleteAppInstanceAdminRequest.Builder.() -> Unit): DeleteAppInstanceAdminResponse = deleteAppInstanceAdmin(DeleteAppInstanceAdminRequest.Builder().apply(block).build())

/**
 * Deletes an `AppInstanceBot`.
 */
public suspend inline fun ChimeSdkIdentityClient.deleteAppInstanceBot(crossinline block: DeleteAppInstanceBotRequest.Builder.() -> Unit): DeleteAppInstanceBotResponse = deleteAppInstanceBot(DeleteAppInstanceBotRequest.Builder().apply(block).build())

/**
 * Deletes an `AppInstanceUser`.
 */
public suspend inline fun ChimeSdkIdentityClient.deleteAppInstanceUser(crossinline block: DeleteAppInstanceUserRequest.Builder.() -> Unit): DeleteAppInstanceUserResponse = deleteAppInstanceUser(DeleteAppInstanceUserRequest.Builder().apply(block).build())

/**
 * Deregisters an `AppInstanceUserEndpoint`.
 */
public suspend inline fun ChimeSdkIdentityClient.deregisterAppInstanceUserEndpoint(crossinline block: DeregisterAppInstanceUserEndpointRequest.Builder.() -> Unit): DeregisterAppInstanceUserEndpointResponse = deregisterAppInstanceUserEndpoint(DeregisterAppInstanceUserEndpointRequest.Builder().apply(block).build())

/**
 * Returns the full details of an `AppInstance`.
 */
public suspend inline fun ChimeSdkIdentityClient.describeAppInstance(crossinline block: DescribeAppInstanceRequest.Builder.() -> Unit): DescribeAppInstanceResponse = describeAppInstance(DescribeAppInstanceRequest.Builder().apply(block).build())

/**
 * Returns the full details of an `AppInstanceAdmin`.
 */
public suspend inline fun ChimeSdkIdentityClient.describeAppInstanceAdmin(crossinline block: DescribeAppInstanceAdminRequest.Builder.() -> Unit): DescribeAppInstanceAdminResponse = describeAppInstanceAdmin(DescribeAppInstanceAdminRequest.Builder().apply(block).build())

/**
 * The `AppInstanceBot's` information.
 */
public suspend inline fun ChimeSdkIdentityClient.describeAppInstanceBot(crossinline block: DescribeAppInstanceBotRequest.Builder.() -> Unit): DescribeAppInstanceBotResponse = describeAppInstanceBot(DescribeAppInstanceBotRequest.Builder().apply(block).build())

/**
 * Returns the full details of an `AppInstanceUser`.
 */
public suspend inline fun ChimeSdkIdentityClient.describeAppInstanceUser(crossinline block: DescribeAppInstanceUserRequest.Builder.() -> Unit): DescribeAppInstanceUserResponse = describeAppInstanceUser(DescribeAppInstanceUserRequest.Builder().apply(block).build())

/**
 * Returns the full details of an `AppInstanceUserEndpoint`.
 */
public suspend inline fun ChimeSdkIdentityClient.describeAppInstanceUserEndpoint(crossinline block: DescribeAppInstanceUserEndpointRequest.Builder.() -> Unit): DescribeAppInstanceUserEndpointResponse = describeAppInstanceUserEndpoint(DescribeAppInstanceUserEndpointRequest.Builder().apply(block).build())

/**
 * Gets the retention settings for an `AppInstance`.
 */
public suspend inline fun ChimeSdkIdentityClient.getAppInstanceRetentionSettings(crossinline block: GetAppInstanceRetentionSettingsRequest.Builder.() -> Unit): GetAppInstanceRetentionSettingsResponse = getAppInstanceRetentionSettings(GetAppInstanceRetentionSettingsRequest.Builder().apply(block).build())

/**
 * Returns a list of the administrators in the `AppInstance`.
 */
public suspend inline fun ChimeSdkIdentityClient.listAppInstanceAdmins(crossinline block: ListAppInstanceAdminsRequest.Builder.() -> Unit): ListAppInstanceAdminsResponse = listAppInstanceAdmins(ListAppInstanceAdminsRequest.Builder().apply(block).build())

/**
 * Lists all `AppInstanceBots` created under a single `AppInstance`.
 */
public suspend inline fun ChimeSdkIdentityClient.listAppInstanceBots(crossinline block: ListAppInstanceBotsRequest.Builder.() -> Unit): ListAppInstanceBotsResponse = listAppInstanceBots(ListAppInstanceBotsRequest.Builder().apply(block).build())

/**
 * Lists all the `AppInstanceUserEndpoints` created under a single `AppInstanceUser`.
 */
public suspend inline fun ChimeSdkIdentityClient.listAppInstanceUserEndpoints(crossinline block: ListAppInstanceUserEndpointsRequest.Builder.() -> Unit): ListAppInstanceUserEndpointsResponse = listAppInstanceUserEndpoints(ListAppInstanceUserEndpointsRequest.Builder().apply(block).build())

/**
 * List all `AppInstanceUsers` created under a single `AppInstance`.
 */
public suspend inline fun ChimeSdkIdentityClient.listAppInstanceUsers(crossinline block: ListAppInstanceUsersRequest.Builder.() -> Unit): ListAppInstanceUsersResponse = listAppInstanceUsers(ListAppInstanceUsersRequest.Builder().apply(block).build())

/**
 * Lists all Amazon Chime `AppInstance`s created under a single AWS account.
 */
public suspend inline fun ChimeSdkIdentityClient.listAppInstances(crossinline block: ListAppInstancesRequest.Builder.() -> Unit): ListAppInstancesResponse = listAppInstances(ListAppInstancesRequest.Builder().apply(block).build())

/**
 * Lists the tags applied to an Amazon Chime SDK identity resource.
 */
public suspend inline fun ChimeSdkIdentityClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Sets the amount of time in days that a given `AppInstance` retains data.
 */
public suspend inline fun ChimeSdkIdentityClient.putAppInstanceRetentionSettings(crossinline block: PutAppInstanceRetentionSettingsRequest.Builder.() -> Unit): PutAppInstanceRetentionSettingsResponse = putAppInstanceRetentionSettings(PutAppInstanceRetentionSettingsRequest.Builder().apply(block).build())

/**
 * Sets the number of days before the `AppInstanceUser` is automatically deleted.
 *
 * A background process deletes expired `AppInstanceUsers` within 6 hours of expiration. Actual deletion times may vary.
 *
 * Expired `AppInstanceUsers` that have not yet been deleted appear as active, and you can update their expiration settings. The system honors the new settings.
 */
public suspend inline fun ChimeSdkIdentityClient.putAppInstanceUserExpirationSettings(crossinline block: PutAppInstanceUserExpirationSettingsRequest.Builder.() -> Unit): PutAppInstanceUserExpirationSettingsResponse = putAppInstanceUserExpirationSettings(PutAppInstanceUserExpirationSettingsRequest.Builder().apply(block).build())

/**
 * Registers an endpoint under an Amazon Chime `AppInstanceUser`. The endpoint receives messages for a user. For push notifications, the endpoint is a mobile device used to receive mobile push notifications for a user.
 */
public suspend inline fun ChimeSdkIdentityClient.registerAppInstanceUserEndpoint(crossinline block: RegisterAppInstanceUserEndpointRequest.Builder.() -> Unit): RegisterAppInstanceUserEndpointResponse = registerAppInstanceUserEndpoint(RegisterAppInstanceUserEndpointRequest.Builder().apply(block).build())

/**
 * Applies the specified tags to the specified Amazon Chime SDK identity resource.
 */
public suspend inline fun ChimeSdkIdentityClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified Amazon Chime SDK identity resource.
 */
public suspend inline fun ChimeSdkIdentityClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates `AppInstance` metadata.
 */
public suspend inline fun ChimeSdkIdentityClient.updateAppInstance(crossinline block: UpdateAppInstanceRequest.Builder.() -> Unit): UpdateAppInstanceResponse = updateAppInstance(UpdateAppInstanceRequest.Builder().apply(block).build())

/**
 * Updates the name and metadata of an `AppInstanceBot`.
 */
public suspend inline fun ChimeSdkIdentityClient.updateAppInstanceBot(crossinline block: UpdateAppInstanceBotRequest.Builder.() -> Unit): UpdateAppInstanceBotResponse = updateAppInstanceBot(UpdateAppInstanceBotRequest.Builder().apply(block).build())

/**
 * Updates the details of an `AppInstanceUser`. You can update names and metadata.
 */
public suspend inline fun ChimeSdkIdentityClient.updateAppInstanceUser(crossinline block: UpdateAppInstanceUserRequest.Builder.() -> Unit): UpdateAppInstanceUserResponse = updateAppInstanceUser(UpdateAppInstanceUserRequest.Builder().apply(block).build())

/**
 * Updates the details of an `AppInstanceUserEndpoint`. You can update the name and `AllowMessage` values.
 */
public suspend inline fun ChimeSdkIdentityClient.updateAppInstanceUserEndpoint(crossinline block: UpdateAppInstanceUserEndpointRequest.Builder.() -> Unit): UpdateAppInstanceUserEndpointResponse = updateAppInstanceUserEndpoint(UpdateAppInstanceUserEndpointRequest.Builder().apply(block).build())
