// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentity.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A rule that maps a claim name, a claim value, and a match type to a role ARN.
 */
public class MappingRule private constructor(builder: Builder) {
    /**
     * The claim name that must be present in the token, for example, "isAdmin" or "paid".
     */
    public val claim: kotlin.String = requireNotNull(builder.claim) { "A non-null value must be provided for claim" }
    /**
     * The match condition that specifies how closely the claim value in the IdP token must match `Value`.
     */
    public val matchType: aws.sdk.kotlin.services.cognitoidentity.model.MappingRuleMatchType = requireNotNull(builder.matchType) { "A non-null value must be provided for matchType" }
    /**
     * The role ARN.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * A brief string that the claim must match, for example, "paid" or "yes".
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentity.model.MappingRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MappingRule(")
        append("claim=$claim,")
        append("matchType=$matchType,")
        append("roleArn=$roleArn,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = claim.hashCode()
        result = 31 * result + (matchType.hashCode())
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MappingRule

        if (claim != other.claim) return false
        if (matchType != other.matchType) return false
        if (roleArn != other.roleArn) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentity.model.MappingRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The claim name that must be present in the token, for example, "isAdmin" or "paid".
         */
        public var claim: kotlin.String? = null
        /**
         * The match condition that specifies how closely the claim value in the IdP token must match `Value`.
         */
        public var matchType: aws.sdk.kotlin.services.cognitoidentity.model.MappingRuleMatchType? = null
        /**
         * The role ARN.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A brief string that the claim must match, for example, "paid" or "yes".
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentity.model.MappingRule) : this() {
            this.claim = x.claim
            this.matchType = x.matchType
            this.roleArn = x.roleArn
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentity.model.MappingRule = MappingRule(this)

        internal fun correctErrors(): Builder {
            if (claim == null) claim = ""
            if (matchType == null) matchType = MappingRuleMatchType.SdkUnknown("no value provided")
            if (roleArn == null) roleArn = ""
            if (value == null) value = ""
            return this
        }
    }
}
