// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costandusagereportservice

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.costandusagereportservice.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.costandusagereportservice.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucketOptions

/**
 * The AWS Cost and Usage Report API enables you to programmatically create, query, and delete
 * AWS Cost and Usage report definitions.
 * AWS Cost and Usage reports track the monthly AWS costs and usage
 * associated with your AWS account.
 *
 * The report contains line items for each unique combination of AWS product,
 * usage type, and operation that your AWS account uses.
 *
 * You can configure the AWS Cost and Usage report to show only the data that you want, using the
 * AWS Cost and Usage API.
 *
 * Service Endpoint
 * The AWS Cost and Usage Report API provides the following endpoint:
 *
 *
 * cur.us-east-1.amazonaws.com
 */
interface CostAndUsageReportClient : SdkClient {

    override val serviceName: String
        get() = "Cost and Usage Report Service"
    /**
     * CostAndUsageReportClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): CostAndUsageReportClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCostAndUsageReportClient(config)
        }

        operator fun invoke(config: Config): CostAndUsageReportClient = DefaultCostAndUsageReportClient(config)

        /**
         * Construct a [CostAndUsageReportClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CostAndUsageReportClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultCostAndUsageReportClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes the specified report.
     */
    suspend fun deleteReportDefinition(input: DeleteReportDefinitionRequest): DeleteReportDefinitionResponse

    /**
     * Deletes the specified report.
     */
    suspend fun deleteReportDefinition(block: DeleteReportDefinitionRequest.Builder.() -> Unit) = deleteReportDefinition(DeleteReportDefinitionRequest.Builder().apply(block).build())

    /**
     * Lists the AWS Cost and Usage reports available to this account.
     */
    suspend fun describeReportDefinitions(input: DescribeReportDefinitionsRequest): DescribeReportDefinitionsResponse

    /**
     * Lists the AWS Cost and Usage reports available to this account.
     */
    suspend fun describeReportDefinitions(block: DescribeReportDefinitionsRequest.Builder.() -> Unit) = describeReportDefinitions(DescribeReportDefinitionsRequest.Builder().apply(block).build())

    /**
     * Allows you to programatically update your report preferences.
     */
    suspend fun modifyReportDefinition(input: ModifyReportDefinitionRequest): ModifyReportDefinitionResponse

    /**
     * Allows you to programatically update your report preferences.
     */
    suspend fun modifyReportDefinition(block: ModifyReportDefinitionRequest.Builder.() -> Unit) = modifyReportDefinition(ModifyReportDefinitionRequest.Builder().apply(block).build())

    /**
     * Creates a new report using the description that you provide.
     */
    suspend fun putReportDefinition(input: PutReportDefinitionRequest): PutReportDefinitionResponse

    /**
     * Creates a new report using the description that you provide.
     */
    suspend fun putReportDefinition(block: PutReportDefinitionRequest.Builder.() -> Unit) = putReportDefinition(PutReportDefinitionRequest.Builder().apply(block).build())
}
