// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.costandusagereportservice.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.costandusagereportservice.model.CostAndUsageReportException
import aws.sdk.kotlin.services.costandusagereportservice.model.PutReportDefinitionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class PutReportDefinitionOperationDeserializer: HttpDeserialize<PutReportDefinitionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutReportDefinitionResponse {
        if (!response.status.isSuccess()) {
            throwPutReportDefinitionError(context, response)
        }
        val builder = PutReportDefinitionResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwPutReportDefinitionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CostAndUsageReportException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DuplicateReportNameException" -> DuplicateReportNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "ReportLimitReachedException" -> ReportLimitReachedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CostAndUsageReportException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
