// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.dlm.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.dlm.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>Amazon Data Lifecycle Manager</fullname>
 * With Amazon Data Lifecycle Manager, you can manage the lifecycle of your Amazon Web Services resources. You create
 * lifecycle policies, which are used to automate operations on the specified
 * resources.
 * Amazon DLM supports Amazon EBS volumes and snapshots. For information about using Amazon DLM
 * with Amazon EBS, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-lifecycle.html">Automating the Amazon EBS
 * Snapshot Lifecycle in the Amazon EC2 User Guide.
 */
interface DlmClient : SdkClient {

    override val serviceName: String
        get() = "DLM"
    /**
     * DlmClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): DlmClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
                sdkLogMode = sharedConfig?.sdkLogMode ?: SdkLogMode.Default
            }.apply(block).build()
            return DefaultDlmClient(config)
        }

        operator fun invoke(config: Config): DlmClient = DefaultDlmClient(config)

        /**
         * Construct a [DlmClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): DlmClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return DlmClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a policy to manage the lifecycle of the specified Amazon Web Services resources. You can
     * create up to 100 lifecycle policies.
     */
    suspend fun createLifecyclePolicy(input: CreateLifecyclePolicyRequest): CreateLifecyclePolicyResponse

    /**
     * Creates a policy to manage the lifecycle of the specified Amazon Web Services resources. You can
     * create up to 100 lifecycle policies.
     */
    suspend fun createLifecyclePolicy(block: CreateLifecyclePolicyRequest.Builder.() -> Unit) = createLifecyclePolicy(CreateLifecyclePolicyRequest.Builder().apply(block).build())

    /**
     * Deletes the specified lifecycle policy and halts the automated operations that the
     * policy specified.
     */
    suspend fun deleteLifecyclePolicy(input: DeleteLifecyclePolicyRequest): DeleteLifecyclePolicyResponse

    /**
     * Deletes the specified lifecycle policy and halts the automated operations that the
     * policy specified.
     */
    suspend fun deleteLifecyclePolicy(block: DeleteLifecyclePolicyRequest.Builder.() -> Unit) = deleteLifecyclePolicy(DeleteLifecyclePolicyRequest.Builder().apply(block).build())

    /**
     * Gets summary information about all or the specified data lifecycle policies.
     * To get complete information about a policy, use GetLifecyclePolicy.
     */
    suspend fun getLifecyclePolicies(input: GetLifecyclePoliciesRequest): GetLifecyclePoliciesResponse

    /**
     * Gets summary information about all or the specified data lifecycle policies.
     * To get complete information about a policy, use GetLifecyclePolicy.
     */
    suspend fun getLifecyclePolicies(block: GetLifecyclePoliciesRequest.Builder.() -> Unit) = getLifecyclePolicies(GetLifecyclePoliciesRequest.Builder().apply(block).build())

    /**
     * Gets detailed information about the specified lifecycle policy.
     */
    suspend fun getLifecyclePolicy(input: GetLifecyclePolicyRequest): GetLifecyclePolicyResponse

    /**
     * Gets detailed information about the specified lifecycle policy.
     */
    suspend fun getLifecyclePolicy(block: GetLifecyclePolicyRequest.Builder.() -> Unit) = getLifecyclePolicy(GetLifecyclePolicyRequest.Builder().apply(block).build())

    /**
     * Lists the tags for the specified resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags for the specified resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Adds the specified tags to the specified resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds the specified tags to the specified resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes the specified tags from the specified resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the specified tags from the specified resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the specified lifecycle policy.
     */
    suspend fun updateLifecyclePolicy(input: UpdateLifecyclePolicyRequest): UpdateLifecyclePolicyResponse

    /**
     * Updates the specified lifecycle policy.
     */
    suspend fun updateLifecyclePolicy(block: UpdateLifecyclePolicyRequest.Builder.() -> Unit) = updateLifecyclePolicy(UpdateLifecyclePolicyRequest.Builder().apply(block).build())
}
