// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model



/**
 * Specifies when to create snapshots of EBS volumes.
 * You must specify either a Cron expression or an interval, interval unit, and start
 * time. You cannot specify both.
 */
class CreateRule private constructor(builder: Builder) {
    /**
     * The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1
     * year. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
     * expressions in the Amazon CloudWatch User Guide.
     */
    val cronExpression: kotlin.String? = builder.cronExpression
    /**
     * The interval between snapshots. The supported values are 1, 2, 3, 4, 6, 8, 12, and
     * 24.
     */
    val interval: kotlin.Int = builder.interval
    /**
     * The interval unit.
     */
    val intervalUnit: aws.sdk.kotlin.services.dlm.model.IntervalUnitValues? = builder.intervalUnit
    /**
     * Specifies the destination for snapshots created by the policy. To create snapshots in the same
     * Region as the source resource, specify CLOUD. To create snapshots on the same
     * Outpost as the source resource, specify OUTPOST_LOCAL. If you omit this
     * parameter, CLOUD is used by default.
     * If the policy targets resources in an Amazon Web Services Region, then you must create snapshots in the same
     * Region as the source resource.
     * If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost
     * as the source resource, or in the Region of that Outpost.
     */
    val location: aws.sdk.kotlin.services.dlm.model.LocationValues? = builder.location
    /**
     * The time, in UTC, to start the operation. The supported format is hh:mm.
     * The operation occurs within a one-hour window following the specified time. If you do
     * not specify a time, Amazon DLM selects a time within the next 24 hours.
     */
    val times: List<String>? = builder.times

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.CreateRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRule(")
        append("cronExpression=$cronExpression,")
        append("interval=$interval,")
        append("intervalUnit=$intervalUnit,")
        append("location=$location,")
        append("times=$times)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cronExpression?.hashCode() ?: 0
        result = 31 * result + (interval)
        result = 31 * result + (intervalUnit?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (times?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRule

        if (cronExpression != other.cronExpression) return false
        if (interval != other.interval) return false
        if (intervalUnit != other.intervalUnit) return false
        if (location != other.location) return false
        if (times != other.times) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.CreateRule = Builder(this).apply(block).build()

    class Builder {
        /**
         * The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1
         * year. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
         * expressions in the Amazon CloudWatch User Guide.
         */
        var cronExpression: kotlin.String? = null
        /**
         * The interval between snapshots. The supported values are 1, 2, 3, 4, 6, 8, 12, and
         * 24.
         */
        var interval: kotlin.Int = 0
        /**
         * The interval unit.
         */
        var intervalUnit: aws.sdk.kotlin.services.dlm.model.IntervalUnitValues? = null
        /**
         * Specifies the destination for snapshots created by the policy. To create snapshots in the same
         * Region as the source resource, specify CLOUD. To create snapshots on the same
         * Outpost as the source resource, specify OUTPOST_LOCAL. If you omit this
         * parameter, CLOUD is used by default.
         * If the policy targets resources in an Amazon Web Services Region, then you must create snapshots in the same
         * Region as the source resource.
         * If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost
         * as the source resource, or in the Region of that Outpost.
         */
        var location: aws.sdk.kotlin.services.dlm.model.LocationValues? = null
        /**
         * The time, in UTC, to start the operation. The supported format is hh:mm.
         * The operation occurs within a one-hour window following the specified time. If you do
         * not specify a time, Amazon DLM selects a time within the next 24 hours.
         */
        var times: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.CreateRule) : this() {
            this.cronExpression = x.cronExpression
            this.interval = x.interval
            this.intervalUnit = x.intervalUnit
            this.location = x.location
            this.times = x.times
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.CreateRule = CreateRule(this)
    }
}
