// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model



/**
 * Specifies a rule for cross-Region snapshot copies.
 */
class CrossRegionCopyRule private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this
     * parameter is not specified, the default KMS key for the account is used.
     */
    val cmkArn: kotlin.String? = builder.cmkArn
    /**
     * Indicates whether to copy all user-defined tags from the source snapshot to the cross-Region
     * snapshot copy.
     */
    val copyTags: kotlin.Boolean? = builder.copyTags
    /**
     * The AMI deprecation rule for cross-Region AMI copies created by the rule.
     */
    val deprecateRule: aws.sdk.kotlin.services.dlm.model.CrossRegionCopyDeprecateRule? = builder.deprecateRule
    /**
     * To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled,
     * enable encryption using this parameter. Copies of encrypted snapshots are encrypted,
     * even if this parameter is false or if encryption by default is not enabled.
     */
    val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The retention rule that indicates how long snapshot copies are to be retained in the
     * destination Region.
     */
    val retainRule: aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRetainRule? = builder.retainRule
    /**
     * The target Region or the Amazon Resource Name (ARN) of the target Outpost for the
     * snapshot copies.
     * Use this parameter instead of TargetRegion. Do not
     * specify both.
     */
    val target: kotlin.String? = builder.target
    /**
     * Avoid using this parameter when creating new policies. Instead, use Target
     * to specify a target Region or a target Outpost for snapshot copies.
     * For policies created before the Target parameter
     * was introduced, this parameter indicates the target Region for snapshot copies.
     */
    val targetRegion: kotlin.String? = builder.targetRegion

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CrossRegionCopyRule(")
        append("cmkArn=$cmkArn,")
        append("copyTags=$copyTags,")
        append("deprecateRule=$deprecateRule,")
        append("encrypted=$encrypted,")
        append("retainRule=$retainRule,")
        append("target=$target,")
        append("targetRegion=$targetRegion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cmkArn?.hashCode() ?: 0
        result = 31 * result + (copyTags?.hashCode() ?: 0)
        result = 31 * result + (deprecateRule?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (retainRule?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        result = 31 * result + (targetRegion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CrossRegionCopyRule

        if (cmkArn != other.cmkArn) return false
        if (copyTags != other.copyTags) return false
        if (deprecateRule != other.deprecateRule) return false
        if (encrypted != other.encrypted) return false
        if (retainRule != other.retainRule) return false
        if (target != other.target) return false
        if (targetRegion != other.targetRegion) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRule = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this
         * parameter is not specified, the default KMS key for the account is used.
         */
        var cmkArn: kotlin.String? = null
        /**
         * Indicates whether to copy all user-defined tags from the source snapshot to the cross-Region
         * snapshot copy.
         */
        var copyTags: kotlin.Boolean? = null
        /**
         * The AMI deprecation rule for cross-Region AMI copies created by the rule.
         */
        var deprecateRule: aws.sdk.kotlin.services.dlm.model.CrossRegionCopyDeprecateRule? = null
        /**
         * To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled,
         * enable encryption using this parameter. Copies of encrypted snapshots are encrypted,
         * even if this parameter is false or if encryption by default is not enabled.
         */
        var encrypted: kotlin.Boolean? = null
        /**
         * The retention rule that indicates how long snapshot copies are to be retained in the
         * destination Region.
         */
        var retainRule: aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRetainRule? = null
        /**
         * The target Region or the Amazon Resource Name (ARN) of the target Outpost for the
         * snapshot copies.
         * Use this parameter instead of TargetRegion. Do not
         * specify both.
         */
        var target: kotlin.String? = null
        /**
         * Avoid using this parameter when creating new policies. Instead, use Target
         * to specify a target Region or a target Outpost for snapshot copies.
         * For policies created before the Target parameter
         * was introduced, this parameter indicates the target Region for snapshot copies.
         */
        var targetRegion: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRule) : this() {
            this.cmkArn = x.cmkArn
            this.copyTags = x.copyTags
            this.deprecateRule = x.deprecateRule
            this.encrypted = x.encrypted
            this.retainRule = x.retainRule
            this.target = x.target
            this.targetRegion = x.targetRegion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRule = CrossRegionCopyRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.CrossRegionCopyDeprecateRule] inside the given [block]
         */
        fun deprecateRule(block: aws.sdk.kotlin.services.dlm.model.CrossRegionCopyDeprecateRule.Builder.() -> kotlin.Unit) {
            this.deprecateRule = aws.sdk.kotlin.services.dlm.model.CrossRegionCopyDeprecateRule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRetainRule] inside the given [block]
         */
        fun retainRule(block: aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRetainRule.Builder.() -> kotlin.Unit) {
            this.retainRule = aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRetainRule.invoke(block)
        }
    }
}
