// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model



/**
 * Specifies the encryption settings for shared snapshots that are copied across Regions.
 */
class EncryptionConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If
     * this parameter is not specified, the default KMS key for the account is used.
     */
    val cmkArn: kotlin.String? = builder.cmkArn
    /**
     * To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable
     * encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this
     * parameter is false or when encryption by default is not enabled.
     */
    val encrypted: kotlin.Boolean? = builder.encrypted

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.EncryptionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptionConfiguration(")
        append("cmkArn=$cmkArn,")
        append("encrypted=$encrypted)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cmkArn?.hashCode() ?: 0
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EncryptionConfiguration

        if (cmkArn != other.cmkArn) return false
        if (encrypted != other.encrypted) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.EncryptionConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If
         * this parameter is not specified, the default KMS key for the account is used.
         */
        var cmkArn: kotlin.String? = null
        /**
         * To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable
         * encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this
         * parameter is false or when encryption by default is not enabled.
         */
        var encrypted: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.EncryptionConfiguration) : this() {
            this.cmkArn = x.cmkArn
            this.encrypted = x.encrypted
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.EncryptionConfiguration = EncryptionConfiguration(this)
    }
}
