// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model



/**
 * Specifies an event that triggers an event-based policy.
 */
class EventParameters private constructor(builder: Builder) {
    /**
     * The snapshot description that can trigger the policy. The description pattern is specified using
     * a regular expression. The policy runs only if a snapshot with a description that matches the
     * specified pattern is shared with your account.
     * For example, specifying ^.*Created for policy: policy-1234567890abcdef0.*$
     * configures the policy to run only if snapshots created by policy policy-1234567890abcdef0
     * are shared with your account.
     */
    val descriptionRegex: kotlin.String? = builder.descriptionRegex
    /**
     * The type of event. Currently, only snapshot sharing events are supported.
     */
    val eventType: aws.sdk.kotlin.services.dlm.model.EventTypeValues? = builder.eventType
    /**
     * The IDs of the Amazon Web Services accounts that can trigger policy by sharing snapshots with your account.
     * The policy only runs if one of the specified Amazon Web Services accounts shares a snapshot with your account.
     */
    val snapshotOwner: List<String>? = builder.snapshotOwner

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.EventParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventParameters(")
        append("descriptionRegex=$descriptionRegex,")
        append("eventType=$eventType,")
        append("snapshotOwner=$snapshotOwner)")
    }

    override fun hashCode(): kotlin.Int {
        var result = descriptionRegex?.hashCode() ?: 0
        result = 31 * result + (eventType?.hashCode() ?: 0)
        result = 31 * result + (snapshotOwner?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventParameters

        if (descriptionRegex != other.descriptionRegex) return false
        if (eventType != other.eventType) return false
        if (snapshotOwner != other.snapshotOwner) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.EventParameters = Builder(this).apply(block).build()

    class Builder {
        /**
         * The snapshot description that can trigger the policy. The description pattern is specified using
         * a regular expression. The policy runs only if a snapshot with a description that matches the
         * specified pattern is shared with your account.
         * For example, specifying ^.*Created for policy: policy-1234567890abcdef0.*$
         * configures the policy to run only if snapshots created by policy policy-1234567890abcdef0
         * are shared with your account.
         */
        var descriptionRegex: kotlin.String? = null
        /**
         * The type of event. Currently, only snapshot sharing events are supported.
         */
        var eventType: aws.sdk.kotlin.services.dlm.model.EventTypeValues? = null
        /**
         * The IDs of the Amazon Web Services accounts that can trigger policy by sharing snapshots with your account.
         * The policy only runs if one of the specified Amazon Web Services accounts shares a snapshot with your account.
         */
        var snapshotOwner: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.EventParameters) : this() {
            this.descriptionRegex = x.descriptionRegex
            this.eventType = x.eventType
            this.snapshotOwner = x.snapshotOwner
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.EventParameters = EventParameters(this)
    }
}
