// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed information about a lifecycle policy.
 */
class LifecyclePolicy private constructor(builder: Builder) {
    /**
     * The local date and time when the lifecycle policy was created.
     */
    val dateCreated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateCreated
    /**
     * The local date and time when the lifecycle policy was last modified.
     */
    val dateModified: aws.smithy.kotlin.runtime.time.Instant? = builder.dateModified
    /**
     * The description of the lifecycle policy.
     */
    val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by
     * the lifecycle policy.
     */
    val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The Amazon Resource Name (ARN) of the policy.
     */
    val policyArn: kotlin.String? = builder.policyArn
    /**
     * The configuration of the lifecycle policy
     */
    val policyDetails: aws.sdk.kotlin.services.dlm.model.PolicyDetails? = builder.policyDetails
    /**
     * The identifier of the lifecycle policy.
     */
    val policyId: kotlin.String? = builder.policyId
    /**
     * The activation state of the lifecycle policy.
     */
    val state: aws.sdk.kotlin.services.dlm.model.GettablePolicyStateValues? = builder.state
    /**
     * The description of the status.
     */
    val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The tags.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.LifecyclePolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LifecyclePolicy(")
        append("dateCreated=$dateCreated,")
        append("dateModified=$dateModified,")
        append("description=$description,")
        append("executionRoleArn=$executionRoleArn,")
        append("policyArn=$policyArn,")
        append("policyDetails=$policyDetails,")
        append("policyId=$policyId,")
        append("state=$state,")
        append("statusMessage=$statusMessage,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dateCreated?.hashCode() ?: 0
        result = 31 * result + (dateModified?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (policyArn?.hashCode() ?: 0)
        result = 31 * result + (policyDetails?.hashCode() ?: 0)
        result = 31 * result + (policyId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LifecyclePolicy

        if (dateCreated != other.dateCreated) return false
        if (dateModified != other.dateModified) return false
        if (description != other.description) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (policyArn != other.policyArn) return false
        if (policyDetails != other.policyDetails) return false
        if (policyId != other.policyId) return false
        if (state != other.state) return false
        if (statusMessage != other.statusMessage) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.LifecyclePolicy = Builder(this).apply(block).build()

    class Builder {
        /**
         * The local date and time when the lifecycle policy was created.
         */
        var dateCreated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The local date and time when the lifecycle policy was last modified.
         */
        var dateModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the lifecycle policy.
         */
        var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by
         * the lifecycle policy.
         */
        var executionRoleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the policy.
         */
        var policyArn: kotlin.String? = null
        /**
         * The configuration of the lifecycle policy
         */
        var policyDetails: aws.sdk.kotlin.services.dlm.model.PolicyDetails? = null
        /**
         * The identifier of the lifecycle policy.
         */
        var policyId: kotlin.String? = null
        /**
         * The activation state of the lifecycle policy.
         */
        var state: aws.sdk.kotlin.services.dlm.model.GettablePolicyStateValues? = null
        /**
         * The description of the status.
         */
        var statusMessage: kotlin.String? = null
        /**
         * The tags.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.LifecyclePolicy) : this() {
            this.dateCreated = x.dateCreated
            this.dateModified = x.dateModified
            this.description = x.description
            this.executionRoleArn = x.executionRoleArn
            this.policyArn = x.policyArn
            this.policyDetails = x.policyDetails
            this.policyId = x.policyId
            this.state = x.state
            this.statusMessage = x.statusMessage
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.LifecyclePolicy = LifecyclePolicy(this)

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.PolicyDetails] inside the given [block]
         */
        fun policyDetails(block: aws.sdk.kotlin.services.dlm.model.PolicyDetails.Builder.() -> kotlin.Unit) {
            this.policyDetails = aws.sdk.kotlin.services.dlm.model.PolicyDetails.invoke(block)
        }
    }
}
