// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model



/**
 * Specifies the configuration of a lifecycle policy.
 */
class PolicyDetails private constructor(builder: Builder) {
    /**
     * The actions to be performed when the event-based policy is triggered. You can specify
     * only one action per policy.
     * This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter.
     */
    val actions: List<Action>? = builder.actions
    /**
     * The event that triggers the event-based policy.
     * This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter.
     */
    val eventSource: aws.sdk.kotlin.services.dlm.model.EventSource? = builder.eventSource
    /**
     * A set of optional parameters for snapshot and AMI lifecycle policies.
     * This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
     */
    val parameters: aws.sdk.kotlin.services.dlm.model.Parameters? = builder.parameters
    /**
     * The valid target resource types and actions a policy can manage. Specify EBS_SNAPSHOT_MANAGEMENT
     * to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify IMAGE_MANAGEMENT
     * to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify EVENT_BASED_POLICY
     * to create an event-based policy that performs specific actions when a defined event occurs in your Amazon Web Services account.
     * The default is EBS_SNAPSHOT_MANAGEMENT.
     */
    val policyType: aws.sdk.kotlin.services.dlm.model.PolicyTypeValues? = builder.policyType
    /**
     * The location of the resources to backup. If the source resources are located in an Amazon Web Services Region,
     * specify CLOUD. If the source resources are located on an Outpost
     * in your account, specify OUTPOST.
     * If you specify OUTPOST, Amazon Data Lifecycle Manager backs up all resources
     * of the specified type with matching target tags across all of the Outposts in your account.
     */
    val resourceLocations: List<ResourceLocationValues>? = builder.resourceLocations
    /**
     * The target resource type for snapshot and AMI lifecycle policies. Use VOLUME to
     * create snapshots of individual volumes or use INSTANCE to create multi-volume
     * snapshots from the volumes for an instance.
     * This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
     */
    val resourceTypes: List<ResourceTypeValues>? = builder.resourceTypes
    /**
     * The schedules of policy-defined actions for snapshot and AMI lifecycle policies. A policy
     * can have up to four schedules—one mandatory schedule and up to three optional schedules.
     * This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
     */
    val schedules: List<Schedule>? = builder.schedules
    /**
     * The single tag that identifies targeted resources for this policy.
     * This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
     */
    val targetTags: List<Tag>? = builder.targetTags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.PolicyDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyDetails(")
        append("actions=$actions,")
        append("eventSource=$eventSource,")
        append("parameters=$parameters,")
        append("policyType=$policyType,")
        append("resourceLocations=$resourceLocations,")
        append("resourceTypes=$resourceTypes,")
        append("schedules=$schedules,")
        append("targetTags=$targetTags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (eventSource?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (policyType?.hashCode() ?: 0)
        result = 31 * result + (resourceLocations?.hashCode() ?: 0)
        result = 31 * result + (resourceTypes?.hashCode() ?: 0)
        result = 31 * result + (schedules?.hashCode() ?: 0)
        result = 31 * result + (targetTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyDetails

        if (actions != other.actions) return false
        if (eventSource != other.eventSource) return false
        if (parameters != other.parameters) return false
        if (policyType != other.policyType) return false
        if (resourceLocations != other.resourceLocations) return false
        if (resourceTypes != other.resourceTypes) return false
        if (schedules != other.schedules) return false
        if (targetTags != other.targetTags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.PolicyDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The actions to be performed when the event-based policy is triggered. You can specify
         * only one action per policy.
         * This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter.
         */
        var actions: List<Action>? = null
        /**
         * The event that triggers the event-based policy.
         * This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter.
         */
        var eventSource: aws.sdk.kotlin.services.dlm.model.EventSource? = null
        /**
         * A set of optional parameters for snapshot and AMI lifecycle policies.
         * This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
         */
        var parameters: aws.sdk.kotlin.services.dlm.model.Parameters? = null
        /**
         * The valid target resource types and actions a policy can manage. Specify EBS_SNAPSHOT_MANAGEMENT
         * to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify IMAGE_MANAGEMENT
         * to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify EVENT_BASED_POLICY
         * to create an event-based policy that performs specific actions when a defined event occurs in your Amazon Web Services account.
         * The default is EBS_SNAPSHOT_MANAGEMENT.
         */
        var policyType: aws.sdk.kotlin.services.dlm.model.PolicyTypeValues? = null
        /**
         * The location of the resources to backup. If the source resources are located in an Amazon Web Services Region,
         * specify CLOUD. If the source resources are located on an Outpost
         * in your account, specify OUTPOST.
         * If you specify OUTPOST, Amazon Data Lifecycle Manager backs up all resources
         * of the specified type with matching target tags across all of the Outposts in your account.
         */
        var resourceLocations: List<ResourceLocationValues>? = null
        /**
         * The target resource type for snapshot and AMI lifecycle policies. Use VOLUME to
         * create snapshots of individual volumes or use INSTANCE to create multi-volume
         * snapshots from the volumes for an instance.
         * This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
         */
        var resourceTypes: List<ResourceTypeValues>? = null
        /**
         * The schedules of policy-defined actions for snapshot and AMI lifecycle policies. A policy
         * can have up to four schedules—one mandatory schedule and up to three optional schedules.
         * This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
         */
        var schedules: List<Schedule>? = null
        /**
         * The single tag that identifies targeted resources for this policy.
         * This parameter is required for snapshot and AMI policies only. If you are creating an event-based policy, omit this parameter.
         */
        var targetTags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.PolicyDetails) : this() {
            this.actions = x.actions
            this.eventSource = x.eventSource
            this.parameters = x.parameters
            this.policyType = x.policyType
            this.resourceLocations = x.resourceLocations
            this.resourceTypes = x.resourceTypes
            this.schedules = x.schedules
            this.targetTags = x.targetTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.PolicyDetails = PolicyDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.EventSource] inside the given [block]
         */
        fun eventSource(block: aws.sdk.kotlin.services.dlm.model.EventSource.Builder.() -> kotlin.Unit) {
            this.eventSource = aws.sdk.kotlin.services.dlm.model.EventSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.Parameters] inside the given [block]
         */
        fun parameters(block: aws.sdk.kotlin.services.dlm.model.Parameters.Builder.() -> kotlin.Unit) {
            this.parameters = aws.sdk.kotlin.services.dlm.model.Parameters.invoke(block)
        }
    }
}
