// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model



/**
 * Specifies a backup schedule for a snapshot or AMI lifecycle policy.
 */
class Schedule private constructor(builder: Builder) {
    /**
     * Copy all user-defined tags on a source volume to snapshots of the volume created by
     * this policy.
     */
    val copyTags: kotlin.Boolean = builder.copyTags
    /**
     * The creation rule.
     */
    val createRule: aws.sdk.kotlin.services.dlm.model.CreateRule? = builder.createRule
    /**
     * The rule for cross-Region snapshot copies.
     * You can only specify cross-Region copy rules for policies that create snapshots in a Region.
     * If the policy creates snapshots on an Outpost, then you cannot copy the snapshots to a Region or
     * to an Outpost. If the policy creates snapshots in a Region, then snapshots can be copied to up to three
     * Regions or Outposts.
     */
    val crossRegionCopyRules: List<CrossRegionCopyRule>? = builder.crossRegionCopyRules
    /**
     * The AMI deprecation rule for the schedule.
     */
    val deprecateRule: aws.sdk.kotlin.services.dlm.model.DeprecateRule? = builder.deprecateRule
    /**
     * The rule for enabling fast snapshot restore.
     */
    val fastRestoreRule: aws.sdk.kotlin.services.dlm.model.FastRestoreRule? = builder.fastRestoreRule
    /**
     * The name of the schedule.
     */
    val name: kotlin.String? = builder.name
    /**
     * The retention rule.
     */
    val retainRule: aws.sdk.kotlin.services.dlm.model.RetainRule? = builder.retainRule
    /**
     * The rule for sharing snapshots with other Amazon Web Services accounts.
     */
    val shareRules: List<ShareRule>? = builder.shareRules
    /**
     * The tags to apply to policy-created resources. These user-defined tags are in addition
     * to the Amazon Web Services-added lifecycle tags.
     */
    val tagsToAdd: List<Tag>? = builder.tagsToAdd
    /**
     * A collection of key/value pairs with values determined dynamically when the policy is
     * executed. Keys may be any valid Amazon EC2 tag key. Values must be in one of the two
     * following formats: $(instance-id) or $(timestamp). Variable
     * tags are only valid for EBS Snapshot Management – Instance policies.
     */
    val variableTags: List<Tag>? = builder.variableTags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.Schedule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Schedule(")
        append("copyTags=$copyTags,")
        append("createRule=$createRule,")
        append("crossRegionCopyRules=$crossRegionCopyRules,")
        append("deprecateRule=$deprecateRule,")
        append("fastRestoreRule=$fastRestoreRule,")
        append("name=$name,")
        append("retainRule=$retainRule,")
        append("shareRules=$shareRules,")
        append("tagsToAdd=$tagsToAdd,")
        append("variableTags=$variableTags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyTags.hashCode()
        result = 31 * result + (createRule?.hashCode() ?: 0)
        result = 31 * result + (crossRegionCopyRules?.hashCode() ?: 0)
        result = 31 * result + (deprecateRule?.hashCode() ?: 0)
        result = 31 * result + (fastRestoreRule?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (retainRule?.hashCode() ?: 0)
        result = 31 * result + (shareRules?.hashCode() ?: 0)
        result = 31 * result + (tagsToAdd?.hashCode() ?: 0)
        result = 31 * result + (variableTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Schedule

        if (copyTags != other.copyTags) return false
        if (createRule != other.createRule) return false
        if (crossRegionCopyRules != other.crossRegionCopyRules) return false
        if (deprecateRule != other.deprecateRule) return false
        if (fastRestoreRule != other.fastRestoreRule) return false
        if (name != other.name) return false
        if (retainRule != other.retainRule) return false
        if (shareRules != other.shareRules) return false
        if (tagsToAdd != other.tagsToAdd) return false
        if (variableTags != other.variableTags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.Schedule = Builder(this).apply(block).build()

    class Builder {
        /**
         * Copy all user-defined tags on a source volume to snapshots of the volume created by
         * this policy.
         */
        var copyTags: kotlin.Boolean = false
        /**
         * The creation rule.
         */
        var createRule: aws.sdk.kotlin.services.dlm.model.CreateRule? = null
        /**
         * The rule for cross-Region snapshot copies.
         * You can only specify cross-Region copy rules for policies that create snapshots in a Region.
         * If the policy creates snapshots on an Outpost, then you cannot copy the snapshots to a Region or
         * to an Outpost. If the policy creates snapshots in a Region, then snapshots can be copied to up to three
         * Regions or Outposts.
         */
        var crossRegionCopyRules: List<CrossRegionCopyRule>? = null
        /**
         * The AMI deprecation rule for the schedule.
         */
        var deprecateRule: aws.sdk.kotlin.services.dlm.model.DeprecateRule? = null
        /**
         * The rule for enabling fast snapshot restore.
         */
        var fastRestoreRule: aws.sdk.kotlin.services.dlm.model.FastRestoreRule? = null
        /**
         * The name of the schedule.
         */
        var name: kotlin.String? = null
        /**
         * The retention rule.
         */
        var retainRule: aws.sdk.kotlin.services.dlm.model.RetainRule? = null
        /**
         * The rule for sharing snapshots with other Amazon Web Services accounts.
         */
        var shareRules: List<ShareRule>? = null
        /**
         * The tags to apply to policy-created resources. These user-defined tags are in addition
         * to the Amazon Web Services-added lifecycle tags.
         */
        var tagsToAdd: List<Tag>? = null
        /**
         * A collection of key/value pairs with values determined dynamically when the policy is
         * executed. Keys may be any valid Amazon EC2 tag key. Values must be in one of the two
         * following formats: $(instance-id) or $(timestamp). Variable
         * tags are only valid for EBS Snapshot Management – Instance policies.
         */
        var variableTags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.Schedule) : this() {
            this.copyTags = x.copyTags
            this.createRule = x.createRule
            this.crossRegionCopyRules = x.crossRegionCopyRules
            this.deprecateRule = x.deprecateRule
            this.fastRestoreRule = x.fastRestoreRule
            this.name = x.name
            this.retainRule = x.retainRule
            this.shareRules = x.shareRules
            this.tagsToAdd = x.tagsToAdd
            this.variableTags = x.variableTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.Schedule = Schedule(this)

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.CreateRule] inside the given [block]
         */
        fun createRule(block: aws.sdk.kotlin.services.dlm.model.CreateRule.Builder.() -> kotlin.Unit) {
            this.createRule = aws.sdk.kotlin.services.dlm.model.CreateRule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.DeprecateRule] inside the given [block]
         */
        fun deprecateRule(block: aws.sdk.kotlin.services.dlm.model.DeprecateRule.Builder.() -> kotlin.Unit) {
            this.deprecateRule = aws.sdk.kotlin.services.dlm.model.DeprecateRule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.FastRestoreRule] inside the given [block]
         */
        fun fastRestoreRule(block: aws.sdk.kotlin.services.dlm.model.FastRestoreRule.Builder.() -> kotlin.Unit) {
            this.fastRestoreRule = aws.sdk.kotlin.services.dlm.model.FastRestoreRule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.RetainRule] inside the given [block]
         */
        fun retainRule(block: aws.sdk.kotlin.services.dlm.model.RetainRule.Builder.() -> kotlin.Unit) {
            this.retainRule = aws.sdk.kotlin.services.dlm.model.RetainRule.invoke(block)
        }
    }
}
